/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.intern;

import org.jutils.JUtilsException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.admin.CommandManager;
import org.xmlBlaster.engine.admin.CommandWrapper;
import org.xmlBlaster.engine.admin.I_CommandHandler;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;

public final class PropertyHandler
implements I_CommandHandler,
I_Plugin {
    private String ME = "PropertyHandler";
    private Global glob = null;
    private LogChannel log = null;
    private CommandManager commandManager = null;

    public void initialize(Global glob, CommandManager commandManager) {
        this.glob = glob;
        this.log = this.glob.getLog("admin");
        this.commandManager = commandManager;
        this.ME = "PropertyHandler" + this.glob.getLogPrefixDashed();
        this.commandManager.register("sysprop", this);
        this.log.info(this.ME, "Property administration plugin is initialized");
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) {
    }

    public String getType() {
        return "PropertyHandler";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getName() {
        return "PropertyHandler";
    }

    public synchronized MsgUnit[] get(String sessionId, CommandWrapper cmd) throws XmlBlasterException {
        if (cmd == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".get", "Please pass a command which is not null");
        }
        if (cmd.getTail() == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".get", "Please pass a command which has a valid property added, '" + cmd.getCommand() + "' is too short, aborted request.");
        }
        String cmdString = cmd.getTail().trim();
        if (cmdString.startsWith("?")) {
            cmdString = cmdString.substring(1);
        }
        String ret = null;
        if (this.isLogLevelRequest(cmdString)) {
            ret = "" + this.glob.getLogLevel(cmdString);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Checking log level '" + cmdString + "', is " + ret);
            }
        } else {
            ret = this.glob.getProperty().get(cmdString, (String)null);
        }
        this.log.info(this.ME, "Found for cmd " + cmdString + "=" + ret);
        if (ret == null) {
            return new MsgUnit[0];
        }
        MsgUnit[] msgs = new MsgUnit[]{new MsgUnit("<key oid='" + cmd.getCommand() + "' />", ret.getBytes(), "text/plain")};
        return msgs;
    }

    public String set(String sessionId, CommandWrapper cmd) throws XmlBlasterException {
        if (cmd == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".set", "Please pass a command which is not null");
        }
        if (cmd.getTail() == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".set", "Please pass a command which has a valid property added, '" + cmd.getCommand() + "' is too short, aborted request.");
        }
        String key = cmd.getKey();
        String value = cmd.getValue();
        if (this.isLogLevelRequest(key)) {
            boolean bool = this.glob.changeLogLevel(key, value.trim());
            this.log.info(this.ME, "Changed log level '" + key + "' to " + bool);
            return "" + bool;
        }
        try {
            String ret = this.glob.getProperty().set(key, value);
            this.log.info(this.ME, "Changed property '" + key + "' to " + ret);
            return ret;
        }
        catch (JUtilsException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME + ".set", e.id + " " + e.getMessage());
        }
    }

    private boolean isLogLevelRequest(String cmdString) {
        if (cmdString == null) {
            return false;
        }
        if ((cmdString = cmdString.toUpperCase()).startsWith("ERROR")) {
            return true;
        }
        if (cmdString.startsWith("WARN")) {
            return true;
        }
        if (cmdString.startsWith("INFO")) {
            return true;
        }
        if (cmdString.startsWith("CALL")) {
            return true;
        }
        if (cmdString.startsWith("TIME")) {
            return true;
        }
        if (cmdString.startsWith("TRACE")) {
            return true;
        }
        if (cmdString.startsWith("DUMP")) {
            return true;
        }
        return cmdString.startsWith("PLAIN");
    }

    public String help() {
        return "Administration of properties from system, xmlBlaster.properties and command line";
    }

    public String help(String cmd) {
        return this.help();
    }

    public void shutdown() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Shutdown ignored, nothing to do");
        }
    }
}

