/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.cluster;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.cluster.ClusterNode;
import org.xmlBlaster.engine.cluster.I_LoadBalancer;
import org.xmlBlaster.engine.cluster.I_MapMsgToMasterId;
import org.xmlBlaster.engine.cluster.LoadBalancerPluginManager;
import org.xmlBlaster.engine.cluster.MapMsgToMasterPluginManager;
import org.xmlBlaster.engine.cluster.NodeDomainInfo;
import org.xmlBlaster.engine.cluster.NodeParser;
import org.xmlBlaster.engine.cluster.PublishRetQosWrapper;
import org.xmlBlaster.engine.qos.EraseQosServer;
import org.xmlBlaster.engine.qos.GetQosServer;
import org.xmlBlaster.engine.qos.SubscribeQosServer;
import org.xmlBlaster.engine.qos.UnSubscribeQosServer;
import org.xmlBlaster.engine.runlevel.I_RunlevelListener;
import org.xmlBlaster.protocol.I_Driver;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.cluster.RouteInfo;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.QosData;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.Destination;

public final class ClusterManager
implements I_RunlevelListener {
    private String ME;
    private Global glob;
    private LogChannel log;
    private SessionInfo sessionInfo;
    private MapMsgToMasterPluginManager mapMsgToMasterPluginManager;
    private LoadBalancerPluginManager loadBalancerPluginManager;
    private I_LoadBalancer loadBalancer;
    public String pluginLoadBalancerType;
    public String pluginLoadBalancerVersion;
    private Map clusterNodeMap;
    private ClusterNode[] clusterNodesCache = new ClusterNode[0];
    private ClusterNode myClusterNode = null;
    private boolean postInitialized = false;
    private boolean lazyConnect = false;

    public ClusterManager(Global glob, SessionInfo sessionInfo) {
        this.glob = glob;
        this.sessionInfo = sessionInfo;
        this.log = this.glob.getLog("cluster");
        this.ME = "ClusterManager" + this.glob.getLogPrefixDashed();
        this.glob.getRunlevelManager().addRunlevelListener(this);
    }

    public void postInit() throws XmlBlasterException {
        this.pluginLoadBalancerType = this.glob.getProperty().get("cluster.loadBalancer.type", "RoundRobin");
        this.pluginLoadBalancerVersion = this.glob.getProperty().get("cluster.loadBalancer.version", "1.0");
        this.loadBalancerPluginManager = new LoadBalancerPluginManager(this.glob, this);
        this.loadBalancer = this.loadBalancerPluginManager.getPlugin(this.pluginLoadBalancerType, this.pluginLoadBalancerVersion);
        if (this.loadBalancer == null) {
            String tmp = "No load balancer plugin type='" + this.pluginLoadBalancerType + "' version='" + this.pluginLoadBalancerVersion + "' found, clustering switched off";
            this.log.error(this.ME, tmp);
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, this.ME, tmp);
        }
        this.clusterNodeMap = new TreeMap(new NodeComparator());
        this.mapMsgToMasterPluginManager = new MapMsgToMasterPluginManager(this.glob, this);
        if (this.glob.getNodeId() == null) {
            this.log.error(this.ME, "Node ID is still unknown, please set '-cluster.node.id' to a unique name.");
        } else {
            this.initClusterNode();
        }
        String[] env = new String[]{"cluster.node", "cluster.node.info", "cluster.node.master"};
        int ii = 0;
        while (ii < env.length) {
            Map nodeMap = this.glob.getProperty().get(env[ii], (Map)null);
            if (nodeMap != null) {
                Iterator iter = nodeMap.keySet().iterator();
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Found -" + env[ii] + " with " + nodeMap.size() + " array size, ii=" + ii);
                }
                while (iter.hasNext()) {
                    String nodeIdName = (String)iter.next();
                    String xml = (String)nodeMap.get(nodeIdName);
                    if (xml == null || xml.length() < 1) {
                        this.log.info(this.ME, "Ignoring envrionment setting -" + env[ii]);
                        continue;
                    }
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Parsing envrionment -" + env[ii] + " for node '" + nodeIdName + "' ...");
                    }
                    NodeParser nodeParser = new NodeParser(this.glob, this, xml, this.sessionInfo);
                    this.log.info(this.ME, "Envrionment for node '" + nodeIdName + "' parsed.");
                }
            }
            ++ii;
        }
        this.publish();
        this.subscribe();
        if (this.log.DUMP) {
            this.log.dump(this.ME, this.toXml());
        }
        this.log.info(this.ME, "Initialized and ready");
        this.postInitialized = true;
        if (!this.lazyConnect) {
            this.initConnections();
        }
    }

    public boolean blockUntilReady() {
        if (this.postInitialized) {
            return true;
        }
        int i = 0;
        while (i < 2000) {
            try {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.postInitialized) {
                return true;
            }
            ++i;
        }
        this.log.error(this.ME, "Waited for 20000 millis for cluster manager to be ready, giving up");
        return false;
    }

    public boolean isReady() {
        return this.postInitialized;
    }

    private void publish() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "publish() of cluster internal messages is missing");
        }
    }

    private void subscribe() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "subscribe() of cluster internal messages is missing");
        }
    }

    private void initClusterNode() throws XmlBlasterException {
        this.myClusterNode = new ClusterNode(this.glob, this.glob.getNodeId(), this.sessionInfo);
        this.addClusterNode(this.myClusterNode);
        Vector drivers = this.glob.getPluginRegistry().getPluginsOfInterfaceI_Driver();
        int i = 0;
        while (i < drivers.size()) {
            I_Driver driver = (I_Driver)drivers.get(i);
            String rawAddr = driver.getRawAddress();
            if (rawAddr != null) {
                Address addr = new Address(this.glob, driver.getProtocolId(), this.glob.getId());
                addr.setRawAddress(rawAddr);
                this.myClusterNode.getNodeInfo().addAddress(addr);
            }
            ++i;
        }
        if (drivers.size() > 0) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Setting " + drivers.size() + " addresses for cluster node '" + this.getId() + "'");
            }
        } else {
            this.log.error(this.ME, "ClusterNode is not properly initialized, no protocol pluging - no local xmlBlaster (node=" + this.getId() + ") address available");
            Thread.currentThread();
            Thread.dumpStack();
        }
    }

    public final boolean isLocalAddress(Address other) {
        return this.getMyClusterNode().getNodeInfo().contains(other);
    }

    public ClusterNode getMyClusterNode() {
        return this.myClusterNode;
    }

    public final NodeId getNodeId() {
        return this.glob.getNodeId();
    }

    public final String getId() {
        return this.glob.getId();
    }

    public MapMsgToMasterPluginManager getMapMsgToMasterPluginManager() {
        return this.mapMsgToMasterPluginManager;
    }

    public PublishReturnQos forwardPtpPublish(SessionInfo publisherSession, MsgUnit msgUnit, Destination destination) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering forwardPtpPublish(" + msgUnit.getLogId() + ", " + destination.getDestination() + ")");
        }
        if (destination.getDestination().getNodeId() == null) {
            return null;
        }
        ClusterNode clusterNode = this.getClusterNode(destination.getDestination().getNodeId());
        if (this.log.TRACE) {
            this.log.trace(this.ME, "PtP message '" + msgUnit.getLogId() + "' destination " + destination.getDestination() + " trying node " + (clusterNode == null ? "null" : clusterNode.getId()));
        }
        if (clusterNode == null) {
            ClusterNode[] clusterNodes = this.getClusterNodes();
            int i = 0;
            while (i < clusterNodes.length) {
                if (!clusterNodes[i].isLocalNode()) {
                    clusterNode = clusterNodes[i];
                    break;
                }
                ++i;
            }
            if (clusterNode == null) {
                String text = "Cluster node '" + destination.getDestination() + "' is not known, message '" + msgUnit.getLogId() + "' is lost";
                this.log.warn(this.ME, text);
                throw new XmlBlasterException(this.glob, ErrorCode.USER_PTP_UNKNOWNDESTINATION, this.ME, text);
            }
        }
        if (clusterNode.isLocalNode()) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "PtP message '" + msgUnit.getLogId() + "' destination " + destination.getDestination() + " destination cluster node reached");
            }
            return null;
        }
        I_XmlBlasterAccess con = clusterNode.getXmlBlasterAccess();
        if (con == null) {
            String text = "Cluster node '" + destination.getDestination() + "' is known but not reachable, message '" + msgUnit.getLogId() + "' is lost";
            this.log.warn(this.ME, text);
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CLUSTER_NOTAVAILABLE, this.ME, text);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "PtP message '" + msgUnit.getLogId() + "' destination " + destination.getDestination() + " is now forwarded to node " + clusterNode.getId());
        }
        return con.publish(msgUnit.getClone());
    }

    public PublishRetQosWrapper forwardPublish(SessionInfo publisherSession, MsgUnit msgUnit) throws XmlBlasterException {
        NodeDomainInfo nodeDomainInfo;
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering forwardPublish(" + msgUnit.getLogId() + ")");
        }
        if ((nodeDomainInfo = this.getConnection(publisherSession, msgUnit)) == null) {
            return null;
        }
        I_XmlBlasterAccess con = nodeDomainInfo.getClusterNode().getXmlBlasterAccess();
        if (con == null) {
            return null;
        }
        QosData publishQos = msgUnit.getQosData();
        if (nodeDomainInfo.getDirtyRead()) {
            RouteInfo[] ris = publishQos.getRouteNodes();
            if (ris == null || ris.length < 1) {
                this.log.error(this.ME, "The route info for '" + msgUnit.getLogId() + "' is missing");
                Thread.currentThread();
                Thread.dumpStack();
            } else {
                ris[ris.length - 1].setDirtyRead(true);
            }
        }
        MsgUnit msgUnitShallowClone = new MsgUnit(msgUnit, null, null, publishQos);
        return new PublishRetQosWrapper(nodeDomainInfo, con.publish(msgUnitShallowClone));
    }

    public SubscribeReturnQos forwardSubscribe(SessionInfo publisherSession, QueryKeyData xmlKey, SubscribeQosServer subscribeQos) throws XmlBlasterException {
        MsgUnit msgUnit;
        NodeDomainInfo nodeDomainInfo;
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering forwardSubscribe(" + xmlKey.getOid() + ")");
        }
        if ((nodeDomainInfo = this.getConnection(publisherSession, msgUnit = new MsgUnit(xmlKey, (byte[])null, subscribeQos.getData()))) == null) {
            return null;
        }
        I_XmlBlasterAccess con = nodeDomainInfo.getClusterNode().getXmlBlasterAccess();
        if (con == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "forwardSubscribe - Nothing to forward");
            }
            return null;
        }
        return con.subscribe(new SubscribeKey((org.xmlBlaster.util.Global)this.glob, xmlKey), new SubscribeQos(this.glob, subscribeQos.getData()));
    }

    public UnSubscribeReturnQos[] forwardUnSubscribe(SessionInfo publisherSession, QueryKeyData xmlKey, UnSubscribeQosServer unSubscribeQos) throws XmlBlasterException {
        MsgUnit msgUnit;
        NodeDomainInfo nodeDomainInfo;
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering forwardUnSubscribe(" + xmlKey.getOid() + ")");
        }
        if ((nodeDomainInfo = this.getConnection(publisherSession, msgUnit = new MsgUnit(xmlKey, (byte[])null, unSubscribeQos.getData()))) == null) {
            return null;
        }
        I_XmlBlasterAccess con = nodeDomainInfo.getClusterNode().getXmlBlasterAccess();
        if (con == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "forwardUnSubscribe - Nothing to forward");
            }
            return null;
        }
        return con.unSubscribe(new UnSubscribeKey((org.xmlBlaster.util.Global)this.glob, xmlKey), new UnSubscribeQos(this.glob, unSubscribeQos.getData()));
    }

    public MsgUnit[] forwardGet(SessionInfo publisherSession, QueryKeyData xmlKey, GetQosServer getQos) throws XmlBlasterException {
        MsgUnit msgUnit;
        NodeDomainInfo nodeDomainInfo;
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering forwardGet(" + xmlKey.getOid() + ")");
        }
        if ((nodeDomainInfo = this.getConnection(publisherSession, msgUnit = new MsgUnit(xmlKey, new byte[0], getQos.getData()))) == null) {
            return null;
        }
        I_XmlBlasterAccess con = nodeDomainInfo.getClusterNode().getXmlBlasterAccess();
        if (con == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "forwardGet - Nothing to forward");
            }
            return null;
        }
        return con.get(new GetKey((org.xmlBlaster.util.Global)this.glob, xmlKey), new GetQos(this.glob, getQos.getData()));
    }

    public EraseReturnQos[] forwardErase(SessionInfo publisherSession, QueryKeyData xmlKey, EraseQosServer eraseQos) throws XmlBlasterException {
        MsgUnit msgUnit;
        NodeDomainInfo nodeDomainInfo;
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering forwardErase(" + xmlKey.getOid() + ")");
        }
        if ((nodeDomainInfo = this.getConnection(publisherSession, msgUnit = new MsgUnit(xmlKey, new byte[0], eraseQos.getData()))) == null) {
            return null;
        }
        I_XmlBlasterAccess con = nodeDomainInfo.getClusterNode().getXmlBlasterAccess();
        if (con == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "forwardErase - Nothing to forward");
            }
            return null;
        }
        return con.erase(new EraseKey((org.xmlBlaster.util.Global)this.glob, xmlKey), new EraseQos(this.glob, eraseQos.getData()));
    }

    public final void addClusterNode(ClusterNode clusterNode) {
        if (clusterNode == null || clusterNode.getNodeId() == null) {
            Thread.currentThread();
            Thread.dumpStack();
            this.log.error(this.ME, "Illegal argument in addClusterNode()");
            throw new IllegalArgumentException("Illegal argument in addClusterNode()");
        }
        this.clusterNodesCache = null;
        this.clusterNodeMap.put(clusterNode.getId(), clusterNode);
    }

    public Map getClusterNodeMap() {
        return this.clusterNodeMap;
    }

    public ClusterNode[] getClusterNodes() {
        if (this.clusterNodesCache == null) {
            this.clusterNodesCache = this.clusterNodeMap == null ? new ClusterNode[0] : this.clusterNodeMap.values().toArray(new ClusterNode[this.clusterNodeMap.size()]);
        }
        return this.clusterNodesCache;
    }

    public int getNumNodes() {
        if (this.clusterNodeMap == null) {
            return 1;
        }
        return this.clusterNodeMap.size();
    }

    public final String getNodeList() {
        int numNodes = this.getNumNodes();
        if (numNodes <= 1) {
            return this.glob.getId();
        }
        StringBuffer sb = new StringBuffer(numNodes * 30);
        ClusterNode[] clusterNodes = this.getClusterNodes();
        int i = 0;
        while (i < clusterNodes.length) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(clusterNodes[i].getId());
            ++i;
        }
        return sb.toString();
    }

    public final ClusterNode getClusterNode(NodeId nodeId) {
        return this.getClusterNode(nodeId.getId());
    }

    public final ClusterNode getClusterNode(String id) {
        if (this.clusterNodeMap == null) {
            return null;
        }
        return (ClusterNode)this.clusterNodeMap.get(id);
    }

    private void initConnections() throws XmlBlasterException {
        Iterator it = this.getClusterNodeMap().values().iterator();
        while (it.hasNext()) {
            ClusterNode clusterNode = (ClusterNode)it.next();
            clusterNode.getXmlBlasterAccess();
        }
    }

    public final NodeDomainInfo getConnection(SessionInfo publisherSession, MsgUnit msgUnit) throws XmlBlasterException {
        NodeDomainInfo nodeDomainInfo;
        if (!this.postInitialized) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Entering getConnection(" + msgUnit.getLogId() + "), but clustering is not ready, handling in local node");
            }
            return null;
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering getConnection(" + msgUnit.getLogId() + "), testing " + this.getClusterNodeMap().size() + " known cluster nodes ...");
        }
        if (msgUnit.getQosData().isPublish() && msgUnit.getKeyData().isInternal()) {
            String keyOid = msgUnit.getKeyOid();
            if (keyOid.startsWith("__sys__cluster")) {
                this.log.error(this.ME, "Forwarding of '" + msgUnit.getLogId() + "' implementation is missing");
            }
            return null;
        }
        TreeSet<NodeDomainInfo> masterSet = new TreeSet<NodeDomainInfo>();
        int numRulesFound = 0;
        QosData publishQos = msgUnit.getQosData();
        if (publishQos.count(this.glob.getNodeId()) > 1) {
            this.log.warn(this.ME, "Warning, message '" + msgUnit.getLogId() + "' passed my node id='" + this.glob.getId() + "' before, we have a circular routing problem, keeping message locally");
            return null;
        }
        Iterator it = this.getClusterNodeMap().values().iterator();
        block0: while (it.hasNext()) {
            ClusterNode clusterNode = (ClusterNode)it.next();
            if (clusterNode.getDomainInfoMap().size() < 1) continue;
            if (!clusterNode.isAllowed()) {
                if (!this.log.TRACE) continue;
                this.log.trace(this.ME, "Ignoring master node id='" + clusterNode.getId() + "' because it is not available");
                continue;
            }
            if (!clusterNode.isLocalNode() && publishQos.count(clusterNode.getNodeId()) > 0) {
                if (!this.log.TRACE) continue;
                this.log.trace(this.ME, "Ignoring node id='" + clusterNode.getId() + "' for routing, message '" + msgUnit.getLogId() + "' has been there already");
                continue;
            }
            Iterator domains = clusterNode.getDomainInfoMap().values().iterator();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Testing " + clusterNode.getDomainInfoMap().size() + " domains rules of node " + clusterNode.getId() + " for " + msgUnit.getLogId());
            }
            numRulesFound += clusterNode.getDomainInfoMap().size();
            while (domains.hasNext()) {
                NodeDomainInfo nodeDomainInfo2 = (NodeDomainInfo)domains.next();
                I_MapMsgToMasterId domainMapper = this.mapMsgToMasterPluginManager.getMapMsgToMasterId(nodeDomainInfo2.getType(), nodeDomainInfo2.getVersion(), msgUnit.getContentMime(), msgUnit.getContentMimeExtended());
                if (domainMapper == null) {
                    this.log.warn(this.ME, "No domain mapping plugin type='" + nodeDomainInfo2.getType() + "' version='" + nodeDomainInfo2.getVersion() + "' found for message mime='" + msgUnit.getContentMime() + "' and '" + msgUnit.getContentMimeExtended() + "' ignoring rules " + nodeDomainInfo2.toXml());
                    continue;
                }
                if ((nodeDomainInfo2 = domainMapper.getMasterId(nodeDomainInfo2, msgUnit)) == null) continue;
                masterSet.add(nodeDomainInfo2);
                continue block0;
            }
        }
        if (masterSet.size() < 1) {
            if (numRulesFound == 0) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Using local node for message, no master mapping rules are known.");
                }
            } else {
                this.log.info(this.ME, "No master found for message '" + msgUnit.getLogId() + "' mime='" + msgUnit.getContentMime() + "' domain='" + msgUnit.getDomain() + "', using local node.");
            }
            return null;
        }
        if (masterSet.size() > 1 && this.log.TRACE) {
            this.log.trace(this.ME, masterSet.size() + " masters found for message '" + msgUnit.getLogId() + "' domain='" + msgUnit.getDomain() + "'");
        }
        if ((nodeDomainInfo = this.loadBalancer.getClusterNode(masterSet)) == null || nodeDomainInfo.getClusterNode().isLocalNode()) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using local node '" + this.getMyClusterNode().getId() + "' as master for message '" + msgUnit.getLogId() + "' domain='" + msgUnit.getDomain() + "'");
            }
            if (this.log.DUMP) {
                this.log.dump(this.ME, "Received message at master node: " + msgUnit.toXml());
            }
            return null;
        }
        if (this.log.TRACE) {
            this.log.info(this.ME, "Using master node '" + nodeDomainInfo.getClusterNode().getId() + "' for message '" + msgUnit.getLogId() + "' domain='" + msgUnit.getDomain() + "'");
        }
        return nodeDomainInfo;
    }

    public final I_XmlBlasterAccess getConnection(NodeId nodeId) {
        this.log.error(this.ME, "getConnection() is not implemented");
        return null;
    }

    public void shutdown() {
        if (this.clusterNodeMap != null && this.clusterNodeMap.size() > 0) {
            ClusterNode[] clusterNodes = this.getClusterNodes();
            int i = 0;
            while (i < clusterNodes.length) {
                clusterNodes[i].shutdown();
                ++i;
            }
            this.clusterNodesCache = null;
            this.clusterNodeMap.clear();
        }
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1024);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<clusterManager>");
        if (this.clusterNodeMap != null && this.clusterNodeMap.size() > 0) {
            ClusterNode[] clusterNodes = this.getClusterNodes();
            int i = 0;
            while (i < clusterNodes.length) {
                sb.append(clusterNodes[i].toXml(extraOffset + " "));
                ++i;
            }
        }
        sb.append(offset).append("</clusterManager>");
        return sb.toString();
    }

    public String getName() {
        return this.ME;
    }

    public void runlevelChange(int from, int to, boolean force) throws XmlBlasterException {
        if (to == from) {
            return;
        }
        if (!this.glob.useCluster()) {
            return;
        }
        if (to > from && to == 4) {
            this.postInit();
        }
        if (to < from && to == 3) {
            this.shutdown();
        }
    }

    public static String usage() {
        StringBuffer sb = new StringBuffer(512);
        sb.append("Cluster support:\n");
        sb.append("   -cluster            Switch cluster support to true or false [true].\n");
        sb.append("   -cluster.node.id    A unique name for this xmlBlaster instance, e.g. 'com.myCompany.myHost'.\n");
        sb.append("                       If not specified a unique name is chosen and displayed on command line.\n");
        sb.append("   ...                 See http://www.xmlBlaster.org/xmlBlaster/doc/requirements/cluster.html\n");
        return sb.toString();
    }

    class NodeComparator
    implements Comparator {
        NodeComparator() {
        }

        public final int compare(Object o1, Object o2) {
            String id1 = (String)o1;
            String id2 = (String)o2;
            if (id1.equals(id2)) {
                return 0;
            }
            if (id1.equals(ClusterManager.this.glob.getId())) {
                return -1;
            }
            if (id2.equals(ClusterManager.this.glob.getId())) {
                return 1;
            }
            return id1.compareTo(id2);
        }
    }
}

