/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.cluster;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.cluster.NodeDomainInfo;
import org.xmlBlaster.engine.cluster.NodeInfo;
import org.xmlBlaster.engine.cluster.NodeStateInfo;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.qos.ConnectQosData;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public final class ClusterNode
implements Comparable,
I_Callback,
I_ConnectionStateListener {
    private final String ME;
    private final Global fatherGlob;
    private final org.xmlBlaster.util.Global remoteGlob;
    private final LogChannel log;
    private final SessionInfo sessionInfo;
    private I_XmlBlasterAccess xmlBlasterConnection = null;
    private boolean available;
    private NodeInfo nodeInfo;
    private NodeStateInfo state;
    private Map domainInfoMap = new TreeMap();
    private boolean isAllowed = true;
    private String cbSessionId = null;
    private long counter = 0L;

    public ClusterNode(Global glob, NodeId nodeId, SessionInfo sessionInfo) {
        this.fatherGlob = glob;
        this.sessionInfo = sessionInfo;
        this.log = this.fatherGlob.getLog("cluster");
        this.remoteGlob = this.fatherGlob.getClone(new String[0]);
        this.nodeInfo = new NodeInfo(this.remoteGlob, nodeId);
        this.state = new NodeStateInfo(this.remoteGlob);
        this.ME = "ClusterNode" + this.remoteGlob.getLogPrefixDashed() + "-" + "/node/" + this.getId() + "/";
    }

    public String getId() {
        return this.nodeInfo.getId();
    }

    public NodeId getNodeId() {
        return this.nodeInfo.getNodeId();
    }

    public void setNodeId(NodeId nodeId) {
        this.nodeInfo.setNodeId(nodeId);
    }

    public I_XmlBlasterAccess getXmlBlasterAccess() throws XmlBlasterException {
        if (this.isLocalNode()) {
            return null;
        }
        if (!this.isAllowed()) {
            return null;
        }
        if (this.xmlBlasterConnection == null) {
            Address addr = this.getNodeInfo().getAddress();
            if (addr == null) {
                this.log.error(this.ME, "Can't connect to node '" + this.getId() + "', address is null");
                throw new XmlBlasterException(this.remoteGlob, ErrorCode.USER_CONFIGURATION, this.ME, "Can't connect to node '" + this.getId() + "', address is null");
            }
            this.remoteGlob.setBootstrapAddress(addr);
            this.xmlBlasterConnection = this.remoteGlob.getXmlBlasterAccess();
            this.xmlBlasterConnection.setServerNodeId(this.getId());
            this.xmlBlasterConnection.registerConnectionListener(this);
            CallbackAddress callback = this.nodeInfo.getCbAddress();
            if (callback.getSecretSessionId().equals("unknown")) {
                callback.setSecretSessionId(this.createCbSessionId());
            }
            this.cbSessionId = callback.getSecretSessionId();
            ConnectQosData qos = new ConnectQosData(this.remoteGlob, this.fatherGlob.getNodeId());
            qos.setClusterNode(true);
            qos.setDuplicateUpdates(false);
            qos.setUserId(this.remoteGlob.getId() + "/1");
            qos.setAddress(addr);
            qos.addCallbackAddress(callback);
            qos.getSessionQos().setSessionTimeout(0L);
            qos.getSessionQos().clearSessions(true);
            try {
                this.log.info(this.ME, "Trying to connect to node '" + this.getId() + "' on address '" + addr.getRawAddress() + "' using protocol=" + addr.getType());
                if (this.fatherGlob.getClusterManager().isLocalAddress(addr)) {
                    this.log.error(this.ME, "We want to connect to ourself, route to node'" + this.getId() + "' ignored: ConnectQos=" + qos.toXml());
                    return null;
                }
                if (this.log.DUMP) {
                    this.log.dump(this.ME, "Connecting to other cluster node, ConnectQos=" + qos.toXml());
                }
                ConnectReturnQos retQos = this.xmlBlasterConnection.connect(new ConnectQos(this.remoteGlob, qos), this);
            }
            catch (XmlBlasterException e) {
                this.log.warn(this.ME, "Connecting to " + this.getId() + " is currently not possible: " + e.toString());
                this.log.info(this.ME, "The connection is in failsafe mode and will queue messages until " + this.getId() + " is available");
            }
        }
        return this.xmlBlasterConnection;
    }

    public void resetXmlBlasterAccess() {
        if (this.xmlBlasterConnection != null) {
            if (this.xmlBlasterConnection.isConnected()) {
                this.xmlBlasterConnection.disconnect(null);
            }
            this.xmlBlasterConnection = null;
        }
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void setNodeInfo(NodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public NodeStateInfo getNodeStateInfo() {
        return this.state;
    }

    public void setNodeStateInfo(NodeStateInfo state) {
        this.state = state;
    }

    public Map getDomainInfoMap() {
        return this.domainInfoMap;
    }

    public void addDomainInfo(NodeDomainInfo domainInfo) {
        this.domainInfoMap.put("" + domainInfo.getCount(), domainInfo);
    }

    public boolean isConnected() throws XmlBlasterException {
        if (this.isLocalNode()) {
            return true;
        }
        I_XmlBlasterAccess con = this.getXmlBlasterAccess();
        if (con != null) {
            return con.isConnected();
        }
        return false;
    }

    public boolean isPolling() throws XmlBlasterException {
        if (this.isLocalNode()) {
            return false;
        }
        I_XmlBlasterAccess con = this.getXmlBlasterAccess();
        if (con != null) {
            return con.isPolling();
        }
        return false;
    }

    public boolean isAllowed() throws XmlBlasterException {
        if (this.isLocalNode()) {
            return true;
        }
        return this.isAllowed;
    }

    public int getConnectionState() throws XmlBlasterException {
        if (this.isConnected()) {
            return 0;
        }
        if (this.isPolling()) {
            return 1;
        }
        return 2;
    }

    public boolean isLocalNode() {
        return this.getId().equals(this.fatherGlob.getId());
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public int compareTo(Object obj) {
        ClusterNode n = (ClusterNode)obj;
        return this.getId().compareTo(n.getId());
    }

    public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.available = true;
        if (connection.getQueue().getNumOfEntries() > 0L) {
            this.log.info(this.ME, "Connected to xmlBlaster node '" + this.getId() + "', sending " + connection.getQueue().getNumOfEntries() + " tailback messages ...");
        } else {
            this.log.info(this.ME, "Connected to " + this.getId() + ", no backup messages to flush");
        }
    }

    public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.available = false;
        this.log.warn(this.ME, "I_ConnectionStateListener: No connection to xmlBlaster node '" + this.getId() + "', we are polling ...");
    }

    public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.available = false;
        this.log.error(this.ME, "I_ConnectionStateListener: No connection to xmlBlaster node '" + this.getId() + "', state=DEAD, giving up.");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        if (this.isLocalNode()) {
            this.log.error(this.ME, "Receiving unexpected update of message oid=" + updateKey.getOid() + " from xmlBlaster node '" + this.getId() + "' sessionId=" + cbSessionId);
            Thread.currentThread();
            Thread.dumpStack();
        } else if (this.log.CALL) {
            this.log.call(this.ME, "Receiving update of message oid=" + updateKey.getOid() + " from xmlBlaster node '" + this.getId() + "' sessionId=" + cbSessionId);
        }
        if (!this.cbSessionId.equals(cbSessionId)) {
            this.log.warn(this.ME + ".AccessDenied", "The callback sessionId '" + cbSessionId + "' is invalid, no access to " + this.remoteGlob.getId());
            throw new XmlBlasterException(updateKey.getGlobal(), ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, this.ME, "Your callback sessionId is invalid, no access to " + this.remoteGlob.getId());
        }
        String ret = this.fatherGlob.getRequestBroker().update(this.sessionInfo, updateKey, content, updateQos.getData());
        if (ret == null || ret.length() < 1) {
            return "<qos><state id='FORWARD_ERROR'/></qos>";
        }
        return "<qos><state id='OK'/></qos>";
    }

    private String createCbSessionId() throws XmlBlasterException {
        try {
            String ip = this.remoteGlob.getLocalIP();
            Random ran = new Random();
            StringBuffer buf = new StringBuffer(512);
            buf.append("sessionId:").append(ip).append("-").append(this.remoteGlob.getId()).append("-");
            buf.append(System.currentTimeMillis()).append("-").append(ran.nextInt()).append("-").append(this.counter++);
            String sessionId = buf.toString();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Created sessionId='" + sessionId + "'");
            }
            return sessionId;
        }
        catch (Exception e) {
            String text = "Can't generate a unique callback sessionId: " + e.toString();
            this.log.error(this.ME, text);
            throw new XmlBlasterException(this.remoteGlob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, this.ME, text);
        }
    }

    public void shutdown() {
        this.resetXmlBlasterAccess();
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(512);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<clusternode id='").append(this.getId()).append("'>");
        sb.append(this.getNodeInfo().toXml(extraOffset + " "));
        if (this.getDomainInfoMap() != null) {
            Iterator it = this.getDomainInfoMap().values().iterator();
            while (it.hasNext()) {
                NodeDomainInfo info = (NodeDomainInfo)it.next();
                sb.append(info.toXml(extraOffset + " "));
            }
        }
        sb.append(this.getNodeStateInfo().toXml(extraOffset + " "));
        sb.append(offset).append("</clusternode>");
        return sb.toString();
    }
}

