/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.cluster;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.cluster.ClusterManager;
import org.xmlBlaster.engine.cluster.I_MapMsgToMasterId;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.plugin.PluginManagerBase;

public class MapMsgToMasterPluginManager
extends PluginManagerBase {
    private static final String ME = "MapMsgToMasterPluginManager";
    private static final String defaultPluginName = "org.xmlBlaster.engine.cluster.simpledomain.DomainToMaster";
    public static final String pluginPropertyName = "MapMsgToMasterPlugin";
    private final Global glob;
    private final LogChannel log;
    private final ClusterManager clusterManager;
    private final Map mapMsgToMasterIdMap = Collections.synchronizedMap(new HashMap());

    public MapMsgToMasterPluginManager(Global glob, ClusterManager clusterManager) {
        super(glob);
        this.glob = glob;
        this.log = this.glob.getLog("cluster");
        this.clusterManager = clusterManager;
    }

    private final I_MapMsgToMasterId getPlugin(String type, String version) throws XmlBlasterException {
        return (I_MapMsgToMasterId)((Object)this.getPluginObject(type, version));
    }

    public void postInstantiate(I_Plugin plugin, PluginInfo pluginInfo) {
        ((I_MapMsgToMasterId)((Object)plugin)).initialize(this.glob, this.clusterManager);
    }

    protected final String getPluginPropertyName() {
        return pluginPropertyName;
    }

    public final String getDefaultPluginName(String type, String version) {
        return defaultPluginName;
    }

    public final I_MapMsgToMasterId getMapMsgToMasterId(String type, String version, String mime, String mimeExtended) {
        try {
            StringBuffer key = new StringBuffer(80);
            key.append(type).append(version).append(mime).append(mimeExtended);
            Object obj = this.mapMsgToMasterIdMap.get(key.toString());
            if (obj != null) {
                return (I_MapMsgToMasterId)obj;
            }
            key.setLength(0);
            key.append(type).append(version).append("*");
            obj = this.mapMsgToMasterIdMap.get(key.toString());
            if (obj != null) {
                return (I_MapMsgToMasterId)obj;
            }
            return this.addMapMsgToMasterIdPlugin(type, version);
        }
        catch (Exception e) {
            this.log.error(ME, "Problems accessing cluster domain mapping " + this.createPluginPropertyKey(type, version) + " mime=" + mime + " mimeExtended=" + mimeExtended + ": " + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    private final I_MapMsgToMasterId addMapMsgToMasterIdPlugin(String type, String version) {
        StringBuffer key = new StringBuffer(80);
        key.append(type).append(version);
        Object obj = this.mapMsgToMasterIdMap.get(key.toString());
        if (obj != null) {
            if (this.log.TRACE) {
                this.log.trace(ME, "Plugin '" + key.toString() + "' is loaded already");
            }
            return (I_MapMsgToMasterId)obj;
        }
        try {
            int ii;
            I_MapMsgToMasterId plugin = this.getPlugin(type, version);
            if (plugin == null) {
                this.log.error(ME, "Problems accessing plugin " + this.createPluginPropertyKey(type, version) + ", please check your configuration");
                return null;
            }
            this.mapMsgToMasterIdMap.put(key.toString(), plugin);
            key.setLength(0);
            String[] mime = plugin.getMimeTypes();
            String[] mimeExtended = plugin.getMimeExtended();
            if (mimeExtended == null || mimeExtended.length != mime.length) {
                if (mimeExtended.length != mime.length) {
                    this.log.error(ME, this.createPluginPropertyKey(type, version) + ": Number of mimeExtended does not match mime, ignoring mimeExtended.");
                }
                mimeExtended = new String[mime.length];
                ii = 0;
                while (ii < mime.length) {
                    mimeExtended[ii] = "1.0";
                    ++ii;
                }
            }
            ii = 0;
            while (ii < mime.length) {
                key.append(type).append(version).append(mime[ii]).append(mimeExtended[ii]);
                this.mapMsgToMasterIdMap.put(key.toString(), plugin);
                this.log.info(ME, "Loaded '" + key.toString() + "'");
                key.setLength(0);
                ++ii;
            }
            return plugin;
        }
        catch (Throwable e) {
            this.log.error(ME, "Problems accessing cluster domain mapping plugin manager, can't instantiate " + this.createPluginPropertyKey(type, version) + ": " + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    public void reset() {
        Iterator it = this.mapMsgToMasterIdMap.values().iterator();
        while (it.hasNext()) {
            I_MapMsgToMasterId i = (I_MapMsgToMasterId)it.next();
            i.reset();
        }
    }
}

