/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.cluster;

import java.util.ArrayList;
import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.cluster.ClusterNode;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.AccessFilterQos;

public final class NodeDomainInfo
implements Comparable {
    private String ME = "NodeDomainInfo";
    private final Global glob;
    private final LogChannel log;
    private final ClusterNode clusterNode;
    private static int counter = 0;
    private final int count;
    private int stratum = 0;
    public final boolean DEFAULT_acceptDefault = true;
    private boolean acceptDefault = true;
    public final boolean DEFAULT_acceptOtherDefault = false;
    private boolean acceptOtherDefault = false;
    private String refId = null;
    private String type = null;
    public static final String DEFAULT_version = "1.0";
    private String version;
    private String query = "";
    private boolean dirtyRead = false;
    private int inMaster = 0;
    private transient AccessFilterQos tmpFilter = null;
    protected ArrayList filterList = null;
    protected transient AccessFilterQos[] filterArr = null;
    private transient boolean inFilter = false;
    private transient QueryKeyData tmpKey = null;
    protected ArrayList keyList = null;
    private QueryKeyData[] keyArr;
    private transient boolean inKey = false;
    static /* synthetic */ Class class$org$xmlBlaster$engine$cluster$NodeDomainInfo;

    public NodeDomainInfo(Global glob, ClusterNode clusterNode) {
        this.glob = glob;
        this.log = this.glob.getLog("cluster");
        this.clusterNode = clusterNode;
        this.ME = this.ME + "-" + this.glob.getId();
        Class clazz = class$org$xmlBlaster$engine$cluster$NodeDomainInfo == null ? (class$org$xmlBlaster$engine$cluster$NodeDomainInfo = NodeDomainInfo.class$("org.xmlBlaster.engine.cluster.NodeDomainInfo")) : class$org$xmlBlaster$engine$cluster$NodeDomainInfo;
        synchronized (clazz) {
            this.count = counter++;
        }
        this.version = glob.getProperty().get("cluster.domainMapper.version", DEFAULT_version);
    }

    public int getCount() {
        return this.count;
    }

    public ClusterNode getClusterNode() {
        return this.clusterNode;
    }

    public NodeId getNodeId() {
        return this.clusterNode.getNodeId();
    }

    public String getId() {
        return this.getNodeId().getId();
    }

    public QueryKeyData[] getKeyMappings() {
        if (this.keyArr != null || this.keyList == null || this.keyList.size() < 1) {
            return this.keyArr;
        }
        this.keyArr = new QueryKeyData[this.keyList.size()];
        this.keyList.toArray(this.keyArr);
        return this.keyArr;
    }

    public void setKeyMappings(QueryKeyData[] keyArr) {
        this.keyArr = keyArr;
    }

    public final AccessFilterQos[] getAccessFilterArr() {
        if (this.filterArr != null || this.filterList == null || this.filterList.size() < 1) {
            return this.filterArr;
        }
        this.filterArr = new AccessFilterQos[this.filterList.size()];
        this.filterList.toArray(this.filterArr);
        return this.filterArr;
    }

    public void setStratum(int stratum) {
        if (stratum < 0) {
            throw new IllegalArgumentException("NodeDomainInfo: stratum can't be small zero");
        }
        this.stratum = stratum;
    }

    public int getStratum() {
        return this.stratum;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    public String getRefId() {
        return this.refId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setAcceptDefault(boolean acceptDefault) {
        this.acceptDefault = acceptDefault;
    }

    public boolean getAcceptDefault() {
        return this.acceptDefault;
    }

    public void setAcceptOtherDefault(boolean acceptOtherDefault) {
        this.acceptOtherDefault = acceptOtherDefault;
    }

    public boolean getAcceptOtherDefault() {
        return this.acceptOtherDefault;
    }

    public boolean getDirtyRead() {
        return this.dirtyRead;
    }

    public void setDirtyRead(boolean dirtyRead) {
        this.dirtyRead = dirtyRead;
    }

    public final boolean startElement(String uri, String localName, String name, StringBuffer character, Attributes attrs) {
        if (name.equalsIgnoreCase("master")) {
            ++this.inMaster;
            if (this.inMaster > 1) {
                return false;
            }
            if (attrs != null) {
                String tmp = attrs.getValue("stratum");
                if (tmp != null) {
                    try {
                        this.setStratum(Integer.parseInt(tmp.trim()));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(this.ME, "Invalid <master stratum='" + tmp + "'");
                    }
                }
                if ((tmp = attrs.getValue("refid")) != null) {
                    this.setRefId(tmp.trim());
                }
                if ((tmp = attrs.getValue("type")) != null) {
                    this.setType(tmp.trim());
                }
                if ((tmp = attrs.getValue("version")) != null) {
                    this.setVersion(tmp.trim());
                }
                if ((tmp = attrs.getValue("acceptDefault")) != null) {
                    try {
                        this.setAcceptDefault(Boolean.valueOf(tmp.trim()));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(this.ME, "Invalid <master acceptDefault='" + tmp + "'");
                    }
                }
                if ((tmp = attrs.getValue("acceptOtherDefault")) != null) {
                    try {
                        this.setAcceptOtherDefault(Boolean.valueOf(tmp.trim()));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(this.ME, "Invalid <master acceptOtherDefault='" + tmp + "'");
                    }
                }
                if ((tmp = attrs.getValue("dirtyRead")) != null) {
                    try {
                        this.setDirtyRead(Boolean.valueOf(tmp.trim()));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(this.ME, "Invalid <master dirtyRead='" + tmp + "'");
                    }
                }
            }
            character.setLength(0);
            if (this.getType() == null) {
                this.log.warn(this.ME, "Missing 'master' attribute 'type', ignoring the master request");
                this.setType(null);
                return false;
            }
            return true;
        }
        if (this.inMaster == 1 && name.equalsIgnoreCase("key")) {
            this.inKey = true;
        }
        if (this.inMaster == 1 && name.equalsIgnoreCase("filter")) {
            this.inFilter = true;
            this.tmpFilter = new AccessFilterQos(this.glob);
            boolean ok = this.tmpFilter.startElement(uri, localName, name, character, attrs);
            if (ok) {
                if (this.filterList == null) {
                    this.filterList = new ArrayList();
                    this.filterArr = null;
                }
                this.filterList.add(this.tmpFilter);
            } else {
                this.tmpFilter = null;
            }
            return ok;
        }
        if (this.inKey) {
            character.append("<").append(name);
            if (attrs != null) {
                int len = attrs.getLength();
                int ii = 0;
                while (ii < len) {
                    character.append(" ").append(attrs.getQName(ii)).append("='").append(attrs.getValue(ii)).append("'");
                    ++ii;
                }
            }
            character.append(">");
            return true;
        }
        return false;
    }

    public final void endElement(String uri, String localName, String name, StringBuffer character) {
        if (name.equalsIgnoreCase("master")) {
            --this.inMaster;
            if (this.inMaster > 0) {
                return;
            }
            character.setLength(0);
        }
        if (this.inKey) {
            character.append("</" + name + ">");
        }
        if (this.inMaster == 1 && name.equalsIgnoreCase("key")) {
            this.inKey = false;
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Parsing filter xmlKey=" + character.toString());
            }
            try {
                this.tmpKey = this.glob.getQueryKeyFactory().readObject(character.toString());
                if (this.keyList == null) {
                    this.keyList = new ArrayList();
                }
                this.keyList.add(this.tmpKey);
            }
            catch (XmlBlasterException e) {
                this.log.warn(this.ME, "Parsing <master>" + character.toString() + " failed, ignoring this rule: " + e.toString());
            }
            character.setLength(0);
            return;
        }
        if (this.inMaster == 1 && name.equalsIgnoreCase("filter")) {
            this.inFilter = false;
            if (this.tmpFilter != null) {
                this.tmpFilter.endElement(uri, localName, name, character);
            }
            return;
        }
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(300);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<master");
        if (this.getStratum() > 0) {
            sb.append(" stratum='").append(this.getStratum()).append("'");
        }
        if (this.getRefId() != null) {
            sb.append(" refId='").append(this.getRefId()).append("'");
        }
        sb.append(" type='").append(this.getType()).append("'");
        if (!DEFAULT_version.equals(this.getVersion())) {
            sb.append(" version='").append(this.getVersion()).append("'");
        }
        if (!this.getAcceptDefault()) {
            sb.append(" acceptDefault='").append(this.getAcceptDefault()).append("'");
        }
        if (this.getAcceptOtherDefault()) {
            sb.append(" acceptOtherDefault='").append(this.getAcceptOtherDefault()).append("'");
        }
        if (this.getDirtyRead()) {
            sb.append(" dirtyRead='").append(this.getDirtyRead()).append("'");
        }
        sb.append(">");
        QueryKeyData[] keyArr = this.getKeyMappings();
        int ii = 0;
        while (keyArr != null && ii < keyArr.length) {
            sb.append(keyArr[ii].toXml(extraOffset + " "));
            ++ii;
        }
        AccessFilterQos[] filterArr = this.getAccessFilterArr();
        int ii2 = 0;
        while (filterArr != null && ii2 < filterArr.length) {
            sb.append(filterArr[ii2].toXml(extraOffset + " "));
            ++ii2;
        }
        sb.append(offset).append("</master>");
        return sb.toString();
    }

    public int compareTo(Object obj) {
        NodeDomainInfo a = (NodeDomainInfo)obj;
        try {
            if (this.getClusterNode().getConnectionState() != a.getClusterNode().getConnectionState()) {
                return this.getClusterNode().getConnectionState() - a.getClusterNode().getConnectionState();
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Unexpected exception in compareTo(), no sorting for connection state possible: " + e.toString());
        }
        if (this.getStratum() != a.getStratum()) {
            return this.getStratum() - a.getStratum();
        }
        return this.getCount() - a.getCount();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

