/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.cluster;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public final class NodeInfo {
    private final String ME;
    private final Global glob;
    private NodeId nodeId;
    private String defaultType;
    private Address tmpAddress = null;
    private Map addressMap = null;
    private CallbackAddress tmpCbAddress = null;
    private Map cbAddressMap = null;
    private Map backupnodeMap = null;
    private boolean nameService = false;
    private boolean inAddress = false;
    private boolean inCallback = false;
    private boolean inBackupnode = false;

    public NodeInfo(Global glob, NodeId nodeId) {
        this.glob = glob;
        this.setNodeId(nodeId);
        this.ME = "NodeInfo." + this.getId();
    }

    public String getId() {
        return this.nodeId.getId();
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(NodeId nodeId) {
        if (nodeId == null) {
            throw new IllegalArgumentException("NodeInfo.setNodeId(): NodeId argument is null");
        }
        this.nodeId = nodeId;
    }

    public Address getAddress() {
        if (this.addressMap == null) {
            return null;
        }
        if (this.defaultType == null) {
            Address def = new Address(this.glob);
            this.defaultType = def.getType();
        }
        if (this.defaultType != null) {
            Iterator it = this.addressMap.values().iterator();
            while (it.hasNext()) {
                Address tmp = (Address)it.next();
                if (!this.defaultType.equals(tmp.getType())) continue;
                return tmp;
            }
        }
        return (Address)this.addressMap.values().iterator().next();
    }

    public void addAddress(Address address) {
        if (this.addressMap == null) {
            this.addressMap = new TreeMap();
        }
        this.addressMap.put("" + this.addressMap.size(), address);
    }

    public final Map getAddressMap() {
        return this.addressMap;
    }

    public boolean contains(Address other) {
        if (this.addressMap == null || this.addressMap.size() == 0) {
            return false;
        }
        Iterator it = this.addressMap.values().iterator();
        while (it.hasNext()) {
            Address aa = (Address)it.next();
            if (!aa.isSameAddress(other)) continue;
            return true;
        }
        return false;
    }

    public CallbackAddress getCbAddress() {
        if (this.cbAddressMap == null) {
            this.addCbAddress(new CallbackAddress(this.glob));
        }
        return (CallbackAddress)this.cbAddressMap.values().iterator().next();
    }

    public Map getCbAddressMap() {
        return this.cbAddressMap;
    }

    public void addCbAddress(CallbackAddress cbAddress) {
        if (this.cbAddressMap == null) {
            this.cbAddressMap = new TreeMap();
        }
        this.cbAddressMap.put(cbAddress.getRawAddress(), cbAddress);
    }

    public boolean isNameService() {
        return this.nameService;
    }

    public void setNameService(boolean nameService) {
        this.nameService = nameService;
    }

    public Map getBackupnodeMap() {
        return this.backupnodeMap;
    }

    public void addBackupnode(NodeId backupId) {
        if (this.backupnodeMap == null) {
            this.backupnodeMap = new TreeMap();
        }
        this.backupnodeMap.put(backupId.getId(), backupId);
    }

    public final boolean startElement(String uri, String localName, String name, StringBuffer character, Attributes attrs) {
        if (name.equalsIgnoreCase("info")) {
            return true;
        }
        if (this.inAddress) {
            if (this.tmpAddress == null) {
                return false;
            }
            this.tmpAddress.startElement(uri, localName, name, character, attrs);
            return true;
        }
        if (name.equalsIgnoreCase("address")) {
            this.inAddress = true;
            String type = attrs != null ? attrs.getValue("type") : null;
            this.tmpAddress = new Address(this.glob, type, this.getId());
            this.tmpAddress.startElement(uri, localName, name, character, attrs);
            return true;
        }
        if (name.equalsIgnoreCase("callback")) {
            this.inCallback = true;
            this.tmpCbAddress = new CallbackAddress(this.glob);
            this.tmpCbAddress.startElement(uri, localName, name, character, attrs);
            return true;
        }
        if (name.equalsIgnoreCase("backupnode")) {
            this.inBackupnode = true;
            return true;
        }
        if (this.inBackupnode && name.equalsIgnoreCase("clusternode")) {
            if (attrs != null) {
                String tmp = attrs.getValue("id");
                if (tmp == null) {
                    this.glob.getLog("cluster").error(this.ME, "<backupnode><clusternode> attribute 'id' is missing, ignoring message");
                    throw new RuntimeException("NodeParser: <backupnode><clusternode> attribute 'id' is missing, ignoring message");
                }
                this.addBackupnode(new NodeId(tmp.trim()));
            }
            return true;
        }
        return false;
    }

    public final void endElement(String uri, String localName, String name, StringBuffer character) {
        if (this.inAddress) {
            this.tmpAddress.endElement(uri, localName, name, character);
            if (name.equalsIgnoreCase("address")) {
                this.inAddress = false;
                this.addAddress(this.tmpAddress);
            }
            return;
        }
        if (this.inCallback) {
            this.tmpCbAddress.endElement(uri, localName, name, character);
            if (name.equalsIgnoreCase("callback")) {
                this.inCallback = false;
                this.addCbAddress(this.tmpCbAddress);
            }
            return;
        }
        if (name.equalsIgnoreCase("backupnode")) {
            this.inBackupnode = false;
            character.setLength(0);
            return;
        }
        character.setLength(0);
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        Object info;
        Iterator it;
        StringBuffer sb = new StringBuffer(512);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<info>");
        if (this.getAddressMap() != null && this.getAddressMap().size() > 0) {
            it = this.getAddressMap().values().iterator();
            while (it.hasNext()) {
                info = (Address)it.next();
                sb.append(((AddressBase)info).toXml(extraOffset + " "));
            }
        }
        if (this.getCbAddressMap() != null && this.getCbAddressMap().size() > 0) {
            it = this.getCbAddressMap().values().iterator();
            while (it.hasNext()) {
                info = (CallbackAddress)it.next();
                sb.append(((AddressBase)info).toXml(extraOffset + " "));
            }
        }
        if (this.getBackupnodeMap() != null && this.getBackupnodeMap().size() > 0) {
            it = this.getBackupnodeMap().values().iterator();
            sb.append(offset).append("   <backupnode>");
            while (it.hasNext()) {
                info = (NodeId)it.next();
                sb.append(offset).append("      <clusternode id='").append(((NodeId)info).getId()).append("'/>");
            }
            sb.append(offset).append("   </backupnode>");
        }
        sb.append(offset).append("</info>");
        return sb.toString();
    }
}

