/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.cluster;

import org.xml.sax.Attributes;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.cluster.ClusterManager;
import org.xmlBlaster.engine.cluster.ClusterNode;
import org.xmlBlaster.engine.cluster.NodeDomainInfo;
import org.xmlBlaster.engine.cluster.NodeInfo;
import org.xmlBlaster.engine.cluster.NodeStateInfo;
import org.xmlBlaster.util.SaxHandlerBase;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.cluster.NodeId;

public class NodeParser
extends SaxHandlerBase {
    private String ME = "NodeParser";
    private final Global glob;
    private final ClusterManager clusterManager;
    private String id = null;
    private int inClusternode = 0;
    private ClusterNode tmpClusterNode = null;
    private boolean inInfo = false;
    private NodeInfo tmpNodeInfo = null;
    private boolean inMaster = false;
    private NodeDomainInfo tmpMaster = null;
    private boolean inState = false;
    private NodeStateInfo tmpState = null;
    private final SessionInfo sessionInfo;

    public NodeParser(Global glob, ClusterManager clusterManager, String xml, SessionInfo sessionInfo) throws XmlBlasterException {
        this.glob = glob;
        this.clusterManager = clusterManager;
        this.sessionInfo = sessionInfo;
        this.init(xml);
    }

    private final String getId() {
        if (this.id == null) {
            this.glob.getLog("cluster").warn(this.ME, "cluster node id is null");
        }
        return this.id;
    }

    public ClusterNode getClusterNode() {
        return this.tmpClusterNode;
    }

    public final void startElement(String uri, String localName, String name, Attributes attrs) {
        if (name.equalsIgnoreCase("clusternode")) {
            ++this.inClusternode;
            if (this.inClusternode == 1) {
                if (attrs != null) {
                    this.id = attrs.getValue("id");
                    if (this.id == null) {
                        this.glob.getLog("cluster").error(this.ME, "<clusternode> attribute 'id' is missing, ignoring message");
                        throw new RuntimeException("NodeParser: <clusternode> attribute 'id' is missing, ignoring message");
                    }
                    this.id = this.id.trim();
                    this.tmpClusterNode = this.clusterManager.getClusterNode(this.id);
                    if (this.tmpClusterNode == null) {
                        this.tmpClusterNode = new ClusterNode(this.glob, new NodeId(this.id), this.sessionInfo);
                        this.clusterManager.addClusterNode(this.tmpClusterNode);
                    }
                }
                return;
            }
        }
        if (this.inMaster) {
            if (this.tmpMaster == null) {
                this.glob.getLog("cluster").error(this.ME, "Internal problem in <master> section");
                return;
            }
            this.tmpMaster.startElement(uri, localName, name, this.character, attrs);
            return;
        }
        if (name.equalsIgnoreCase("master")) {
            if (this.inClusternode != 1) {
                return;
            }
            this.inMaster = true;
            this.tmpMaster = new NodeDomainInfo(this.glob, this.tmpClusterNode);
            if (this.tmpMaster.startElement(uri, localName, name, this.character, attrs)) {
                this.tmpClusterNode.addDomainInfo(this.tmpMaster);
            } else {
                this.tmpMaster = null;
            }
            return;
        }
        if (this.inState) {
            if (this.tmpState == null) {
                return;
            }
            this.tmpState.startElement(uri, localName, name, this.character, attrs);
            return;
        }
        if (name.equalsIgnoreCase("state")) {
            if (this.inClusternode != 1) {
                return;
            }
            this.inState = true;
            this.tmpState = new NodeStateInfo(this.glob);
            if (this.tmpState.startElement(uri, localName, name, this.character, attrs)) {
                this.tmpClusterNode.setNodeStateInfo(this.tmpState);
            } else {
                this.glob.getLog("cluster").error(this.ME, "Internal problem in <state> section");
                this.tmpState = null;
            }
            this.character.setLength(0);
            return;
        }
        if (this.inInfo) {
            if (this.tmpNodeInfo == null) {
                return;
            }
            this.tmpNodeInfo.startElement(uri, localName, name, this.character, attrs);
            return;
        }
        if (name.equalsIgnoreCase("info")) {
            if (this.inClusternode != 1) {
                return;
            }
            this.inInfo = true;
            this.tmpNodeInfo = new NodeInfo(this.glob, this.tmpClusterNode.getNodeId());
            if (this.tmpNodeInfo.startElement(uri, localName, name, this.character, attrs)) {
                this.tmpClusterNode.setNodeInfo(this.tmpNodeInfo);
            } else {
                this.glob.getLog("cluster").error(this.ME, "Internal problem in <info> section");
                this.tmpNodeInfo = null;
            }
            this.character.setLength(0);
            return;
        }
        this.glob.getLog("cluster").warn(this.ME, "startElement: Ignoring unknown name=" + name + " character='" + this.character.toString() + "' inClusternode=" + this.inClusternode);
    }

    public void endElement(String uri, String localName, String name) {
        if (name.equalsIgnoreCase("clusternode")) {
            --this.inClusternode;
            if (this.inClusternode == 0) {
                return;
            }
        }
        if (name.equalsIgnoreCase("master") && this.inClusternode == 1) {
            this.inMaster = false;
            this.tmpMaster.endElement(uri, localName, name, this.character);
            return;
        }
        if (this.inMaster) {
            this.tmpMaster.endElement(uri, localName, name, this.character);
            return;
        }
        if (name.equalsIgnoreCase("state")) {
            this.inState = false;
            if (this.tmpState == null) {
                return;
            }
            this.tmpState.endElement(uri, localName, name, this.character);
            return;
        }
        if (this.inState) {
            if (this.tmpState == null) {
                return;
            }
            this.tmpState.endElement(uri, localName, name, this.character);
            return;
        }
        if (name.equalsIgnoreCase("info")) {
            this.inInfo = false;
            if (this.tmpNodeInfo == null) {
                return;
            }
            this.tmpNodeInfo.endElement(uri, localName, name, this.character);
            return;
        }
        if (this.inInfo) {
            if (this.tmpNodeInfo == null) {
                return;
            }
            this.tmpNodeInfo.endElement(uri, localName, name, this.character);
            return;
        }
        this.glob.getLog("cluster").warn(this.ME, "endElement: Ignoring unknown name=" + name + " character='" + this.character.toString() + "' inClusternode=" + this.inClusternode);
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        try {
            String xml = "<clusternode id='heron.mycomp.com'> <!-- original xml markup -->\n   <info>\n     <address type='IOR'>IOR:09456087000</address>\n     <address type='XMLRPC'>http://www.mycomp.com/XMLRPC/</address>\n     <callback type='RMI'>rmi://mycomp.com</callback>\n     <backupnode>\n        <clusternode id='bilbo.mycomp.com'/>\n        <clusternode id='aragon.mycomp.com'/>\n     </backupnode>\n   </info>\n   <master type='DomainToMaster' version='0.9'>\n     <key queryType='DOMAIN' domain='RUGBY'/>\n     <key queryType='XPATH'>//STOCK</key>\n     <filter type='ContentLength'>\n       8000\n     </filter>\n     <filter type='ContainsChecker' version='7.1' xy='true'>\n       bug\n     </filter>\n     <someOtherPluginfilter>\n        <![CDATA[\n        ]]>\n     </someOtherPluginfilter>\n   </master>\n   <master type='DomainToMaster' version='1.1'>\n     //RUGBY\n   </master>\n   <state>\n     <cpu id='0' idle='40'/>\n     <cpu id='1' idle='44'/>\n     <ram free='12000'/>\n   </state>\n</clusternode>\n";
            System.out.println("\nFull Message from client ...");
            NodeParser nodeParser = new NodeParser(glob, glob.getClusterManager(), xml, null);
            System.out.println(nodeParser.getClusterNode().toXml());
            xml = "<clusternode id='heron.mycomp.com'>\n   <master stratum='1' refid='frodo' type='DomainPlugin' version='2.0' acceptDefault='false' acceptOtherDefault='true'>\n     My own rule\n   </master>\n   <state>\n     <cpu id='0' idle='60'/>\n     <cpu id='1' idle='58'/>\n     <ram free='10657'/>\n   </state>\n</clusternode>\n";
            System.out.println("\nFull Message from client ...");
            nodeParser = new NodeParser(glob, glob.getClusterManager(), xml, null);
            System.out.println(nodeParser.getClusterNode().toXml());
        }
        catch (Throwable e) {
            e.printStackTrace();
            glob.getLog(null).error("TestFailed", e.toString());
        }
    }
}

