/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.cluster;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xmlBlaster.util.Global;

public class NodeStateInfo {
    private static final String ME = "NodeStateInfo";
    private final Global glob;
    private int freeRam = -1;
    private Map cpuMap = new TreeMap();
    private int avgCpuIdle = -1;

    public NodeStateInfo(Global glob) {
        this.glob = glob;
    }

    public int getFreeRam() {
        return this.freeRam;
    }

    public void setFreeRam(int freeRam) {
        this.freeRam = freeRam;
    }

    public int getAvgCpuIdle() {
        return this.avgCpuIdle;
    }

    public void setCpu(int id, int idle) {
        Cpu cpu = (Cpu)this.cpuMap.get("" + id);
        if (cpu == null) {
            this.cpuMap.put("" + id, new Cpu(id, idle));
        } else {
            cpu.idle = idle;
        }
        if (this.cpuMap.size() == 1) {
            this.avgCpuIdle = idle;
        } else {
            int sum = 0;
            Iterator it = this.cpuMap.values().iterator();
            while (it.hasNext()) {
                cpu = (Cpu)it.next();
                sum += cpu.idle;
            }
            this.avgCpuIdle = sum / this.cpuMap.size();
        }
    }

    public final boolean startElement(String uri, String localName, String name, StringBuffer character, Attributes attrs) {
        if (name.equalsIgnoreCase("state")) {
            return true;
        }
        if (name.equalsIgnoreCase("cpu")) {
            if (attrs != null) {
                int id = 0;
                String tmp = attrs.getValue("id");
                if (tmp != null) {
                    try {
                        id = Integer.parseInt(tmp.trim());
                    }
                    catch (NumberFormatException e) {
                        this.glob.getLog("cluster").error(ME, "Invalid <cpu id='" + tmp + "'");
                    }
                }
                int idle = 50;
                tmp = attrs.getValue("idle");
                if (tmp != null) {
                    try {
                        idle = Integer.parseInt(tmp.trim());
                    }
                    catch (NumberFormatException e) {
                        this.glob.getLog("cluster").error(ME, "Invalid <cpu idle='" + tmp + "'");
                    }
                }
                this.setCpu(id, idle);
            }
            character.setLength(0);
            return true;
        }
        if (name.equalsIgnoreCase("ram")) {
            String tmp;
            if (attrs != null && (tmp = attrs.getValue("free")) != null) {
                try {
                    this.setFreeRam(Integer.parseInt(tmp.trim()));
                }
                catch (NumberFormatException e) {
                    this.glob.getLog("cluster").error(ME, "Invalid <ram free='" + tmp + "'");
                }
            }
            character.setLength(0);
            return true;
        }
        return false;
    }

    public final void endElement(String uri, String localName, String name, StringBuffer character) {
        character.setLength(0);
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer();
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<state>");
        Iterator it = this.cpuMap.values().iterator();
        while (it.hasNext()) {
            Cpu cpu = (Cpu)it.next();
            sb.append(offset).append(" <cpu id='").append(cpu.id).append("' idle='").append(cpu.idle).append("'/>");
        }
        if (this.getFreeRam() >= 0) {
            sb.append(offset).append(" <ram free='").append(this.getFreeRam()).append("'/>");
        }
        sb.append(offset).append("</state>");
        return sb.toString();
    }

    class Cpu {
        int id;
        int idle;

        public Cpu(int id, int idle) {
            this.id = id;
            this.idle = idle;
        }
    }
}

