/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.cluster.simpledomain;

import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.TopicHandler;
import org.xmlBlaster.engine.cluster.ClusterManager;
import org.xmlBlaster.engine.cluster.I_MapMsgToMasterId;
import org.xmlBlaster.engine.cluster.NodeDomainInfo;
import org.xmlBlaster.engine.mime.I_AccessFilter;
import org.xmlBlaster.engine.xml2java.XmlKey;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.AccessFilterQos;
import org.xmlBlaster.util.qos.MsgQosData;

public final class DomainToMaster
implements I_Plugin,
I_MapMsgToMasterId {
    private String ME = "DomainToMaster";
    private Global glob;
    private LogChannel log;
    private ClusterManager clusterManager;

    public void initialize(Global glob, ClusterManager clusterManager) {
        this.glob = glob;
        this.log = glob.getLog("cluster");
        this.clusterManager = clusterManager;
        this.ME = this.ME + "-" + this.glob.getId();
        this.log.info(this.ME, "The simple domain based master mapper plugin is initialized");
    }

    public void reset() {
        this.log.warn(this.ME, "New configuration, nothing to do");
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) {
    }

    public String getType() {
        return "SimpleDomainToMasterMapper";
    }

    public String getVersion() {
        return "1.0";
    }

    public String[] getMimeTypes() {
        String[] mimeTypes = new String[]{"*"};
        return mimeTypes;
    }

    public String[] getMimeExtended() {
        String[] mimeExtended = new String[]{"1.0"};
        return mimeExtended;
    }

    public String getName() {
        return "SimpleDomainToMasterMapper";
    }

    public NodeDomainInfo getMasterId(NodeDomainInfo nodeDomainInfo, MsgUnit msgUnit) throws XmlBlasterException {
        SessionInfo sessionInfo;
        I_AccessFilter filter;
        int jj;
        AccessFilterQos[] filterQos;
        MsgQosData qos;
        if (msgUnit.getQosData() instanceof MsgQosData && (qos = (MsgQosData)msgUnit.getQosData()).isPtp()) {
            this.log.info(this.ME, "Checking if PtP message shall be forwarded to other cluster node");
            this.log.error(this.ME, "PtP cluster support is not implemented");
            return null;
        }
        QueryKeyData[] keyMappings = nodeDomainInfo.getKeyMappings();
        Object clusterNode = null;
        XmlKey xmlKey = null;
        int ii = 0;
        while (keyMappings != null && ii < keyMappings.length) {
            if (ii == 0) {
                TopicHandler topicHandler = this.glob.getRequestBroker().getMessageHandlerFromOid(msgUnit.getKeyOid());
                xmlKey = topicHandler != null && topicHandler.hasXmlKey() ? topicHandler.getXmlKey() : new XmlKey(this.glob, msgUnit.getKeyData());
            }
            if (xmlKey.match(keyMappings[ii])) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Found master='" + nodeDomainInfo.getNodeId().getId() + "' stratum=" + nodeDomainInfo.getStratum() + " for message '" + msgUnit.getLogId() + "' domain='" + xmlKey.getDomain() + "'.");
                }
                if ((filterQos = keyMappings[ii].getAccessFilterArr()) != null && filterQos.length > 0) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Found " + filterQos.length + " key specific filter rules in XmlKey ...");
                    }
                    jj = 0;
                    while (jj < filterQos.length) {
                        filter = this.glob.getRequestBroker().getAccessPluginManager().getAccessFilter(filterQos[jj].getType(), filterQos[jj].getVersion(), msgUnit.getContentMime(), msgUnit.getContentMimeExtended());
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "Checking filter='" + filterQos[jj].getQuery() + "' on message content='" + msgUnit.getContentStr() + "'");
                        }
                        sessionInfo = null;
                        if (filter != null && filter.match(sessionInfo, msgUnit, filterQos[jj].getQuery())) {
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "Found master='" + nodeDomainInfo.getNodeId().getId() + "' stratum=" + nodeDomainInfo.getStratum() + " for message '" + msgUnit.getLogId() + "' with filter='" + filterQos[jj].getQuery() + "'.");
                            }
                            return nodeDomainInfo;
                        }
                        ++jj;
                    }
                } else {
                    return nodeDomainInfo;
                }
            }
            ++ii;
        }
        filterQos = nodeDomainInfo.getAccessFilterArr();
        if (filterQos != null && filterQos.length > 0) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Found " + filterQos.length + " global filter rules ...");
            }
            jj = 0;
            while (jj < filterQos.length) {
                filter = this.glob.getRequestBroker().getAccessPluginManager().getAccessFilter(filterQos[jj].getType(), filterQos[jj].getVersion(), msgUnit.getContentMime(), msgUnit.getContentMimeExtended());
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Checking filter='" + filterQos[jj].getQuery() + "' on message content='" + msgUnit.getContentStr() + "'");
                }
                sessionInfo = null;
                if (filter != null && filter.match(sessionInfo, msgUnit, filterQos[jj].getQuery())) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Found master='" + nodeDomainInfo.getNodeId().getId() + "' stratum=" + nodeDomainInfo.getStratum() + " for message '" + msgUnit.getLogId() + "' with filter='" + filterQos[jj].getQuery() + "'.");
                    }
                    return nodeDomainInfo;
                }
                ++jj;
            }
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Node '" + nodeDomainInfo.getId() + "' is not master for message '" + msgUnit.getKeyData().toXml() + "' with given rules=" + nodeDomainInfo.toXml());
        }
        return null;
    }

    public void shutdown() throws XmlBlasterException {
    }
}

