/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.cluster.simpledomain;

import java.util.Iterator;
import java.util.Set;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.cluster.ClusterManager;
import org.xmlBlaster.engine.cluster.I_LoadBalancer;
import org.xmlBlaster.engine.cluster.NodeDomainInfo;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;

public final class RoundRobin
implements I_LoadBalancer,
I_Plugin {
    private String ME = "RoundRobin";
    private Global glob = null;
    private LogChannel log = null;
    private ClusterManager clusterManager = null;
    private int counter = 0;

    public void initialize(Global glob, ClusterManager clusterManager) {
        this.glob = glob;
        this.log = this.glob.getLog("cluster");
        this.clusterManager = clusterManager;
        this.ME = this.ME + "-" + glob.getId();
        this.log.info(this.ME, "Round robin load balancer is initialized");
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) {
    }

    public String getType() {
        return "RoundRobin";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getName() {
        return "RoundRobin";
    }

    public synchronized NodeDomainInfo getClusterNode(Set nodeDomainInfoSet) throws XmlBlasterException {
        NodeDomainInfo nodeDomainInfo;
        if (nodeDomainInfoSet.size() == 0) {
            this.log.warn(this.ME, "Empty nodeDomainInfoSet, using local node");
            return null;
        }
        if (this.counter >= nodeDomainInfoSet.size()) {
            this.counter = 0;
        }
        int myStratum = Integer.MAX_VALUE;
        Iterator it = nodeDomainInfoSet.iterator();
        boolean ii = false;
        while (it.hasNext()) {
            nodeDomainInfo = (NodeDomainInfo)it.next();
            if (!nodeDomainInfo.getClusterNode().isLocalNode() || nodeDomainInfo.getStratum() >= myStratum) continue;
            myStratum = nodeDomainInfo.getStratum();
            break;
        }
        it = nodeDomainInfoSet.iterator();
        if (it.hasNext()) {
            nodeDomainInfo = (NodeDomainInfo)it.next();
            if (myStratum <= nodeDomainInfo.getStratum()) {
                if (nodeDomainInfo.getStratum() > 0) {
                    this.log.warn(this.ME, "Selected myself as master node from a choice of " + nodeDomainInfoSet.size() + " nodes, but we are only stratum=" + nodeDomainInfo.getStratum() + ". The message is not routed further!");
                } else if (this.log.TRACE) {
                    this.log.trace(this.ME, "Selected myself as master node from a choice of " + nodeDomainInfoSet.size() + " nodes");
                }
                return null;
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Selected master node id='" + nodeDomainInfo.getClusterNode().getId() + "' from a choice of " + nodeDomainInfoSet.size() + " nodes");
            }
            return nodeDomainInfo;
        }
        this.log.warn(this.ME, "Can't find master, using local node");
        return null;
    }

    public void shutdown() throws XmlBlasterException {
    }
}

