/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.dispatch;

import org.xmlBlaster.authentication.plugins.I_MsgSecurityInterceptor;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.dispatch.CbDispatchConnectionsHandler;
import org.xmlBlaster.engine.qos.UpdateReturnQosServer;
import org.xmlBlaster.engine.queuemsg.MsgQueueUpdateEntry;
import org.xmlBlaster.protocol.I_CallbackDriver;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.dispatch.DispatchConnection;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class CbDispatchConnection
extends DispatchConnection {
    public final String ME;
    private I_CallbackDriver cbDriver = null;
    private String cbKey = null;

    public CbDispatchConnection(org.xmlBlaster.util.Global glob, CbDispatchConnectionsHandler connectionsHandler, AddressBase address) throws XmlBlasterException {
        super(glob, connectionsHandler, address);
        this.ME = "CbDispatchConnection-" + connectionsHandler.getDispatchManager().getQueue().getStorageId();
    }

    public final String getName() {
        return this.ME;
    }

    public void setAddress(AddressBase address) throws XmlBlasterException {
        super.setAddress(address);
        if (this.cbDriver == null || !this.cbDriver.isAlive()) {
            this.loadPlugin();
        }
        this.cbDriver.init(this.glob, (CallbackAddress)address);
    }

    public final String getDriverName() {
        return this.cbDriver != null ? this.cbDriver.getName() : "unknown";
    }

    public final void loadPlugin() throws XmlBlasterException {
        this.cbKey = this.address.getType() + this.address.getRawAddress();
        this.cbDriver = this.glob.getNativeCallbackDriver(this.cbKey);
        if (this.cbDriver == null) {
            this.cbDriver = ((Global)this.glob).getCbProtocolManager().getNewCbProtocolDriverInstance(this.address.getType());
            if (this.cbDriver == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, this.ME, "Sorry, callback protocol type='" + this.address.getType() + "' is not supported");
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Created callback plugin '" + this.address.getType() + "'");
            }
        } else if (this.log.TRACE) {
            this.log.trace(this.ME, "Created native callback driver for protocol '" + this.address.getType() + "'");
        }
    }

    public final void connectLowlevel() throws XmlBlasterException {
        this.cbDriver.init(this.glob, (CallbackAddress)this.address);
        this.cbDriver.ping("");
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Connected low level to callback '" + this.address.getType() + "'");
        }
    }

    public void doSend(MsgQueueEntry[] msgArr_) throws XmlBlasterException {
        MsgUnitRaw[] msgUnitRawArr = new MsgUnitRaw[msgArr_.length];
        int i = 0;
        while (i < msgUnitRawArr.length) {
            MsgQueueUpdateEntry entry = (MsgQueueUpdateEntry)msgArr_[i];
            MsgUnit mu = entry.getMsgUnit();
            MsgQosData msgQosData = (MsgQosData)entry.getMsgQosData().clone();
            msgQosData.setTopicProperty(null);
            msgQosData.setState(entry.getState());
            msgQosData.setSubscriptionId(entry.getSubscriptionId());
            msgQosData.setQueueIndex(i);
            msgQosData.setQueueSize(msgUnitRawArr.length);
            if (msgQosData.getNumRouteNodes() == 1) {
                msgQosData.clearRoutes();
            }
            mu = new MsgUnit(mu, null, null, msgQosData);
            msgUnitRawArr[i] = new MsgUnitRaw(mu, mu.getKeyData().toXml(), mu.getContent(), mu.getQosData().toXml());
            ++i;
        }
        I_MsgSecurityInterceptor securityInterceptor = this.connectionsHandler.getDispatchManager().getMsgSecurityInterceptor();
        if (securityInterceptor != null) {
            int i2 = 0;
            while (i2 < msgUnitRawArr.length) {
                msgUnitRawArr[i2] = securityInterceptor.exportMessage(msgUnitRawArr[i2], MethodName.UNKNOWN);
                ++i2;
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Exported/encrypted " + msgUnitRawArr.length + " messages.");
            }
        } else {
            this.log.warn(this.ME + ".accessDenied", "No session security context, sending " + msgUnitRawArr.length + " messages without encryption");
        }
        String[] rawReturnVal = null;
        if (this.address.oneway()) {
            this.cbDriver.sendUpdateOneway(msgUnitRawArr);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Success, sent " + msgUnitRawArr.length + " oneway messages.");
            }
        } else {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Before update " + msgUnitRawArr.length + " acknowledged messages ...");
            }
            rawReturnVal = this.cbDriver.sendUpdate(msgUnitRawArr);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Success, sent " + msgUnitRawArr.length + " acknowledged messages, return value #1 is '" + rawReturnVal[0] + "'");
            }
        }
        this.connectionsHandler.getDispatchStatistic().incrNumUpdate(rawReturnVal.length);
        if (rawReturnVal != null) {
            int i3 = 0;
            while (i3 < rawReturnVal.length) {
                if (msgArr_[i3].wantReturnObj()) {
                    if (securityInterceptor != null) {
                        rawReturnVal[i3] = securityInterceptor.importMessage(rawReturnVal[i3]);
                    }
                    try {
                        msgArr_[i3].setReturnObj(new UpdateReturnQosServer(this.glob, rawReturnVal[i3]));
                    }
                    catch (Throwable e) {
                        this.log.warn(this.ME, "Can't parse returned value '" + rawReturnVal[i3] + "', setting to default: " + e.toString());
                        UpdateReturnQosServer updateRetQos = new UpdateReturnQosServer(this.glob, "<qos/>");
                        updateRetQos.setException(e);
                        msgArr_[i3].setReturnObj(updateRetQos);
                    }
                }
                ++i3;
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Imported/decrypted " + rawReturnVal.length + " message return values.");
            }
        }
    }

    public final String doPing(String data) throws XmlBlasterException {
        String ret = this.cbDriver.ping(data);
        return ret == null ? "" : ret;
    }

    public final void resetConnection() {
    }

    protected final void reconnect() throws XmlBlasterException {
        this.cbDriver.init(this.glob, (CallbackAddress)this.address);
    }

    public final void shutdown() throws XmlBlasterException {
        super.shutdown();
        this.glob.removeNativeCallbackDriver(this.cbKey);
        if (this.cbDriver != null) {
            this.cbDriver.shutdown();
        }
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        String offset = "\n   ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset + "<CbDispatchConnection>");
        this.address.toXml("   " + offset);
        if (this.cbDriver == null) {
            sb.append(offset).append("   <noCallbackDriver />");
        } else {
            sb.append(offset).append("   <callback type='" + this.getDriverName() + "' state='" + this.getState() + "'/>");
        }
        sb.append(offset).append("</CbDispatchConnection>");
        return sb.toString();
    }
}

