/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.dispatch;

import org.xmlBlaster.engine.dispatch.CbDispatchConnection;
import org.xmlBlaster.engine.qos.UpdateReturnQosServer;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.dispatch.DispatchConnection;
import org.xmlBlaster.util.dispatch.DispatchConnectionsHandler;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.qos.StatusQosData;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class CbDispatchConnectionsHandler
extends DispatchConnectionsHandler {
    public final String ME;

    public CbDispatchConnectionsHandler(Global glob, DispatchManager dispatchManager) throws XmlBlasterException {
        super(glob, dispatchManager);
        this.ME = "CbDispatchConnectionsHandler-" + dispatchManager.getQueue().getStorageId();
    }

    public DispatchConnection createDispatchConnection(AddressBase address) throws XmlBlasterException {
        CbDispatchConnection c = new CbDispatchConnection(this.glob, this, address);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "createDispatchConnection for address='" + address.toXml() + "'");
        }
        c.loadPlugin();
        return c;
    }

    public void createFakedReturnObjects(I_QueueEntry[] entries, String state, String stateInfo) {
        int ii = 0;
        while (ii < entries.length) {
            MsgQueueEntry msgQueueEntry = (MsgQueueEntry)entries[ii];
            if (msgQueueEntry.wantReturnObj()) {
                StatusQosData statRetQos = new StatusQosData(this.glob, MethodName.UPDATE);
                statRetQos.setStateInfo(stateInfo);
                statRetQos.setState(state);
                if ("update_ref".equalsIgnoreCase(msgQueueEntry.getEmbeddedType())) {
                    UpdateReturnQosServer ret = new UpdateReturnQosServer(this.glob, statRetQos);
                    msgQueueEntry.setReturnObj(ret);
                } else {
                    this.log.error(this.ME, "Internal problem, MsgQueueEntry '" + msgQueueEntry.getEmbeddedType() + "' not expected here");
                }
            }
            ++ii;
        }
    }
}

