/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.distributor.plugins;

import java.util.ArrayList;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.SubscriptionEvent;
import org.xmlBlaster.engine.SubscriptionInfo;
import org.xmlBlaster.engine.TopicHandler;
import org.xmlBlaster.engine.distributor.I_MsgDistributor;
import org.xmlBlaster.engine.distributor.plugins.ConsumableQueueWorker;
import org.xmlBlaster.engine.qos.UpdateReturnQosServer;
import org.xmlBlaster.engine.queuemsg.MsgQueueHistoryEntry;
import org.xmlBlaster.engine.queuemsg.MsgQueueUpdateEntry;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.dispatch.DispatchWorker;
import org.xmlBlaster.util.dispatch.I_ConnectionStatusListener;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public class ConsumableQueuePlugin
implements I_MsgDistributor,
I_ConnectionStatusListener {
    private static final String ME = "ConsumableQueuePlugin";
    boolean isReady = false;
    boolean isRunning;
    private Global global;
    private LogChannel log;
    private PluginInfo pluginInfo;
    private TopicHandler topicHandler;

    private void toRunning() {
        if (this.log.CALL) {
            this.log.call(ME, "toRunning, isRunning='" + this.isRunning + "' isReady='" + this.isReady + "'");
        }
        if (this.isRunning || !this.isReady) {
            return;
        }
        this.isRunning = true;
        try {
            this.global.getDispatchWorkerPool().execute(new ConsumableQueueWorker(this.log, this));
        }
        catch (InterruptedException ex) {
            this.log.error(ME, "toRunning: exception " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void distribute(MsgUnitWrapper msgUnitWrapper) {
        if (this.log.CALL) {
            this.log.call(ME, "distribute");
        }
        this.toRunning();
    }

    public synchronized void init(Global global, PluginInfo pluginInfo) throws XmlBlasterException {
        this.global = global;
        this.log = this.global.getLog("distributor");
        if (this.log.CALL) {
            this.log.call(ME, "init");
        }
        this.pluginInfo = pluginInfo;
        this.topicHandler = (TopicHandler)this.pluginInfo.getUserData();
        this.isReady = true;
        this.toRunning();
    }

    public String getType() {
        return this.pluginInfo.getType();
    }

    public String getVersion() {
        return this.pluginInfo.getVersion();
    }

    public synchronized void shutdown() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "shutdown");
        }
        SubscriptionInfo[] subs = this.topicHandler.getSubscriptionInfoArr();
        int i = 0;
        while (i < subs.length) {
            this.subscriptionRemove(new SubscriptionEvent(subs[i]));
            ++i;
        }
        this.isReady = false;
    }

    private final DispatchManager getDispatchManager(SubscriptionInfo subscriptionInfo) {
        if (subscriptionInfo == null) {
            this.log.error(ME, "getDispatchManager the subscriptionInfo object is null");
            Thread.dumpStack();
            return null;
        }
        SessionInfo sessionInfo = subscriptionInfo.getSessionInfo();
        if (sessionInfo == null) {
            this.log.error(ME, "getDispatchManager the sessionInfo object is null");
            Thread.dumpStack();
            return null;
        }
        DispatchManager dispatchManager = sessionInfo.getDispatchManager();
        if (dispatchManager == null) {
            this.log.error(ME, "getDispatchManager the dispatcherManager object is null");
            Thread.dumpStack();
            return null;
        }
        return dispatchManager;
    }

    public synchronized void subscriptionAdd(SubscriptionEvent e) throws XmlBlasterException {
        DispatchManager dispatchManager;
        SubscriptionInfo subscriptionInfo = e.getSubscriptionInfo();
        if (this.log.CALL) {
            this.log.call(ME, "onAddSubscriber");
        }
        if ((dispatchManager = this.getDispatchManager(subscriptionInfo)) != null) {
            dispatchManager.addConnectionStatusListener(this);
        }
        this.isReady = true;
        this.toRunning();
    }

    public synchronized void subscriptionRemove(SubscriptionEvent e) throws XmlBlasterException {
        DispatchManager dispatchManager;
        SubscriptionInfo subscriptionInfo = e.getSubscriptionInfo();
        if (this.log.CALL) {
            this.log.call(ME, "onRemoveSubscriber");
        }
        if ((dispatchManager = this.getDispatchManager(subscriptionInfo)) != null) {
            dispatchManager.removeConnectionStateListener(this);
        }
    }

    public void toAlive(DispatchManager dispatchManager, ConnectionStateEnum oldState) {
        if (this.log.CALL) {
            this.log.call(ME, "toAlive");
        }
        this.isReady = true;
        this.toRunning();
    }

    public void toPolling(DispatchManager dispatchManager, ConnectionStateEnum oldState) {
    }

    public void toDead(DispatchManager dispatchManager, ConnectionStateEnum oldState, String errorText) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processHistoryQueue() {
        if (this.log.CALL) {
            this.log.call(ME, "processQueue");
        }
        try {
            try {
                ArrayList lst = null;
                block4: while (true) {
                    lst = this.topicHandler.getHistoryQueue().peek(-1, -1L);
                    if (this.log.TRACE) {
                        this.log.trace(ME, "processQueue: processing '" + lst.size() + "' entries from queue");
                    }
                    if (lst == null || lst.size() < 1) break;
                    int i = 0;
                    while (true) {
                        if (i >= lst.size()) continue block4;
                        if (!this.isReady) {
                            Object var6_6 = null;
                            this.isRunning = false;
                            return;
                        }
                        MsgQueueHistoryEntry entry = (MsgQueueHistoryEntry)lst.get(i);
                        MsgUnitWrapper msgUnitWrapper = entry.getMsgUnitWrapper();
                        if (msgUnitWrapper != null && !this.distributeOneEntry(msgUnitWrapper, entry)) {
                            this.isReady = false;
                            Object var6_7 = null;
                            this.isRunning = false;
                            return;
                        }
                        ++i;
                    }
                    break;
                }
                this.isReady = true;
            }
            catch (Throwable ex) {
                this.isReady = false;
                ex.printStackTrace();
                this.log.error(ME, "processQueue: " + ex.getMessage());
                Object var6_9 = null;
                this.isRunning = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.isRunning = false;
            throw throwable;
        }
        Object var6_8 = null;
        this.isRunning = false;
    }

    private boolean distributeOneEntry(MsgUnitWrapper msgUnitWrapper, MsgQueueHistoryEntry entry) {
        I_Queue srcQueue = this.topicHandler.getHistoryQueue();
        try {
            if (msgUnitWrapper == null) {
                this.log.error(ME, "distributeOneEntry() MsgUnitWrapper is null");
                Thread.dumpStack();
                this.givingUpDistribution(null, msgUnitWrapper, entry, null);
                return true;
            }
            if (this.log.CALL) {
                this.log.call(ME, "distributeOneEntry '" + msgUnitWrapper.getUniqueId() + "' '" + msgUnitWrapper.getKeyOid() + "'");
            }
            SubscriptionInfo[] subInfoArr = this.topicHandler.getSubscriptionInfoArr();
            Object removeSet = null;
            int ii = 0;
            while (ii < subInfoArr.length) {
                SubscriptionInfo sub = subInfoArr[ii];
                if (this.topicHandler.isDirtyRead(sub, msgUnitWrapper)) {
                    this.log.error(ME, "ConsumableQueuePlugin used together with 'dirtyRead' is not supported");
                    srcQueue.removeRandom(entry);
                    return true;
                }
                ++ii;
            }
            int ii2 = 0;
            while (ii2 < subInfoArr.length) {
                block17: {
                    SubscriptionInfo sub = subInfoArr[ii2];
                    if (this.topicHandler.subscriberMayReceiveIt(sub, msgUnitWrapper) && this.topicHandler.checkIfAllowedToSend(null, sub) && sub.getSessionInfo().getDispatchManager() != null && sub.getSessionInfo().getDispatchManager().getDispatchConnectionsHandler().isAlive()) {
                        try {
                            block16: {
                                try {
                                    if (this.topicHandler.checkFilter(null, sub, msgUnitWrapper, false)) break block16;
                                    break block17;
                                }
                                catch (XmlBlasterException ex) {
                                    this.givingUpDistribution(sub, msgUnitWrapper, entry, ex);
                                    return true;
                                }
                            }
                            MsgQueueUpdateEntry updateEntry = this.topicHandler.createEntryFromWrapper(msgUnitWrapper, sub);
                            UpdateReturnQosServer retQos = this.doDistribute(sub, updateEntry);
                            if (this.log.TRACE && retQos == null) {
                                this.log.trace(ME, "distributeOneEntry: the return object was null: callback has not sent the message (dirty reads ?)");
                            }
                            if (retQos == null || retQos.getException() == null) {
                                srcQueue.removeRandom(entry);
                                if (this.log.TRACE) {
                                    this.log.trace(ME, "distributeOneEntry: successfully removed entry from queue");
                                }
                                return true;
                            }
                            this.log.error(ME, "distributeOneEntry an exception occured: " + retQos.getException().getMessage());
                            Throwable ex = retQos.getException();
                            if (!(ex instanceof XmlBlasterException) || !((XmlBlasterException)ex).isCommunication()) {
                                this.givingUpDistribution(sub, msgUnitWrapper, entry, null);
                                return true;
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            this.givingUpDistribution(sub, msgUnitWrapper, entry, e);
                            return true;
                        }
                    }
                }
                ++ii2;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.log.error(ME, "distributeOneEntry " + ex.getMessage());
            this.givingUpDistribution(null, msgUnitWrapper, entry, ex);
        }
        return false;
    }

    private void givingUpDistribution(SubscriptionInfo sub, MsgUnitWrapper msgUnitWrapper, MsgQueueEntry entry, Throwable e) {
        try {
            String id = "";
            if (sub != null) {
                id = sub.getSessionInfo().getId();
            }
            String exTxt = "";
            if (e != null) {
                exTxt = e.toString();
            }
            SessionName publisherName = msgUnitWrapper.getMsgQosData().getSender();
            if (this.log.TRACE) {
                this.log.trace(ME, "Sending of message from " + publisherName + " to " + id + " failed: " + exTxt);
            }
            if (sub != null && e != null) {
                sub.getSessionInfo().getDispatchManager().internalError(e);
            } else {
                this.topicHandler.getRequestBroker().deadMessage(new MsgQueueEntry[]{entry}, null, "ConsumableQueuePlugin.givingUpDistribution: " + exTxt);
            }
            this.topicHandler.getHistoryQueue().removeRandom(entry);
        }
        catch (XmlBlasterException ex) {
            this.log.error(ME, "givingUpDistribution: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private UpdateReturnQosServer doDistribute(SubscriptionInfo sub, MsgQueueUpdateEntry entry) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "doDistribute");
        }
        entry.setWantReturnObject(true);
        DispatchWorker worker = new DispatchWorker(this.global, sub.getSessionInfo().getDispatchManager());
        ArrayList<MsgQueueUpdateEntry> list = new ArrayList<MsgQueueUpdateEntry>();
        list.add(entry);
        worker.run(list);
        return (UpdateReturnQosServer)entry.getReturnObj();
    }
}

