/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.mime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.mime.I_AccessFilter;
import org.xmlBlaster.engine.runlevel.I_RunlevelListener;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.plugin.PluginManagerBase;

public class AccessPluginManager
extends PluginManagerBase
implements I_RunlevelListener {
    private final String ME;
    public static final String pluginPropertyName = "MimeAccessPlugin";
    private final Global glob;
    private final LogChannel log;
    private final Map accessFilterMap = Collections.synchronizedMap(new HashMap());

    public AccessPluginManager(Global glob) {
        super(glob);
        this.glob = glob;
        this.ME = "AccessPluginManager" + this.glob.getLogPrefixDashed();
        this.log = this.glob.getLog("mime");
        glob.getRunlevelManager().addRunlevelListener(this);
    }

    public I_AccessFilter getPlugin(String type, String version) throws XmlBlasterException {
        return (I_AccessFilter)((Object)this.getPluginObject(type, version));
    }

    public void postInstantiate(I_Plugin plugin, PluginInfo pluginInfo) {
        ((I_AccessFilter)((Object)plugin)).initialize(this.glob);
    }

    protected String getPluginPropertyName() {
        return pluginPropertyName;
    }

    public String getDefaultPluginName(String type, String version) {
        if (type != null && type.equals("GnuRegexFilter")) {
            return "org.xmlBlaster.engine.mime.regex.GnuRegexFilter";
        }
        return null;
    }

    public final I_AccessFilter getAccessFilter(String type, String version, String mime, String mimeExtended) {
        if (mimeExtended == null || mimeExtended.length() < 1) {
            mimeExtended = "1.0";
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Needed to set empty mimeExtended to default=" + mimeExtended);
            }
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Trying to find plugin for type=" + type + " version=" + version + " mime=" + mime + " mimeExtended=" + mimeExtended);
        }
        try {
            StringBuffer key = new StringBuffer(80);
            key.append(type).append(version).append(mime).append(mimeExtended);
            Object obj = this.accessFilterMap.get(key.toString());
            if (obj != null) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Found filter for key=" + key.toString());
                }
                return (I_AccessFilter)obj;
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "No filter for key=" + key.toString());
            }
            key.setLength(0);
            key.append(type).append(version).append("*");
            obj = this.accessFilterMap.get(key.toString());
            if (obj != null) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Found filter for key=" + key.toString());
                }
                return (I_AccessFilter)obj;
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "No filter for key=" + key.toString());
            }
            key.setLength(0);
            key.append(type).append(version);
            obj = this.accessFilterMap.get(key.toString());
            if (obj != null) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Filter plugin type=" + type + " version=" + version + " is loaded but does not support mime=" + mime + " mimeExtended=" + mimeExtended);
                }
                return null;
            }
            this.log.info(this.ME, "Going to load filter plugin for type=" + type + " version=" + version + " mime=" + mime + " mimeExtended=" + mimeExtended);
            if (this.addAccessFilterPlugin(type, version)) {
                key.setLength(0);
                key.append(type).append(version).append(mime).append(mimeExtended);
                obj = this.accessFilterMap.get(key.toString());
                if (obj != null) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Found filter for key=" + key.toString());
                    }
                    return (I_AccessFilter)obj;
                }
                key.setLength(0);
                key.append(type).append(version).append("*");
                obj = this.accessFilterMap.get(key.toString());
                if (obj != null) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Found filter for key=" + key.toString());
                    }
                    return (I_AccessFilter)obj;
                }
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "There is no plugin for type=" + type + " version=" + version + " mime=" + mime + " mimeExtended=" + mimeExtended + " available");
            }
            return null;
        }
        catch (Exception e) {
            this.log.error(this.ME, "Problems accessing subscribe filter [" + type + "][" + version + "] mime=" + mime + " mimeExtended=" + mimeExtended + ": " + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    public final boolean addAccessFilterPlugin(String type, String version) {
        StringBuffer key = new StringBuffer(80);
        key.append(type).append(version);
        Object obj = this.accessFilterMap.get(key.toString());
        if (obj != null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Access filter '" + key.toString() + "' is loaded already");
            }
            return false;
        }
        try {
            int ii;
            I_AccessFilter filterPlugin = this.getPlugin(type, version);
            if (filterPlugin == null) {
                this.log.error(this.ME, "Problems accessing plugin MimeAccessPlugin[" + type + "][" + version + "] please check your configuration");
                return false;
            }
            filterPlugin.initialize(this.glob);
            this.accessFilterMap.put(key.toString(), filterPlugin);
            key.setLength(0);
            String[] mime = filterPlugin.getMimeTypes();
            String[] mimeExtended = filterPlugin.getMimeExtended();
            if (mimeExtended == null || mimeExtended.length != mime.length) {
                if (mimeExtended.length != mime.length) {
                    this.log.error(this.ME, "Access plugin manager [" + type + "][" + version + "]: Number of mimeExtended does not match mime, ignoring mimeExtended.");
                }
                mimeExtended = new String[mime.length];
                ii = 0;
                while (ii < mime.length) {
                    mimeExtended[ii] = "1.0";
                    ++ii;
                }
            }
            ii = 0;
            while (ii < mime.length) {
                if (mime[ii] == null || mime[ii].length() < 1 || mime[ii].equals("*")) {
                    key.append(type).append(version).append("*");
                } else {
                    key.append(type).append(version).append(mime[ii]).append(mimeExtended[ii]);
                }
                this.accessFilterMap.put(key.toString(), filterPlugin);
                this.log.info(this.ME, "Loaded access filter for mime types '" + key.toString() + "' to cache");
                key.setLength(0);
                ++ii;
            }
            return true;
        }
        catch (Throwable e) {
            this.log.error(this.ME, "Problems accessing subscribe plugin manager, can't instantiate MimeAccessPlugin[" + type + "][" + version + "]: " + e.toString());
            e.printStackTrace();
            return false;
        }
    }

    public void shutdown() {
        Iterator iterator = this.accessFilterMap.values().iterator();
        while (iterator.hasNext()) {
            I_AccessFilter plugin = (I_AccessFilter)iterator.next();
            plugin.shutdown();
        }
        this.accessFilterMap.clear();
    }

    public String getName() {
        return this.ME;
    }

    public void runlevelChange(int from, int to, boolean force) throws XmlBlasterException {
        if (to == from) {
            return;
        }
        if (to <= from || to == 3) {
            // empty if block
        }
        if (to < from && to == 0) {
            this.shutdown();
        }
    }
}

