/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.mime;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.mime.I_PublishFilter;
import org.xmlBlaster.engine.runlevel.I_RunlevelListener;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.plugin.PluginManagerBase;

public class PublishPluginManager
extends PluginManagerBase
implements I_RunlevelListener {
    private final String ME;
    private static final String defaultPluginName = null;
    public static final String pluginPropertyName = "MimePublishPlugin";
    private final Global glob;
    private final LogChannel log;
    private final Map pluginMap = new TreeMap();
    private final Map mimeCache = new TreeMap();
    private final Object dummyObject = new Object();
    private final int maxMimeCacheSize;

    public PublishPluginManager(Global glob) throws XmlBlasterException {
        super(glob);
        this.glob = glob;
        this.ME = "PublishPluginManager" + this.glob.getLogPrefixDashed();
        this.log = this.glob.getLog("mime");
        this.maxMimeCacheSize = glob.getProperty().get("MimePublishPlugin.maxMimeCacheSize", 1000);
        glob.getRunlevelManager().addRunlevelListener(this);
    }

    public void postInstantiate(I_Plugin plugin_, PluginInfo pluginInfo) {
        I_PublishFilter plugin = (I_PublishFilter)((Object)plugin_);
        plugin.initialize(this.glob);
        if (this.pluginMap.get(plugin.getName()) != null) {
            this.log.warn(this.ME, "Instantiating publish filter plugin '" + plugin.getName() + "' again, have you configured it twice?");
        }
        this.pluginMap.put(plugin.getName(), plugin);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Instantiated publish filter plugin '" + plugin.getName() + "'");
        }
    }

    public synchronized void initializePlugins() throws XmlBlasterException {
        this.pluginMap.clear();
        this.mimeCache.clear();
        Map map = this.glob.getProperty().get(pluginPropertyName, (Map)null);
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String version;
                String key = (String)iterator.next();
                String type = key.substring(0, key.indexOf(":"));
                I_PublishFilter plugin = (I_PublishFilter)((Object)this.getPluginObject(type, version = key.substring(key.indexOf(":") + 1)));
                if (plugin != null) continue;
                this.log.error(this.ME, "Problems accessing plugin MimePublishPlugin[" + type + "][" + version + "] please check your configuration");
            }
            this.log.info(this.ME, "Instantiated " + this.pluginMap.size() + " publish filter plugins");
        } else {
            this.log.info(this.ME, "No plugins configured with 'MimePublishPlugin'");
        }
    }

    public final boolean hasPlugins() {
        return this.pluginMap.size() > 0;
    }

    public synchronized Map findMimePlugins(String mime, String mimeExtended) {
        String key;
        Object ret;
        if (this.pluginMap.size() == 0) {
            return null;
        }
        if (mime == null) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new IllegalArgumentException("You must pass a valid contentMime type");
        }
        if (mimeExtended == null || mimeExtended.length() < 1) {
            mimeExtended = "1.0";
        }
        if ((ret = this.mimeCache.get(key = mime + mimeExtended)) != null && ret instanceof Map) {
            return (Map)ret;
        }
        if (ret != null && ret instanceof Object) {
            return null;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "mime=" + mime + " mimeExtended=" + mimeExtended + " not found in cache, searching the plugin ...");
        }
        if (this.mimeCache.size() > this.maxMimeCacheSize) {
            this.log.warn(this.ME, "Cache has reached max size of " + this.maxMimeCacheSize + " entries, erasing entries");
            this.mimeCache.clear();
        }
        Iterator iterator = this.pluginMap.values().iterator();
        block0: while (iterator.hasNext()) {
            I_PublishFilter plugin = (I_PublishFilter)iterator.next();
            String[] mimes = plugin.getMimeTypes();
            String[] extended = plugin.getMimeExtended();
            if (mimes == null || extended == null || mimes.length != extended.length) {
                String text = "Your plugin '" + plugin.getName() + "' must pass a valid mime type with a corresponding mimeExtended type, plugin ignored.";
                this.log.error(this.ME, text);
                Thread.currentThread();
                Thread.dumpStack();
                throw new IllegalArgumentException(text);
            }
            int ii = 0;
            while (ii < mimes.length) {
                if (mimes[ii].equals("*") || mimes[ii].equals(mime) && (extended[ii].equals("*") || extended[ii].equals(mimeExtended))) {
                    TreeMap<String, I_PublishFilter> plugins = (TreeMap<String, I_PublishFilter>)this.mimeCache.get(key);
                    if (plugins == null) {
                        plugins = new TreeMap<String, I_PublishFilter>();
                        this.mimeCache.put(key, plugins);
                    }
                    plugins.put(plugin.getName(), plugin);
                    this.log.info(this.ME, "mime=" + mime + " mimeExtended=" + mimeExtended + " added to cache with plugin=" + plugin.getName());
                    continue block0;
                }
                ++ii;
            }
        }
        Object plugins = this.mimeCache.get(key);
        if (plugins == null) {
            this.mimeCache.put(key, this.dummyObject);
            this.log.info(this.ME, "mime=" + mime + " mimeExtended=" + mimeExtended + " added to cache, no plugin is available");
            return null;
        }
        if (plugins instanceof Map) {
            return (Map)plugins;
        }
        return null;
    }

    protected String getPluginPropertyName() {
        return pluginPropertyName;
    }

    public String getDefaultPluginName(String type, String version) {
        return defaultPluginName;
    }

    public void shutdown() {
        Iterator iterator = this.pluginMap.values().iterator();
        while (iterator.hasNext()) {
            I_PublishFilter plugin = (I_PublishFilter)iterator.next();
            plugin.shutdown();
        }
        this.pluginMap.clear();
        this.mimeCache.clear();
    }

    public String getName() {
        return this.ME;
    }

    public void runlevelChange(int from, int to, boolean force) throws XmlBlasterException {
        if (to == from) {
            return;
        }
        if (to > from && to == 3) {
            this.initializePlugins();
        }
        if (to < from && to == 0) {
            this.shutdown();
        }
    }
}

