/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.mime.demo;

import java.util.Hashtable;
import java.util.Properties;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.mime.I_AccessFilter;
import org.xmlBlaster.engine.mime.Query;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;

public class ContentLenFilter
implements I_Plugin,
I_AccessFilter {
    private final String ME = "ContentLenFilter";
    private Global glob;
    private LogChannel log;
    private long DEFAULT_MAX_LEN = 1000000L;
    private int THROW_EXCEPTION_FOR_LEN = -1;

    public void initialize(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("mime");
        this.log.info("ContentLenFilter", "Filter is initialized, we check all mime types if content is not to long");
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        String throwStr;
        this.log = glob.getLog("mime");
        Properties props = pluginInfo.getParameters();
        String lenStr = (String)((Hashtable)props).get("DEFAULT_MAX_LEN");
        if (lenStr != null) {
            this.DEFAULT_MAX_LEN = new Long(lenStr);
            this.log.info("ContentLenFilter", "Setting DEFAULT_MAX_LEN=" + this.DEFAULT_MAX_LEN + " as configured in xmlBlaster.properties");
        }
        if ((throwStr = (String)((Hashtable)props).get("THROW_EXCEPTION_FOR_LEN")) != null) {
            this.THROW_EXCEPTION_FOR_LEN = new Integer(throwStr);
            this.log.info("ContentLenFilter", "Setting THROW_EXCEPTION_FOR_LEN=" + this.THROW_EXCEPTION_FOR_LEN + " as configured in xmlBlaster.properties");
        }
    }

    public String getType() {
        return "ContentLenFilter";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getName() {
        return "ContentLenFilter";
    }

    public String[] getMimeTypes() {
        String[] mimeTypes = new String[]{"*"};
        return mimeTypes;
    }

    public String[] getMimeExtended() {
        String[] mimeExtended = new String[]{"1.0"};
        return mimeExtended;
    }

    public boolean match(SessionInfo receiver, MsgUnit msgUnit, Query query) throws XmlBlasterException {
        if (msgUnit == null) {
            Thread.dumpStack();
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "ContentLenFilter", "Illegal argument in match() call");
        }
        try {
            long maxLen = query != null ? new Long(query.toString().trim()) : this.DEFAULT_MAX_LEN;
            if (msgUnit.getContent().length == this.THROW_EXCEPTION_FOR_LEN) {
                if ("__sys__deadMessage".equals(msgUnit.getKeyOid())) {
                    this.log.info("ContentLenFilter", "Dead messages pass through");
                    return true;
                }
                if (msgUnit.getQosData().isErased()) {
                    this.log.info("ContentLenFilter", "Messages with state=" + msgUnit.getQosData().getState() + " pass through");
                    return true;
                }
                this.log.info("ContentLenFilter", "Test what happens if we throw an exception");
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "ContentLenFilter", "Test what happens if we throw an exception");
            }
            if ((long)msgUnit.getContent().length > maxLen) {
                this.log.info("ContentLenFilter", "Message access denied, msgLen=" + msgUnit.getContent().length + " max allowed=" + maxLen);
                return false;
            }
            this.log.info("ContentLenFilter", "Message access OK, msgLen=" + msgUnit.getContent().length + " max=" + maxLen);
            return true;
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.error("ContentLenFilter", "Can't filter message, your filter string '" + query + "' is illegal, expected a max size integer: " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, "ContentLenFilter", "Can't filter message, your filter string '" + query + "' is illegal, expected a max size integer", e);
        }
    }

    public void shutdown() {
    }
}

