/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.mime.demo;

import java.util.Hashtable;
import java.util.Properties;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SubjectInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.mime.I_PublishFilter;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;

public class PublishLenChecker
implements I_Plugin,
I_PublishFilter {
    private final String ME = "PublishLenChecker";
    private Global glob;
    private LogChannel log;
    private long DEFAULT_MAX_LEN = 1000000L;
    private int THROW_EXCEPTION_FOR_LEN = -1;

    public void initialize(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("mime");
        this.log.info("PublishLenChecker", "Filter is initialized, we check all mime types if content is not too long");
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) {
        String throwStr;
        this.log = glob.getLog("mime");
        Properties props = pluginInfo.getParameters();
        String lenStr = (String)((Hashtable)props).get("DEFAULT_MAX_LEN");
        if (lenStr != null) {
            this.DEFAULT_MAX_LEN = new Long(lenStr);
            this.log.info("PublishLenChecker", "Setting DEFAULT_MAX_LEN=" + this.DEFAULT_MAX_LEN + " as configured in xmlBlaster.properties");
        }
        if ((throwStr = (String)((Hashtable)props).get("THROW_EXCEPTION_FOR_LEN")) != null) {
            this.THROW_EXCEPTION_FOR_LEN = new Integer(throwStr);
            this.log.info("PublishLenChecker", "Setting THROW_EXCEPTION_FOR_LEN=" + this.THROW_EXCEPTION_FOR_LEN + " as configured in xmlBlaster.properties");
        }
    }

    public String getType() {
        return "PublishLenChecker";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getName() {
        return "PublishLenChecker";
    }

    public String[] getMimeTypes() {
        String[] mimeTypes = new String[]{"*"};
        return mimeTypes;
    }

    public String[] getMimeExtended() {
        String[] mimeExtended = new String[]{"1.0"};
        return mimeExtended;
    }

    public String intercept(SubjectInfo publisher, MsgUnit msgUnit) throws XmlBlasterException {
        if (msgUnit == null) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "PublishLenChecker", "Illegal argument in intercept() call - msgUnit is null");
        }
        if (msgUnit.getKeyData().isInternal()) {
            return "";
        }
        try {
            long maxLen = this.DEFAULT_MAX_LEN;
            if (msgUnit.getContent().length == this.THROW_EXCEPTION_FOR_LEN) {
                this.log.info("PublishLenChecker", "Test what happens if we throw an exception");
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "PublishLenChecker", "Test what happens if we throw an exception");
            }
            if ((long)msgUnit.getContent().length > maxLen) {
                this.log.info("PublishLenChecker", "Message REJECTED, msgLen=" + msgUnit.getContent().length + " max allowed=" + maxLen);
                return "REJECTED";
            }
            this.log.info("PublishLenChecker", "Message access OK, msgLen=" + msgUnit.getContent().length + " max=" + maxLen);
            return "OK";
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Throwable e) {
            String tmp = "Can't filter message because of an unexpected problem: " + e.toString();
            this.log.error("PublishLenChecker", tmp);
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, "PublishLenChecker", tmp);
        }
    }

    public void shutdown() {
    }
}

