/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.mime.regex;

import gnu.regexp.RE;
import gnu.regexp.REException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.mime.I_AccessFilter;
import org.xmlBlaster.engine.mime.Query;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;

public class GnuRegexFilter
implements I_Plugin,
I_AccessFilter {
    private final String ME = "GnuRegexFilter";
    private Global glob;
    private LogChannel log;
    private long DEFAULT_MAX_LEN = 1000000L;
    private int THROW_EXCEPTION_FOR_LEN = -1;

    public void initialize(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("mime");
        this.log.info("GnuRegexFilter", "Filter is initialized, we check all mime types if content is not to long");
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) {
    }

    public String getType() {
        return "GnuRegexFilter";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getName() {
        return "GnuRegexFilter";
    }

    public String[] getMimeTypes() {
        String[] mimeTypes = new String[]{"*"};
        return mimeTypes;
    }

    public String[] getMimeExtended() {
        String[] mimeExtended = new String[]{"1.0"};
        return mimeExtended;
    }

    public boolean match(SessionInfo receiver, MsgUnit msgUnit, Query query) throws XmlBlasterException {
        RE expression;
        if (msgUnit == null) {
            Thread.dumpStack();
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "GnuRegexFilter", "Illegal argument in regex match() call");
        }
        if (query.getPreparedQuery() == null) {
            try {
                expression = new RE((Object)query.getQuery());
                query.setPreparedQuery(expression);
            }
            catch (REException e) {
                this.log.error("GnuRegexFilter", "Can't compile regular filter expression '" + query + "':" + e.toString());
                throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, "GnuRegexFilter", "Can't compile regular filter expression '" + query + "':" + e.toString());
            }
        } else {
            expression = (RE)query.getPreparedQuery();
        }
        return expression.isMatch((Object)msgUnit.getContentStr());
    }

    public void shutdown() {
    }
}

