/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.mime.xpath;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jaxen.Function;
import org.jaxen.JaxenException;
import org.jaxen.SimpleFunctionContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom.DOMXPath;
import org.jutils.log.LogChannel;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.mime.I_AccessFilter;
import org.xmlBlaster.engine.mime.Query;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;

public class XPathFilter
implements I_Plugin,
I_AccessFilter {
    public static final String MAX_DOM_CACHE_SIZE = "engine.mime.xpath.maxcachesize";
    public static final String DEFAULT_MAX_CACHE_SIZE = "10";
    public static final String XPATH_EXTENSTION_FUNCTIONS = "engine.mime.xpath.extension_functions";
    private final String ME = "XPathFilter";
    private Global glob;
    private LogChannel log;
    private int maxCacheSize = 10;
    private LinkedList domCache;

    public void initialize(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("mime");
        this.log.info("XPathFilter", "Filter is initialized, we check xml mime types");
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        Properties prop = pluginInfo.getParameters();
        this.maxCacheSize = Integer.parseInt(prop.getProperty(MAX_DOM_CACHE_SIZE, DEFAULT_MAX_CACHE_SIZE));
        this.loadXPathExtensionFunctions(prop.getProperty(XPATH_EXTENSTION_FUNCTIONS));
        this.domCache = new LinkedList();
    }

    public String getType() {
        return "XPathFilter";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getName() {
        return "XPathFilter";
    }

    public String[] getMimeTypes() {
        String[] mimeTypes = new String[]{"text/xml", "image/svg+xml"};
        return mimeTypes;
    }

    public String[] getMimeExtended() {
        String[] mimeExtended = new String[]{"1.0", "1.0"};
        return mimeExtended;
    }

    public boolean match(SessionInfo receiver, MsgUnit msgUnitWrapper, Query query) throws XmlBlasterException {
        DOMXPath expression;
        if (msgUnitWrapper == null) {
            Thread.dumpStack();
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "XPathFilter", "Illegal argument in xpath match() call");
        }
        if (query.getPreparedQuery() == null) {
            try {
                expression = new DOMXPath(query.getQuery());
                query.setPreparedQuery(expression);
            }
            catch (JaxenException e) {
                this.log.error("XPathFilter", "Can't compile XPath filter expression '" + query + "':" + e.toString());
                throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, "XPathFilter", "Can't compile XPath filter expression '" + query + "':" + e.toString());
            }
        } else {
            expression = (DOMXPath)query.getPreparedQuery();
        }
        Document doc = this.getDocument(msgUnitWrapper);
        try {
            if (this.log.DUMP) {
                this.log.dump("XPathFilter", "Matching query " + query.getQuery() + " against document: " + msgUnitWrapper.getContentStr());
            }
            boolean match = expression.booleanValueOf((Object)doc);
            if (this.log.TRACE) {
                this.log.trace("XPathFilter", "Query " + query.getQuery() + " did" + (match ? " match" : " not match"));
            }
            return match;
        }
        catch (JaxenException e) {
            this.log.error("XPathFilter", "Error in querying dom tree with query " + query + ": " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, "XPathFilter", "Error in querying dom tree with query " + query + ": " + e.toString());
        }
    }

    public void shutdown() {
    }

    protected void loadXPathExtensionFunctions(String extensionClassList) throws XmlBlasterException {
        if (extensionClassList == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(extensionClassList, ";");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            int c1 = t.indexOf(":");
            int c2 = t.lastIndexOf(":");
            if (c1 == -1 || c2 == -1 || c1 == c2) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "XPathFilter", "Bad xpath extension function definition: \"" + t + "\". Expected: prefix \":\" function-name \":\" class");
            }
            String prefix = t.substring(0, c1);
            String func = t.substring(c1 + 1, c2);
            String klass = t.substring(c2 + 1);
            if (func.length() == 0 || klass.length() == 0) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "XPathFilter", "Bad xpath extension function definition: \"" + t + "\". Expected: prefix \":\" function-name \":\" class");
            }
            try {
                Object o = Class.forName(klass).newInstance();
                if (!(o instanceof Function)) {
                    throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "XPathFilter", "Extension function \"" + klass + "\" does not implement org.jaxen.Function");
                }
                ((SimpleFunctionContext)XPathFunctionContext.getInstance()).registerFunction("".equals(prefix) ? null : prefix, func, (Function)o);
            }
            catch (Exception e) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "XPathFilter", "Could not load extension function \"" + klass + "\": " + e.getMessage());
            }
        }
    }

    private synchronized Document getDocument(MsgUnit msg) throws XmlBlasterException {
        Document doc = null;
        String key = msg.getKeyOid() + ":" + msg.getQosData().getRcvTimestamp().getTimestamp();
        int index = this.domCache.indexOf(new Entry(key, null));
        if (index != -1) {
            if (this.log.TRACE) {
                this.log.trace("XPathFilter", "Returning doc from cache with key: " + key);
            }
            Entry e = (Entry)this.domCache.get(index);
            doc = e.doc;
        } else {
            if (this.log.TRACE) {
                this.log.trace("XPathFilter", "Constructing new doc from with key: " + key);
            }
            doc = this.getDocument(msg.getContentStr());
            Entry e = new Entry(key, doc);
            this.domCache.addFirst(e);
            if (this.domCache.size() >= this.maxCacheSize) {
                this.domCache.removeLast();
            }
        }
        return doc;
    }

    private Document getDocument(String xml) throws XmlBlasterException {
        try {
            StringReader reader = new StringReader(xml);
            InputSource input = new InputSource(reader);
            DocumentBuilderFactory factory = this.glob.getDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(input);
        }
        catch (SAXException ex) {
            String reason = ex.getMessage();
            if (ex instanceof SAXParseException) {
                SAXParseException s = (SAXParseException)ex;
                reason = reason + " at line=" + s.getLineNumber() + " column=" + s.getColumnNumber() + " in systemID" + s.getSystemId();
            }
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "XPathFilter", "Could not parse xml: " + reason);
        }
        catch (ParserConfigurationException ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, "XPathFilter", "Could not setup parser " + ex);
        }
        catch (IOException ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "XPathFilter", "Could not read xml " + ex);
        }
    }

    class Entry {
        String key;
        Document doc;

        public Entry(String key, Document doc) {
            this.key = key;
            this.doc = doc;
        }

        public boolean equals(Object o) {
            if (o != null && (o instanceof Entry || o instanceof String)) {
                String k;
                String string = k = o instanceof String ? (String)o : ((Entry)o).key;
                if (this.key.equals(k)) {
                    return true;
                }
            }
            return false;
        }
    }
}

