/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.msgstore.cache;

import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.msgstore.I_ChangeCallback;
import org.xmlBlaster.engine.msgstore.I_Map;
import org.xmlBlaster.engine.msgstore.I_MapEntry;
import org.xmlBlaster.engine.msgstore.StoragePluginManager;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_StoragePlugin;
import org.xmlBlaster.util.queue.I_StorageProblemListener;
import org.xmlBlaster.util.queue.StorageId;

public class PersistenceCachePlugin
implements I_StoragePlugin,
I_StorageProblemListener,
I_Map {
    private String ME;
    private Global glob;
    private LogChannel log;
    private QueuePropertyBase property;
    boolean isDown = true;
    private StorageId queueId;
    private I_Map transientStore;
    private I_Map persistentStore;
    private boolean isConnected = false;
    private PluginInfo pluginInfo = null;

    public void storageUnavailable(int oldStatus) {
        this.log.call(this.ME, "storageUnavailable");
        this.isConnected = false;
    }

    public void storageAvailable(int oldStatus) {
        if (oldStatus == -1) {
            return;
        }
        this.log.call(this.ME, "storageAvailable");
        if (this.persistentStore == null) {
            return;
        }
        this.log.warn(this.ME, "Persistent store has reconnected, we may have a memory leak as send messsages are not cleaned up");
        this.log.warn(this.ME, "Persistent store has reconnected, current persistent messages are handled transient only, new ones will be handled persistent");
        this.isConnected = true;
    }

    public void initialize(StorageId uniqueQueueId, Object userData) throws XmlBlasterException {
        if (this.isDown) {
            Properties pluginProperties = null;
            if (this.pluginInfo != null) {
                pluginProperties = this.pluginInfo.getParameters();
            }
            if (pluginProperties == null) {
                pluginProperties = new Properties();
            }
            this.property = null;
            this.ME = this.getClass().getName() + "-" + uniqueQueueId;
            this.queueId = uniqueQueueId;
            try {
                this.property = (QueuePropertyBase)userData;
            }
            catch (Throwable e) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, "Can't configure queue, your properties are invalid", e);
            }
            if (this.log.CALL) {
                this.log.call(this.ME, "Entering initialize(" + this.getType() + ", " + this.getVersion() + ")");
            }
            StoragePluginManager pluginManager = this.glob.getStoragePluginManager();
            QueuePropertyBase queuePropertyBase = (QueuePropertyBase)userData;
            String defaultTransient = pluginProperties.getProperty("transientMap", "RAM,1.0").trim();
            if (defaultTransient.startsWith(this.getType())) {
                this.log.error(this.ME, "Cache storage configured with transientMap=CACHE, to prevent recursion we set it to 'RAM,1.0'");
                defaultTransient = "RAM,1.0";
            }
            this.transientStore = pluginManager.getPlugin(defaultTransient, uniqueQueueId, this.createRamCopy(queuePropertyBase));
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Created transient part:" + this.transientStore.toXml(""));
            }
            try {
                String defaultPersistent = pluginProperties.getProperty("persistentMap", "JDBC,1.0").trim();
                if (defaultPersistent.startsWith(this.getType())) {
                    this.log.error(this.ME, "Cache storage configured with persistentMap=CACHE, to prevent recursion we set it to 'JDBC,1.0'");
                    defaultPersistent = "JDBC,1.0";
                }
                this.persistentStore = pluginManager.getPlugin(defaultPersistent, uniqueQueueId, queuePropertyBase);
                this.isConnected = true;
                this.persistentStore.registerStorageProblemListener(this);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Created persistent part:" + this.persistentStore.toXml(""));
                }
            }
            catch (XmlBlasterException ex) {
                this.log.error(this.ME, "could not initialize the persistent queue. Is the JDBC Driver jar file in the CLASSPATH ? Is the DB up and running ?" + ex.getMessage());
            }
            if (this.persistentStore != null) {
                try {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Initialize: Removing swapped entries from persistent store, numEntries=" + this.persistentStore.getNumOfEntries() + " numPersistentEntries=" + this.persistentStore.getNumOfPersistentEntries());
                    }
                    this.persistentStore.removeTransient();
                }
                catch (XmlBlasterException ex) {
                    this.log.error(this.ME, "could not remove transient entries (swapped entries) probably due to no connection to the DB, or the DB is down" + ex.getMessage());
                }
                if (this.persistentStore instanceof I_Queue) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Initialize: Prefilling cache storage with entries");
                    }
                    if (this.persistentStore.getNumOfEntries() > 0L) {
                        long maxBytes = this.transientStore.getMaxNumOfBytes();
                        long maxEntries = this.transientStore.getMaxNumOfEntries();
                        ArrayList entries = null;
                        try {
                            entries = ((I_Queue)((Object)this.persistentStore)).peek((int)maxEntries, maxBytes);
                            int n = entries.size();
                            this.log.info(this.ME, "Prefilling cache with " + n + " entries");
                            PersistenceCachePlugin persistenceCachePlugin = this;
                            synchronized (persistenceCachePlugin) {
                                int i = 0;
                                while (i < n) {
                                    I_MapEntry cleanEntry = (I_MapEntry)entries.get(i);
                                    this.transientStore.put(cleanEntry);
                                    ++i;
                                }
                            }
                        }
                        catch (XmlBlasterException ex) {
                            this.log.error(this.ME, "could not reload data from persistence probably due to a broken connection to the DB or the DB is not up and running: " + ex.getMessage());
                        }
                    }
                }
            }
            this.isDown = false;
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Successful initialized: " + this.toXml(""));
            }
        }
    }

    private QueuePropertyBase createRamCopy(QueuePropertyBase queuePropertyBase) {
        QueuePropertyBase ramCopy = (QueuePropertyBase)queuePropertyBase.clone();
        ramCopy.setMaxEntries(queuePropertyBase.getMaxEntriesCache());
        ramCopy.setMaxBytes(queuePropertyBase.getMaxBytesCache());
        return ramCopy;
    }

    public synchronized void setProperties(Object userData) throws XmlBlasterException {
        QueuePropertyBase newProp;
        if (userData == null) {
            return;
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering setProperties()");
        }
        try {
            newProp = (QueuePropertyBase)userData;
        }
        catch (Throwable e) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, "Can't configure queue, your properties are invalid", e);
        }
        this.property = newProp;
        this.transientStore.setProperties(this.createRamCopy((QueuePropertyBase)userData));
        if (this.persistentStore != null) {
            this.persistentStore.setProperties(userData);
        }
    }

    public Object getProperties() {
        return this.property;
    }

    public int put(I_MapEntry mapEntry) throws XmlBlasterException {
        if (mapEntry == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "put(I_MapEntry=" + mapEntry + ")");
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "put(" + mapEntry.getLogId() + ")");
        }
        int numPersistentPut = 0;
        int numTransientPut = 0;
        PersistenceCachePlugin persistenceCachePlugin = this;
        synchronized (persistenceCachePlugin) {
            XmlBlasterException exceptionReturned = this.spaceLeftException(mapEntry, this);
            if (exceptionReturned != null) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, exceptionReturned.getMessage());
                }
                exceptionReturned.setLocation(this.ME + "-put(" + mapEntry.getLogId() + ")");
                throw exceptionReturned;
            }
            if (this.persistentStore != null && this.isConnected && mapEntry.isPersistent()) {
                XmlBlasterException exceptionReturned2 = this.spaceLeftException(mapEntry, this.persistentStore);
                if (exceptionReturned2 != null) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, exceptionReturned2.getMessage());
                    }
                    exceptionReturned2.setLocation(this.ME + "-put(" + mapEntry.getLogId() + ")");
                    throw exceptionReturned2;
                }
                try {
                    numPersistentPut = this.persistentStore.put(mapEntry);
                }
                catch (XmlBlasterException ex) {
                    this.log.error(this.ME, "put: an error occured when writing to the persistent queue, the persistent entry " + mapEntry.getLogId() + " will temporarly be handled as transient. Is the DB up and running ? " + ex.getMessage() + "state " + this.toXml(""));
                }
            }
            this.assureTransientSpace(mapEntry);
            numTransientPut = this.transientStore.put(mapEntry);
        }
        if (numPersistentPut > 0 || numTransientPut > 0) {
            return 1;
        }
        return 0;
    }

    private void assureTransientSpace(I_MapEntry mapEntry) throws XmlBlasterException {
        while (!this.spaceLeft(mapEntry, this.transientStore)) {
            if (this.transientStore == null || this.property == null || this.transientStore.getNumOfEntries() < 1L) break;
            I_MapEntry oldest = this.transientStore.removeOldest();
            if (oldest == null) {
                if (!this.log.TRACE) break;
                this.log.trace(this.ME + ".assureTransientSpace", "The RAM queue is full, new entry '" + mapEntry.getUniqueId() + "' seems to be the first and only one, so we accept it");
                break;
            }
            if (this.log.CALL) {
                this.log.call(this.ME + ".assureTransientSpace", "Swapping '" + oldest.getLogId() + "' to HD ...");
            }
            try {
                if (!oldest.isPersistent()) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME + "-assureTransientSpace(" + mapEntry.getLogId() + ")", "Swapping '" + oldest.getLogId() + " size=" + oldest.getSizeInBytes() + "'. Exceeding size state after removing from transient before entering persistent: " + this.toXml(""));
                    }
                    if (this.persistentStore == null) {
                        throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, this.ME, "assureTransientSpace: no persistent queue configured, needed for swapping, entry " + mapEntry.getLogId() + " is not handled");
                    }
                    if (!this.isConnected) {
                        throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, this.ME, "assureTransientSpace: The DB is currently disconnected, entry " + mapEntry.getLogId() + " is not handled");
                    }
                    if (this.spaceLeft(oldest, this.persistentStore)) {
                        try {
                            this.persistentStore.put(oldest);
                        }
                        catch (XmlBlasterException ex) {
                            this.log.error(this.ME, "assureTransientSpace: an error occured when writing to the persistent queue, transient entry " + oldest.getLogId() + " is not swapped, new entry '" + mapEntry.getLogId() + "' is rejected. Is the DB up and running ? " + ex.getMessage() + " state: " + this.toXml(""));
                            throw ex;
                        }
                    } else {
                        throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_BYTES, this.ME, "assureTransientSpace: maximum size in bytes for the persistent queue exceeded when swapping, entry " + mapEntry.getLogId() + " not handled . State: " + this.toXml(""));
                    }
                }
                oldest.isSwapped(true);
            }
            catch (XmlBlasterException ex2) {
                this.transientStore.put(oldest);
                throw ex2;
            }
        }
    }

    private XmlBlasterException spaceLeftException(I_MapEntry mapEntry, I_Map map) {
        if (map == null || this.property == null) {
            return new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "Storage framework is down, current settings are" + this.toXml(""));
        }
        if (1L + map.getNumOfEntries() > map.getMaxNumOfEntries()) {
            return new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, this.ME, "Queue overflow (number of entries), " + this.getNumOfEntries() + " entries are in queue, try increasing property '" + this.property.getPropName("maxEntries") + "' and '" + this.property.getPropName("maxEntriesCache") + "', current settings are" + this.toXml(""));
        }
        if (mapEntry.getSizeInBytes() + map.getNumOfBytes() > map.getMaxNumOfBytes()) {
            return new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_BYTES, this.ME, "Queue overflow, " + this.getMaxNumOfBytes() + " bytes are in queue, try increasing property '" + this.property.getPropName("maxBytes") + "' and '" + this.property.getPropName("maxBytesCache") + "', current settings are" + this.toXml(""));
        }
        return null;
    }

    private boolean spaceLeft(I_MapEntry mapEntry, I_Map map) {
        if (map == null || this.property == null) {
            return false;
        }
        if (1L + map.getNumOfEntries() > map.getMaxNumOfEntries()) {
            return false;
        }
        return mapEntry.getSizeInBytes() + map.getNumOfBytes() <= map.getMaxNumOfBytes();
    }

    public StorageId getStorageId() {
        return this.queueId;
    }

    public I_MapEntry get(long uniqueId) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering get(" + uniqueId + ")");
        }
        I_MapEntry mapEntry = null;
        PersistenceCachePlugin persistenceCachePlugin = this;
        synchronized (persistenceCachePlugin) {
            mapEntry = this.transientStore.get(uniqueId);
            if (mapEntry != null) {
                mapEntry.isSwapped(false);
                I_MapEntry i_MapEntry = mapEntry;
                return i_MapEntry;
            }
            if (this.persistentStore == null) {
                I_MapEntry i_MapEntry = null;
                return i_MapEntry;
            }
            mapEntry = this.persistentStore.get(uniqueId);
            if (mapEntry == null) {
                I_MapEntry i_MapEntry = null;
                return i_MapEntry;
            }
            if (!mapEntry.isPersistent()) {
                this.persistentStore.remove(mapEntry);
            }
            this.assureTransientSpace(mapEntry);
            this.transientStore.put(mapEntry);
            mapEntry.isSwapped(false);
        }
        return mapEntry;
    }

    public I_MapEntry[] getAll() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering getAll()");
        }
        PersistenceCachePlugin persistenceCachePlugin = this;
        synchronized (persistenceCachePlugin) {
            TreeMap<Long, I_MapEntry> map = new TreeMap<Long, I_MapEntry>();
            I_MapEntry[] ramEntries = this.transientStore.getAll();
            int i = 0;
            while (i < ramEntries.length) {
                map.put(new Long(ramEntries[i].getUniqueId()), ramEntries[i]);
                ++i;
            }
            if (this.persistentStore != null) {
                I_MapEntry[] persistEntries = this.persistentStore.getAll();
                int i2 = 0;
                while (i2 < persistEntries.length) {
                    map.put(new Long(persistEntries[i2].getUniqueId()), persistEntries[i2]);
                    ++i2;
                }
            }
            I_MapEntry[] i_MapEntryArray = map.values().toArray(new I_MapEntry[map.size()]);
            return i_MapEntryArray;
        }
    }

    public int remove(I_MapEntry mapEntry) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "remove(" + mapEntry.getLogId() + ")");
        }
        PersistenceCachePlugin persistenceCachePlugin = this;
        synchronized (persistenceCachePlugin) {
            int num = this.transientStore.remove(mapEntry);
            int num2 = 0;
            if ((mapEntry.isPersistent() || num == 0 && this.numSwapped() > 0L) && this.persistentStore != null) {
                num2 = this.persistentStore.remove(mapEntry);
            }
            int n = Math.max(num, num2);
            return n;
        }
    }

    public I_MapEntry removeOldest() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "removeOldest is not implemented");
    }

    public int removeTransient() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "removeTransient is not implemented");
    }

    private long numSwapped() {
        if (this.persistentStore == null) {
            return 0L;
        }
        return this.persistentStore.getNumOfEntries() - this.persistentStore.getNumOfPersistentEntries();
    }

    public long getNumOfEntries() {
        long ret = 0L;
        if (this.persistentStore != null && this.isConnected) {
            ret = this.persistentStore.getNumOfEntries();
            if (ret < 0L) {
                return this.transientStore.getNumOfEntries();
            }
            return ret += this.transientStore.getNumOfEntries() - this.transientStore.getNumOfPersistentEntries();
        }
        return this.transientStore.getNumOfEntries();
    }

    public long getNumOfPersistentEntries() {
        if (this.persistentStore != null && this.isConnected) {
            long ret = this.persistentStore.getNumOfPersistentEntries();
            if (ret < 0L) {
                return this.transientStore.getNumOfEntries();
            }
            return ret;
        }
        return this.transientStore.getNumOfPersistentEntries();
    }

    public long getMaxNumOfEntries() {
        if (this.persistentStore != null && this.isConnected) {
            return this.persistentStore.getMaxNumOfEntries();
        }
        return this.transientStore.getMaxNumOfEntries();
    }

    public long getNumOfBytes() {
        if (this.persistentStore != null && this.isConnected) {
            long ret = this.persistentStore.getNumOfBytes();
            if (ret < 0L) {
                return this.transientStore.getNumOfBytes();
            }
            return ret += this.transientStore.getNumOfBytes() - this.transientStore.getNumOfPersistentBytes();
        }
        return this.transientStore.getNumOfBytes();
    }

    public long getNumOfPersistentBytes() {
        if (this.persistentStore != null && this.isConnected) {
            long ret = this.persistentStore.getNumOfPersistentBytes();
            if (ret < 0L) {
                return this.transientStore.getNumOfPersistentBytes();
            }
            return ret;
        }
        return this.transientStore.getNumOfPersistentBytes();
    }

    public long getMaxNumOfBytes() {
        if (this.persistentStore != null && this.isConnected) {
            return this.persistentStore.getMaxNumOfBytes();
        }
        return this.transientStore.getMaxNumOfBytes();
    }

    public long clear() {
        long ret = 0L;
        try {
            ret = this.transientStore.clear();
        }
        catch (Exception ex) {
            this.log.error(this.ME, "could not clear transient storage. Cause: " + ex.getMessage());
        }
        try {
            if (this.persistentStore != null && this.isConnected) {
                ret += this.persistentStore.clear();
            }
        }
        catch (Exception ex) {
            this.log.error(this.ME, "could not clear persistent storage. Cause: " + ex.getMessage());
        }
        return ret;
    }

    public void shutdown() {
        if (this.log.CALL) {
            this.log.call(this.ME, "shutdown()");
        }
        this.isDown = true;
        long numTransients = this.getNumOfEntries() - this.getNumOfPersistentEntries();
        if (numTransients > 0L) {
            this.log.warn(this.ME, "Shutting down persistence cache which contains " + numTransients + " transient messages");
        }
        this.transientStore.shutdown();
        if (this.persistentStore != null && this.isConnected) {
            this.persistentStore.shutdown();
        }
        try {
            if (this.persistentStore != null) {
                this.persistentStore.unRegisterStorageProblemListener(this);
            }
        }
        catch (Exception ex) {
            this.log.error(this.ME, "could not unregister listener. Cause: " + ex.toString());
        }
    }

    public boolean isShutdown() {
        return this.isDown;
    }

    public String usage() {
        return "no usage";
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<PersistenceCachePlugin id='").append(this.getStorageId().getId());
        sb.append("' type='").append(this.getType());
        sb.append("' version='").append(this.getVersion());
        sb.append("' maxEntriesCache='").append(this.transientStore.getMaxNumOfEntries());
        sb.append("' maxBytesCache='").append(this.transientStore.getMaxNumOfBytes());
        sb.append("' maxEntries='").append(this.getMaxNumOfEntries());
        sb.append("' maxBytes='").append(this.getMaxNumOfBytes());
        sb.append("' numOfEntries='").append(this.getNumOfEntries());
        sb.append("' numOfBytes='").append(this.getNumOfBytes());
        sb.append("'>");
        sb.append(this.transientStore.toXml(extraOffset + " "));
        if (this.persistentStore != null) {
            sb.append(this.persistentStore.toXml(extraOffset + " "));
        }
        sb.append(offset).append("</PersistenceCachePlugin>");
        return sb.toString();
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) {
        this.glob = (Global)glob;
        this.log = this.glob.getLog("persistence");
        this.pluginInfo = pluginInfo;
    }

    public String getType() {
        return "CACHE";
    }

    public String getVersion() {
        return "1.0";
    }

    public PluginInfo getInfo() {
        return this.pluginInfo;
    }

    public void destroy() throws XmlBlasterException {
        XmlBlasterException e = null;
        this.isDown = true;
        try {
            if (this.persistentStore != null) {
                this.persistentStore.unRegisterStorageProblemListener(this);
            }
        }
        catch (Exception ex) {
            this.log.error(this.ME, "could not unregister listener. Cause: " + ex.toString());
        }
        try {
            if (this.persistentStore != null && this.isConnected) {
                this.persistentStore.destroy();
            }
        }
        catch (XmlBlasterException ex) {
            e = ex;
        }
        this.transientStore.destroy();
        if (e != null) {
            throw e;
        }
    }

    public boolean registerStorageProblemListener(I_StorageProblemListener listener) {
        if (this.persistentStore == null) {
            return false;
        }
        return this.persistentStore.registerStorageProblemListener(listener);
    }

    public boolean unRegisterStorageProblemListener(I_StorageProblemListener listener) {
        if (this.persistentStore == null || listener == null) {
            return false;
        }
        return this.persistentStore.unRegisterStorageProblemListener(listener);
    }

    public I_MapEntry change(I_MapEntry entry, I_ChangeCallback callback) throws XmlBlasterException {
        if (entry == null) {
            return null;
        }
        PersistenceCachePlugin persistenceCachePlugin = this;
        synchronized (persistenceCachePlugin) {
            long oldSizeInBytes = entry.getSizeInBytes();
            I_MapEntry newEntry = entry;
            boolean oldIsPersistent = entry.isPersistent();
            if (callback != null) {
                newEntry = callback.changeEntry(entry);
            }
            if (newEntry == null) {
                I_MapEntry i_MapEntry = entry;
                return i_MapEntry;
            }
            if (oldSizeInBytes != newEntry.getSizeInBytes()) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".change", "the size of the entry '" + entry.getUniqueId() + "' has changed from '" + oldSizeInBytes + "' to '" + newEntry.getSizeInBytes() + "'. This is not allowed");
            }
            I_MapEntry retEntry = this.transientStore.change(newEntry, null);
            if (oldIsPersistent != retEntry.isPersistent()) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "Changing of persistence flag of '" + entry.getLogId() + "' to persistent=" + retEntry.isPersistent() + " is not implemented");
            }
            if (newEntry.isPersistent()) {
                if (this.persistentStore != null && this.isConnected) {
                    retEntry = this.persistentStore.change(newEntry, null);
                } else if (this.log.TRACE) {
                    this.log.trace(this.ME, "Can't update entry '" + entry.getLogId() + "' on persistence");
                }
            }
            I_MapEntry i_MapEntry = retEntry;
            return i_MapEntry;
        }
    }

    public I_MapEntry change(long uniqueId, I_ChangeCallback callback) throws XmlBlasterException {
        PersistenceCachePlugin persistenceCachePlugin = this;
        synchronized (persistenceCachePlugin) {
            I_MapEntry oldEntry = this.get(uniqueId);
            I_MapEntry i_MapEntry = this.change(oldEntry, callback);
            return i_MapEntry;
        }
    }
}

