/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.msgstore.ram;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.msgstore.I_ChangeCallback;
import org.xmlBlaster.engine.msgstore.I_Map;
import org.xmlBlaster.engine.msgstore.I_MapEntry;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.MsgUnitStoreProperty;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_StoragePlugin;
import org.xmlBlaster.util.queue.I_StorageProblemListener;
import org.xmlBlaster.util.queue.StorageId;

public final class MapPlugin
implements I_Map,
I_StoragePlugin {
    private String ME = "MapPlugin";
    private StorageId mapId;
    private Map storage;
    private Set lruSet;
    private QueuePropertyBase property;
    private Global glob;
    private LogChannel log;
    private boolean isShutdown = false;
    private long sizeInBytes;
    private long persistentSizeInBytes;
    private long numOfPersistentEntries;
    private PluginInfo pluginInfo;

    public void initialize(StorageId uniqueMapId, Object userData) throws XmlBlasterException {
        this.setProperties(userData);
        this.glob = this.property.getGlobal();
        this.log = this.glob.getLog("persistence");
        this.mapId = uniqueMapId;
        if (this.mapId == null || this.glob == null) {
            Thread.dumpStack();
            throw new IllegalArgumentException("Illegal arguments in MapPlugin constructor: mapId=" + this.mapId);
        }
        this.ME = "MapPlugin-" + this.mapId;
        if (this.property.getMaxEntries() > Integer.MAX_VALUE) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, this.ME + ".initialize: The maximum number of messages is too big");
        }
        this.storage = new TreeMap();
        this.lruSet = new TreeSet(new LruComparator());
        this.isShutdown = false;
    }

    public void setProperties(Object userData) throws XmlBlasterException {
        QueuePropertyBase newProp;
        if (userData == null) {
            return;
        }
        try {
            newProp = (QueuePropertyBase)userData;
        }
        catch (Throwable e) {
            throw XmlBlasterException.convert(this.glob, this.ME, "Can't configure RAM map, your properties are invalid", e);
        }
        this.property = newProp;
    }

    public Object getProperties() {
        return this.property;
    }

    public final StorageId getStorageId() {
        return this.mapId;
    }

    public void finalize() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "finalize - garbage collected");
        }
    }

    public I_MapEntry get(long uniqueId) throws XmlBlasterException {
        String key = "" + uniqueId;
        if (this.log.CALL) {
            this.log.call(this.ME, "get(" + key + ")");
        }
        Map map = this.storage;
        synchronized (map) {
            I_MapEntry entry = (I_MapEntry)this.storage.get(key);
            this.touch(entry);
            I_MapEntry i_MapEntry = entry;
            return i_MapEntry;
        }
    }

    private void touch(I_MapEntry entry) {
        if (entry == null) {
            return;
        }
        if (entry.getSortTimestamp() != null) {
            this.lruSet.remove(entry);
        }
        entry.setSortTimestamp(new Timestamp());
        this.lruSet.add(entry);
    }

    public I_MapEntry[] getAll() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "getAll()");
        }
        Map map = this.storage;
        synchronized (map) {
            I_MapEntry[] i_MapEntryArray = this.storage.values().toArray(new I_MapEntry[this.storage.size()]);
            return i_MapEntryArray;
        }
    }

    public int put(I_MapEntry entry) throws XmlBlasterException {
        if (entry == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "put(I_MapEntry=" + entry + ")");
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "put(" + entry.getLogId() + ")");
        }
        if (this.getNumOfEntries() > this.property.getMaxEntries()) {
            String reason = "Message store overflow, number of entries=" + this.property.getMaxEntries() + ", try increasing '" + this.property.getPropName("maxEntries") + "' on client login.";
            if (this.log.TRACE) {
                this.log.trace(this.ME, reason);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, this.ME, reason);
        }
        if (this.getNumOfBytes() > this.property.getMaxBytes()) {
            String reason = "Message store overflow with " + this.getNumOfBytes() + " bytes, try increasing '" + this.property.getPropName("maxBytes") + "' on client login.";
            if (this.log.TRACE) {
                this.log.trace(this.ME, reason);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, this.ME, reason);
        }
        String key = entry.getUniqueIdStr();
        Map map = this.storage;
        synchronized (map) {
            I_MapEntry old = this.storage.put(key, entry);
            if (old != null) {
                this.storage.put(key, old);
                this.touch(old);
                int n = 0;
                return n;
            }
            entry.setSortTimestamp(new Timestamp());
            this.lruSet.add(entry);
            entry.setStored(true);
            this.sizeInBytes += entry.getSizeInBytes();
            if (entry.isPersistent()) {
                ++this.numOfPersistentEntries;
                this.persistentSizeInBytes += entry.getSizeInBytes();
            }
            int n = old != null ? 0 : 1;
            return n;
        }
    }

    public int remove(I_MapEntry mapEntry) throws XmlBlasterException {
        if (mapEntry == null) {
            return 0;
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "remove(" + mapEntry.getLogId() + ")");
        }
        Map map = this.storage;
        synchronized (map) {
            I_MapEntry entry;
            if (mapEntry.getSortTimestamp() != null) {
                this.lruSet.remove(mapEntry);
            }
            if ((entry = (I_MapEntry)this.storage.remove(mapEntry.getUniqueIdStr())) == null) {
                int n = 0;
                return n;
            }
            if (entry.isPersistent()) {
                --this.numOfPersistentEntries;
                this.persistentSizeInBytes -= entry.getSizeInBytes();
            }
            entry.setStored(false);
            this.sizeInBytes -= entry.getSizeInBytes();
            int n = 1;
            return n;
        }
    }

    public int removeTransient() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "removeTransient() is not implemented");
    }

    public I_MapEntry removeOldest() throws XmlBlasterException {
        Map map = this.storage;
        synchronized (map) {
            I_MapEntry oldest = null;
            Iterator<Object> it = this.lruSet.iterator();
            if (it.hasNext()) {
                oldest = (I_MapEntry)it.next();
            }
            if (oldest != null) {
                this.remove(oldest);
                I_MapEntry i_MapEntry = oldest;
                return i_MapEntry;
            }
            if (this.storage.size() > 0) {
                this.log.error(this.ME + ".removeOldest", "LRU set has no entries, we remove an arbitrary entry from RAM map");
                it = this.storage.values().iterator();
                if (it.hasNext()) {
                    I_MapEntry entry = (I_MapEntry)it.next();
                    this.remove(entry);
                    I_MapEntry i_MapEntry = entry;
                    return i_MapEntry;
                }
            }
            I_MapEntry i_MapEntry = null;
            return i_MapEntry;
        }
    }

    public long clear() {
        if (this.log.CALL) {
            this.log.call(this.ME, "clear()");
        }
        Map map = this.storage;
        synchronized (map) {
            long ret = this.storage.size();
            Iterator iter = this.storage.values().iterator();
            while (iter.hasNext()) {
                ((I_MapEntry)iter.next()).setStored(false);
            }
            this.lruSet.clear();
            this.storage.clear();
            this.sizeInBytes = 0L;
            this.persistentSizeInBytes = 0L;
            this.numOfPersistentEntries = 0L;
            long l = ret;
            return l;
        }
    }

    public long getNumOfEntries() {
        Map map = this.storage;
        synchronized (map) {
            long l = this.storage.size();
            return l;
        }
    }

    public long getMaxNumOfEntries() {
        return this.property.getMaxEntries();
    }

    public long getNumOfPersistentEntries() {
        Map map = this.storage;
        synchronized (map) {
            long l = this.numOfPersistentEntries;
            return l;
        }
    }

    public long getNumOfBytes() {
        Map map = this.storage;
        synchronized (map) {
            long l = this.sizeInBytes;
            return l;
        }
    }

    public long getNumOfPersistentBytes() {
        Map map = this.storage;
        synchronized (map) {
            long l = this.persistentSizeInBytes;
            return l;
        }
    }

    public final long getMaxNumOfBytes() {
        return this.property.getMaxBytes();
    }

    public final void shutdown() {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering shutdown(" + this.storage.size() + ")");
        }
        Map map = this.storage;
        synchronized (map) {
            if (this.storage.size() > 0 && this.log.TRACE) {
                this.log.trace(this.ME, "Shutting down RAM map which contains " + this.storage.size() + " messages");
            }
            this.lruSet.clear();
            this.isShutdown = true;
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "shutdown() of RAM map " + this.getStorageId());
        }
    }

    public final boolean isShutdown() {
        return this.isShutdown;
    }

    public void destroy() throws XmlBlasterException {
        this.property = null;
    }

    public String usage() {
        return "no usage";
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<MapPlugin id='").append(this.getStorageId().getId());
        sb.append("' type='").append(this.getType());
        sb.append("' version='").append(this.getVersion());
        sb.append("' numOfEntries='").append(this.getNumOfEntries());
        sb.append("' numOfBytes='").append(this.getNumOfBytes());
        sb.append("'>");
        sb.append(this.property.toXml(extraOffset + " "));
        sb.append(offset).append("</MapPlugin>");
        return sb.toString();
    }

    public void init(Global glob, PluginInfo pluginInfo) {
        this.pluginInfo = pluginInfo;
    }

    public String getType() {
        return "RAM";
    }

    public String getVersion() {
        return "1.0";
    }

    public PluginInfo getInfo() {
        return this.pluginInfo;
    }

    public boolean registerStorageProblemListener(I_StorageProblemListener listener) {
        return false;
    }

    public boolean unRegisterStorageProblemListener(I_StorageProblemListener listener) {
        return false;
    }

    public I_MapEntry change(I_MapEntry entry, I_ChangeCallback callback) throws XmlBlasterException {
        Map map = this.storage;
        synchronized (map) {
            long oldSizeInBytes = entry.getSizeInBytes();
            I_MapEntry newEntry = entry;
            if (callback != null) {
                newEntry = callback.changeEntry(entry);
            }
            if (oldSizeInBytes != newEntry.getSizeInBytes()) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".change", "the size of the entry '" + entry.getUniqueId() + "' has changed from '" + oldSizeInBytes + "' to '" + newEntry.getSizeInBytes() + "'. This is not allowed");
            }
            if (entry != newEntry) {
                int tmp = this.remove(entry);
                if (tmp < 1) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".change", "the size of the entry '" + entry.getUniqueId() + "' has not been found on this map");
                }
                this.put(newEntry);
            }
            I_MapEntry i_MapEntry = newEntry;
            return i_MapEntry;
        }
    }

    public I_MapEntry change(long uniqueId, I_ChangeCallback callback) throws XmlBlasterException {
        Map map = this.storage;
        synchronized (map) {
            I_MapEntry oldEntry = this.get(uniqueId);
            I_MapEntry i_MapEntry = this.change(oldEntry, callback);
            return i_MapEntry;
        }
    }

    public static void main(String[] args) {
        try {
            Global glob = new Global(args);
            MapPlugin pl = new MapPlugin();
            StorageId mapId = new StorageId("msgUnitStore", "/node/unknown");
            pl.initialize(mapId, new MsgUnitStoreProperty(glob, glob.getId()));
        }
        catch (XmlBlasterException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    class LruComparator
    implements Comparator,
    Serializable {
        LruComparator() {
        }

        public final int compare(Object o1, Object o2) {
            I_MapEntry id1 = (I_MapEntry)o1;
            I_MapEntry id2 = (I_MapEntry)o2;
            if (id1.getSortTimestamp() == null) {
                id1.setSortTimestamp(new Timestamp());
            }
            if (id2.getSortTimestamp() == null) {
                id2.setSortTimestamp(new Timestamp());
            }
            if (id1.getSortTimestamp().getTimestamp() > id2.getSortTimestamp().getTimestamp()) {
                return 1;
            }
            if (id1.getSortTimestamp().getTimestamp() < id2.getSortTimestamp().getTimestamp()) {
                return -1;
            }
            return 0;
        }
    }
}

