/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.persistence;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import org.jutils.JUtilsException;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.xml2java.XmlKey;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public final class MsgFileDumper {
    private static final String ME = "MsgFileDumper";
    private Global glob = null;
    private LogChannel log = null;
    private String path = null;
    private final String XMLKEY_TOKEN = "-XmlKey.xml";
    private final String XMLQOS_TOKEN = "-XmlQos.xml";

    public void init(Global glob) throws XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("persistence");
        if (this.log.CALL) {
            this.log.call(ME, "Entering init()");
        }
        String defaultPath = System.getProperty("user.home") + System.getProperty("file.separator") + "tmp";
        this.path = glob.getProperty().get("Persistence.Path", defaultPath);
        if (this.path == null) {
            throw new XmlBlasterException(ME, "xmlBlaster will run memory based only, no persistence path is avalailable, please specify 'Persistence.Path' in xmlBlaster.properties");
        }
        this.path = this.path + System.getProperty("file.separator") + glob.getStrippedId();
        File pp = new File(this.path);
        if (!pp.exists()) {
            this.log.info(ME, "Creating new directory " + this.path + " for persistence of messages");
            pp.mkdirs();
        }
        if (!pp.isDirectory()) {
            this.log.error(ME, this.path + " is no directory, please specify another 'Persistence.Path' in xmlBlaster.properties");
            throw new XmlBlasterException(ME, this.path + " is no directory, please specify another 'Persistence.Path' in xmlBlaster.properties");
        }
        if (!pp.canWrite()) {
            this.log.error(ME, "Sorry, no access permissions to " + this.path + ", please specify another 'Persistence.Path' in xmlBlaster.properties");
            throw new XmlBlasterException(ME, "Sorry, no access permissions to " + this.path + ", please specify another 'Persistence.Path' in xmlBlaster.properties");
        }
    }

    public void shutdown() throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(ME, "Not neccessary!");
        }
    }

    public String createFileName(String oid, long timestamp) {
        Timestamp ts = new Timestamp(timestamp);
        return oid + "-" + ts.toString();
    }

    public String getPersistencePath() {
        return this.path;
    }

    public String getPersistenceFileName(String fileName) {
        return this.path + System.getProperty("file.separator") + fileName;
    }

    public String store(MsgUnitWrapper msgUnitWrapper) throws XmlBlasterException {
        return this.store(msgUnitWrapper, false);
    }

    private String store(MsgUnitWrapper msgUnitWrapper, boolean updateOnly) throws XmlBlasterException {
        String fileName = this.createFileName(msgUnitWrapper.getKeyOid(), msgUnitWrapper.getUniqueId());
        try {
            if (!updateOnly) {
                FileUtil.writeFile(this.path, fileName + "-XmlKey.xml", msgUnitWrapper.getMsgKeyData().toXml());
            }
            FileUtil.writeFile(this.path, fileName, msgUnitWrapper.getMsgUnit().getContent());
            FileUtil.writeFile(this.path, fileName + "-XmlQos.xml", msgUnitWrapper.getMsgQosData().toXml());
            if (this.log.TRACE) {
                this.log.trace(ME, "Successfully stored " + fileName);
            }
            return this.getPersistenceFileName(fileName);
        }
        catch (JUtilsException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, ME, "Storage of message " + msgUnitWrapper.getLogId() + " failed", e);
        }
    }

    public String update(MsgUnitWrapper msgUnitWrapper) throws XmlBlasterException {
        return this.store(msgUnitWrapper, true);
    }

    public MsgUnit fetch(String oid, long timestamp) throws XmlBlasterException {
        MsgUnit msgUnit = null;
        String fileName = this.createFileName(oid, timestamp);
        try {
            String xmlKey_literal = FileUtil.readAsciiFile(this.path, fileName + "-XmlKey.xml");
            byte[] content = FileUtil.readFile(this.path, fileName);
            String xmlQos_literal = FileUtil.readAsciiFile(this.path, fileName + "-XmlQos.xml");
            msgUnit = new MsgUnit(this.glob, xmlKey_literal, content, xmlQos_literal);
            if (this.log.TRACE) {
                this.log.trace(ME, "Successfully fetched message " + fileName);
            }
            if (this.log.DUMP) {
                this.log.dump(ME, "Successfully fetched message\n" + msgUnit.toXml());
            }
        }
        catch (JUtilsException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, ME, "Fetching message " + this.getPersistenceFileName(fileName) + " failed", e);
        }
        return msgUnit;
    }

    public Enumeration fetchAllOids() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, ME, "Sorry fetchAllOids() is not implemented");
    }

    public void erase(XmlKey xmlKey) throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, ME, "Sorry erase() is not implemented");
    }

    public static void main(String[] args) {
    }

    private class XmlKeyFilter
    implements FilenameFilter {
        private XmlKeyFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith("-XmlKey.xml");
        }
    }
}

