/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.persistence.filestore;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Vector;
import org.jutils.JUtilsException;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.persistence.I_PersistenceDriver;
import org.xmlBlaster.engine.xml2java.XmlKey;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.MsgQosData;

public class FileDriver
implements I_PersistenceDriver {
    private static final String ME = "FileDriver";
    private Global glob = null;
    private LogChannel log = null;
    private String path = null;
    private final String XMLKEY_TOKEN = "-XmlKey.xml";
    private final String XMLQOS_TOKEN = "-XmlQos.xml";

    public final void init(Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("persistence");
        if (this.log.CALL) {
            this.log.call(ME, "Entering init()");
        }
        String defaultPath = System.getProperty("user.home") + System.getProperty("file.separator") + "tmp";
        this.path = glob.getProperty().get("Persistence.Path", defaultPath);
        if (this.path == null) {
            throw new XmlBlasterException(ME, "xmlBlaster will run memory based only, no persistence path is avalailable, please specify 'Persistence.Path' in xmlBlaster.properties");
        }
        File pp = new File(this.path);
        if (!pp.exists()) {
            this.log.info(ME, "Creating new directory " + this.path + " for persitence of messages");
            pp.mkdirs();
        }
        if (!pp.isDirectory()) {
            this.log.error(ME, this.path + " is no directory, please specify another 'Persistence.Path' in xmlBlaster.properties");
            throw new XmlBlasterException(ME, this.path + " is no directory, please specify another 'Persistence.Path' in xmlBlaster.properties");
        }
        if (!pp.canWrite()) {
            this.log.error(ME, "Sorry, no access permissions to " + this.path + ", please specify another 'Persistence.Path' in xmlBlaster.properties");
            throw new XmlBlasterException(ME, "Sorry, no access permissions to " + this.path + ", please specify another 'Persistence.Path' in xmlBlaster.properties");
        }
    }

    public final void shutdown() throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(ME, "Not neccessary!");
        }
    }

    public final void store(MsgUnitWrapper messageWrapper) throws XmlBlasterException {
        MsgKeyData xmlKey = messageWrapper.getMsgKeyData();
        MsgQosData qos = messageWrapper.getMsgQosData();
        String mime = messageWrapper.getContentMime();
        byte[] content = messageWrapper.getMsgUnit().getContent();
        String oid = xmlKey.getOid();
        try {
            FileUtil.writeFile(this.path, oid + "-XmlKey.xml", xmlKey.toXml());
            FileUtil.writeFile(this.path, oid, content);
            FileUtil.writeFile(this.path, oid + "-XmlQos.xml", qos.toXml());
        }
        catch (JUtilsException e) {
            throw new XmlBlasterException(e);
        }
        if (this.log.TRACE) {
            this.log.trace(ME, "Successfully stored " + oid);
        }
    }

    public final void update(MsgUnitWrapper messageWrapper) throws XmlBlasterException {
        try {
            String oid = messageWrapper.getKeyOid();
            FileUtil.writeFile(this.path, oid, messageWrapper.getMsgUnit().getContent());
            FileUtil.writeFile(this.path, oid + "-XmlQos.xml", messageWrapper.getMsgQosData().toXml());
        }
        catch (JUtilsException e) {
            throw new XmlBlasterException(e);
        }
        if (this.log.TRACE) {
            this.log.trace(ME, "Successfully updated store " + messageWrapper.getKeyOid());
        }
    }

    public MsgUnit fetch(String oid) throws XmlBlasterException {
        MsgUnit msgUnit = null;
        try {
            String xmlKey_literal = FileUtil.readAsciiFile(this.path, oid + "-XmlKey.xml");
            byte[] content = FileUtil.readFile(this.path, oid);
            String xmlQos_literal = FileUtil.readAsciiFile(this.path, oid + "-XmlQos.xml");
            msgUnit = new MsgUnit(this.glob, xmlKey_literal, content, xmlQos_literal);
            if (this.log.TRACE) {
                this.log.trace(ME, "Successfully fetched message " + oid);
            }
            if (this.log.DUMP) {
                this.log.dump(ME, "Successfully fetched message\n" + msgUnit.toXml());
            }
        }
        catch (JUtilsException e) {
            throw new XmlBlasterException(e);
        }
        return msgUnit;
    }

    public Enumeration fetchAllOids() throws XmlBlasterException {
        Vector<String> oidContainer = new Vector<String>();
        File pp = new File(this.path);
        String[] fileArr = pp.list(new XmlKeyFilter());
        int ii = 0;
        while (ii < fileArr.length) {
            String oid = fileArr[ii].substring(0, fileArr[ii].length() - "-XmlKey.xml".length());
            oidContainer.addElement(oid);
            ++ii;
        }
        this.log.info(ME, "Successfully got " + oidContainer.size() + " stored message-oids from " + this.path);
        return oidContainer.elements();
    }

    public void erase(XmlKey xmlKey) throws XmlBlasterException {
        String oid = xmlKey.getKeyOid();
        FileUtil.deleteFile(this.path, oid + "-XmlKey.xml");
        FileUtil.deleteFile(this.path, oid);
        FileUtil.deleteFile(this.path, oid + "-XmlQos.xml");
    }

    public String getType() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public String getName() {
        return ME;
    }

    public static void main(String[] args) {
        try {
            FileDriver driver = new FileDriver();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    private class XmlKeyFilter
    implements FilenameFilter {
        private XmlKeyFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith("-XmlKey.xml");
        }
    }
}

