/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.qos;

import org.xmlBlaster.authentication.plugins.I_ClientPlugin;
import org.xmlBlaster.authentication.plugins.I_SecurityQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.ConnectQosData;
import org.xmlBlaster.util.qos.SessionQos;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;

public final class ConnectQosServer {
    private String ME = "ConnectQosServer";
    private final Global glob;
    private final ConnectQosData connectQosData;
    private boolean bypassCredentialCheck = false;
    private long persistenceUniqueId;

    public ConnectQosServer(Global glob, ConnectQosData connectQosData) {
        this.glob = glob == null ? Global.instance() : glob;
        this.connectQosData = connectQosData;
    }

    public ConnectQosServer(Global glob, String xmlQos) throws XmlBlasterException {
        this.glob = glob == null ? Global.instance() : glob;
        this.connectQosData = glob.getConnectQosFactory().readObject(xmlQos);
    }

    public ConnectQosServer getClone(Global newGlob) throws XmlBlasterException {
        ConnectQosServer aClone = new ConnectQosServer(newGlob, this.toXml());
        aClone.bypassCredentialCheck(this.bypassCredentialCheck());
        aClone.isFromPersistenceRecovery(this.isFromPersistenceRecovery());
        aClone.setPersistenceUniqueId(this.getPersistenceUniqueId());
        return aClone;
    }

    public ConnectQosData getData() {
        return this.connectQosData;
    }

    public void bypassCredentialCheck(boolean bypassCredentialCheck) {
        this.bypassCredentialCheck = bypassCredentialCheck;
    }

    public boolean bypassCredentialCheck() {
        return this.bypassCredentialCheck;
    }

    public void isFromPersistenceRecovery(boolean fromPersistenceRecovery) {
        this.connectQosData.isFromPersistenceRecovery(fromPersistenceRecovery);
    }

    public long getPersistenceUniqueId() {
        return this.persistenceUniqueId;
    }

    public void setPersistenceUniqueId(long persistenceUniqueId) {
        this.persistenceUniqueId = persistenceUniqueId;
    }

    public boolean isFromPersistenceRecovery() {
        return this.connectQosData.isFromPersistenceRecovery();
    }

    public SessionQos getSessionQos() {
        return this.connectQosData.getSessionQos();
    }

    public int getMaxSessions() {
        return this.connectQosData.getSessionQos().getMaxSessions();
    }

    public boolean clearSessions() {
        return this.connectQosData.getSessionQos().clearSessions();
    }

    public long getSessionTimeout() {
        return this.connectQosData.getSessionQos().getSessionTimeout();
    }

    public boolean hasPublicSessionId() {
        if (this.getSessionName() != null) {
            return this.getSessionName().isSession();
        }
        return false;
    }

    public void setSessionName(SessionName sessionName) {
        this.getSessionQos().setSessionName(sessionName);
    }

    public SessionName getSessionName() {
        return this.getSessionQos().getSessionName();
    }

    public void setUserId(String loginName) throws XmlBlasterException {
        this.connectQosData.setUserId(loginName);
    }

    public String getUserId() {
        return this.connectQosData.getUserId();
    }

    public I_ClientPlugin loadClientPlugin(String mechanism, String version, String loginName, String passwd) throws XmlBlasterException {
        return this.connectQosData.loadClientPlugin(mechanism, version, loginName, passwd);
    }

    public I_SecurityQos getSecurityQos() {
        return this.connectQosData.getSecurityQos();
    }

    public String getClientPluginType() {
        return this.connectQosData.getClientPluginType();
    }

    public String getClientPluginVersion() {
        return this.connectQosData.getClientPluginVersion();
    }

    public void setPtpAllowed(boolean ptpAllowed) {
        this.connectQosData.setPtpAllowed(ptpAllowed);
    }

    public boolean isPtpAllowed() {
        return this.connectQosData.isPtpAllowed();
    }

    public void setDuplicateUpdates(boolean duplicateUpdates) {
        this.connectQosData.setDuplicateUpdates(duplicateUpdates);
    }

    public boolean duplicateUpdates() {
        return this.connectQosData.duplicateUpdates();
    }

    public void setAddress(Address address) {
        this.connectQosData.setAddress(address);
    }

    public void addCallbackAddress(CallbackAddress callback) {
        this.connectQosData.addCallbackAddress(callback);
    }

    public void setSessionCbQueueProperty(CbQueueProperty prop) {
        this.connectQosData.setSessionCbQueueProperty(prop);
    }

    public CbQueueProperty getSessionCbQueueProperty() {
        return this.connectQosData.getSessionCbQueueProperty();
    }

    public CbQueueProperty getSubjectQueueProperty() {
        return this.connectQosData.getSubjectQueueProperty();
    }

    public boolean isClusterNode() {
        return this.connectQosData.isClusterNode();
    }

    public String toString() {
        return this.toXml();
    }

    public String toXml(String extraOffset) {
        return this.connectQosData.toXml(extraOffset);
    }

    public String toXml() {
        return this.connectQosData.toXml();
    }
}

