/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.qos;

import java.util.ArrayList;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.queuemsg.TopicEntry;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.cluster.RouteInfo;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.qos.QosData;
import org.xmlBlaster.util.qos.TopicProperty;
import org.xmlBlaster.util.qos.address.Destination;

public final class PublishQosServer {
    private String ME = "PublishQosServer";
    private final Global glob;
    private final MsgQosData msgQosData;
    private boolean isClusterUpdate = false;
    private TopicEntry topicEntry;

    public PublishQosServer(Global glob, QosData msgQosData) {
        this(glob, (MsgQosData)msgQosData, false);
    }

    public PublishQosServer(Global glob, MsgQosData msgQosData, boolean fromPersistenceStore) {
        this.glob = glob;
        this.msgQosData = msgQosData;
        this.msgQosData.setFromPersistenceStore(fromPersistenceStore);
        if (!this.msgQosData.isFromPersistenceStore()) {
            this.msgQosData.touchRcvTimestamp();
        }
        this.completeDestinations();
    }

    public PublishQosServer(Global glob, String xmlQos) throws XmlBlasterException {
        this(glob, xmlQos, false);
    }

    public PublishQosServer(Global glob, String xmlQos, boolean fromPersistenceStore) throws XmlBlasterException {
        this(glob, glob.getMsgQosFactory().readObject(xmlQos), fromPersistenceStore);
    }

    private void completeDestinations() {
        if (this.getNumDestinations() > 0) {
            Destination[] arr = this.getDestinationArr();
            int i = 0;
            while (i < arr.length) {
                SessionName sessionName = arr[i].getDestination();
                if (sessionName.getNodeId() == null) {
                    sessionName = new SessionName((org.xmlBlaster.util.Global)this.glob, this.glob.getNodeId(), sessionName.getRelativeName());
                    arr[i].setDestination(sessionName);
                }
                ++i;
            }
        }
    }

    public MsgQosData getData() {
        return this.msgQosData;
    }

    public boolean isClusterUpdate() {
        return this.isClusterUpdate;
    }

    public void setClusterUpdate(boolean isClusterUpdate) {
        this.isClusterUpdate = isClusterUpdate;
    }

    public TopicEntry getTopicEntry() {
        return this.topicEntry;
    }

    public void setTopicEntry(TopicEntry topicEntry) {
        this.topicEntry = topicEntry;
    }

    public void setSubscribable(boolean isSubscribable) {
        this.msgQosData.setSubscribable(isSubscribable);
    }

    public boolean isSubscribable() {
        return this.msgQosData.isSubscribable();
    }

    public boolean isPtp() {
        return this.msgQosData.isPtp();
    }

    public boolean isVolatile() {
        return this.msgQosData.isVolatile();
    }

    public boolean isPersistent() {
        return this.msgQosData.isPersistent();
    }

    public boolean isForceUpdate() {
        return this.msgQosData.isForceUpdate();
    }

    public boolean isReadonly() {
        return this.msgQosData.isReadonly();
    }

    public SessionName getSender() {
        return this.msgQosData.getSender();
    }

    public void setSender(SessionName sender) {
        this.msgQosData.setSender(sender);
    }

    public String getState() {
        return this.msgQosData.getState();
    }

    public void addRouteInfo(RouteInfo routeInfo) {
        this.msgQosData.addRouteInfo(routeInfo);
    }

    public RouteInfo[] getRouteNodes() {
        return this.msgQosData.getRouteNodes();
    }

    public void clearRoutes() {
        this.msgQosData.clearRoutes();
    }

    public int count(NodeId nodeId) {
        return this.msgQosData.count(nodeId);
    }

    public boolean dirtyRead(NodeId nodeId) {
        return this.msgQosData.dirtyRead(nodeId);
    }

    public PriorityEnum getPriority() {
        return this.msgQosData.getPriority();
    }

    public void setPriority(PriorityEnum priority) {
        this.msgQosData.setPriority(priority);
    }

    public boolean isFromPersistenceStore() {
        return this.msgQosData.isFromPersistenceStore();
    }

    public void setFromPersistenceStore(boolean fromPersistenceStore) {
        this.msgQosData.setFromPersistenceStore(fromPersistenceStore);
    }

    public void setLifeTime(long lifeTime) {
        this.msgQosData.setLifeTime(lifeTime);
    }

    public long getLifeTime() {
        return this.msgQosData.getLifeTime();
    }

    public boolean isExpired() {
        return this.msgQosData.isExpired();
    }

    public Timestamp getRcvTimestamp() {
        return this.msgQosData.getRcvTimestamp();
    }

    public String getXmlRcvTimestamp() {
        return this.msgQosData.getXmlRcvTimestamp();
    }

    public void touchRcvTimestamp() {
        this.msgQosData.touchRcvTimestamp();
    }

    public long getRemainingLife() {
        return this.msgQosData.getRemainingLife();
    }

    public ArrayList getDestinations() {
        return this.msgQosData.getDestinations();
    }

    public Destination[] getDestinationArr() {
        return this.msgQosData.getDestinationArr();
    }

    public void removeDestination(Destination destination) {
        this.msgQosData.removeDestination(destination);
    }

    public int getNumDestinations() {
        return this.msgQosData.getNumDestinations();
    }

    public boolean hasTopicProperty() {
        return this.msgQosData.hasTopicProperty();
    }

    public TopicProperty getTopicProperty() {
        return this.msgQosData.getTopicProperty();
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        return this.msgQosData.toXml(extraOffset);
    }
}

