/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.query.plugins;

import java.util.ArrayList;
import java.util.Map;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.query.I_Query;
import org.xmlBlaster.engine.queuemsg.MsgQueueUpdateEntry;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.StringPairTokenizer;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.ClientProperty;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.qos.QueryRefinementQos;
import org.xmlBlaster.util.qos.QuerySpecQos;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueSizeListener;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public class QueueQueryPlugin
implements I_Query,
I_QueueSizeListener {
    private static final String ME = "QueueQueryPlugin";
    private Global global;
    private LogChannel log;
    private int maxEntries;
    private long maxSize;

    public QueueQueryPlugin(Global global) {
        this.global = global;
        this.log = global.getLog("query");
    }

    private final boolean checkIfNeedsWaiting(int entriesInQueue, long bytesInQueue, int maxEntries, long maxBytes) {
        if (maxEntries > 0 && entriesInQueue >= maxEntries) {
            return false;
        }
        return maxBytes <= 0L || bytesInQueue < maxBytes;
    }

    public MsgUnit[] query(Object source, QueryKeyData keyData, QueryQosData qosData) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "query for '" + keyData.getOid() + "'");
        }
        if (source == null) {
            throw new XmlBlasterException(this.global, ErrorCode.INTERNAL_ILLEGALARGUMENT, "QueueQueryPlugin.query", "the source on which do the query is null");
        }
        if (!(source instanceof I_Queue)) {
            throw new XmlBlasterException(this.global, ErrorCode.INTERNAL_ILLEGALARGUMENT, "QueueQueryPlugin.query", "wrong type of source for query. Expected an 'I_Queue' implementation but was '" + source.getClass().getName() + "'");
        }
        if (qosData == null) {
            throw new XmlBlasterException(this.global, ErrorCode.INTERNAL_ILLEGALARGUMENT, "QueueQueryPlugin.query", "the qos of the query was null");
        }
        I_Queue queue = (I_Queue)source;
        this.maxEntries = 1;
        this.maxSize = -1L;
        boolean consumable = false;
        long waitingDelay = 0L;
        QuerySpecQos[] querySpecs = qosData.getQuerySpecArr();
        QueryRefinementQos querySpec = null;
        if (querySpecs != null) {
            int i = 0;
            while (i < querySpecs.length) {
                if (querySpecs[i].getType().equals("QueueQuery")) {
                    querySpec = querySpecs[i];
                    break;
                }
                ++i;
            }
        }
        if (querySpec != null) {
            Map props;
            ClientProperty prop;
            String query = "";
            if (querySpec.getQuery() != null) {
                query = querySpec.getQuery().getQuery();
            }
            if ((prop = (ClientProperty)(props = StringPairTokenizer.parseToStringClientPropertyPairs(this.global, query, "&", "=")).get("maxEntries")) != null) {
                this.maxEntries = prop.getIntValue();
            }
            if ((prop = (ClientProperty)props.get("maxSize")) != null) {
                this.maxSize = prop.getLongValue();
            }
            if (this.maxSize > -1L) {
                throw new XmlBlasterException(this.global, ErrorCode.USER_ILLEGALARGUMENT, "QueueQueryPlugin.query: specification of maxSize is not implemented, please use the default value -1 or leave it untouched");
            }
            prop = (ClientProperty)props.get("consumable");
            if (prop != null) {
                consumable = prop.getBooleanValue();
            }
            if ((prop = (ClientProperty)props.get("waitingDelay")) != null) {
                waitingDelay = prop.getLongValue();
            }
        }
        if (this.log.TRACE) {
            this.log.trace(ME, "query: waitingDelay='" + waitingDelay + "' consumable='" + consumable + "' maxEntries='" + this.maxEntries + "' maxSize='" + this.maxSize + "'");
        }
        if (waitingDelay != 0L) {
            if (this.log.TRACE) {
                this.log.trace(ME, "query: waiting delay is " + waitingDelay);
            }
            if (this.maxEntries < 1 && this.maxSize < 1L && waitingDelay < 0L) {
                throw new XmlBlasterException(this.global, ErrorCode.USER_ILLEGALARGUMENT, "QueueQueryPlugin.query: if you specify a blocking get you must also specify a maximum size or maximum number of entries to retreive, otherwise specify non-blocking by setting 'waitingDelay' to zero");
            }
            if (this.checkIfNeedsWaiting((int)queue.getNumOfEntries(), queue.getNumOfBytes(), this.maxEntries, this.maxSize)) {
                if (this.log.TRACE) {
                    this.log.trace(ME, "query: going to wait due to first check");
                }
                QueueQueryPlugin query = this;
                synchronized (query) {
                    try {
                        block42: {
                            queue.addQueueSizeListener(this);
                            if (this.checkIfNeedsWaiting((int)queue.getNumOfEntries(), queue.getNumOfBytes(), this.maxEntries, this.maxSize)) {
                                if (this.log.TRACE) {
                                    this.log.trace(ME, "query: going to wait due to second check (inside sync now)");
                                }
                                try {
                                    if (waitingDelay < 0L) {
                                        this.wait();
                                    } else {
                                        this.wait(waitingDelay);
                                    }
                                    if (this.log.TRACE) {
                                        this.log.trace(ME, "did not wake up after waiting");
                                    }
                                }
                                catch (InterruptedException ex) {
                                    if (!this.log.TRACE) break block42;
                                    this.log.trace(ME, "just waked up after waiting for incoming entries");
                                }
                            }
                        }
                        Object var14_16 = null;
                    }
                    catch (Throwable throwable) {
                        block44: {
                            Object var14_17 = null;
                            try {
                                queue.removeQueueSizeListener(this);
                                if (this.log.TRACE) {
                                    this.log.trace(ME, "query: removed myself as a QueueSizeListener");
                                }
                            }
                            catch (Throwable ex) {
                                if (!this.log.TRACE) break block44;
                                this.log.trace(ME, "query: exception occurred when removing the QueueSizeListener from the queue");
                            }
                        }
                        throw throwable;
                    }
                    try {
                        queue.removeQueueSizeListener(this);
                        if (this.log.TRACE) {
                            this.log.trace(ME, "query: removed myself as a QueueSizeListener");
                        }
                    }
                    catch (Throwable ex) {
                        if (this.log.TRACE) {
                            this.log.trace(ME, "query: exception occurred when removing the QueueSizeListener from the queue");
                        }
                    }
                }
            }
        }
        ArrayList list = queue.peek(this.maxEntries, this.maxSize);
        ArrayList entryListChecked = DispatchManager.prepareMsgsFromQueue(ME, this.log, queue, list);
        I_Entry[] entries = entryListChecked.toArray(new MsgQueueEntry[entryListChecked.size()]);
        MsgUnit[] ret = new MsgUnit[entries.length];
        int i = 0;
        while (i < entries.length) {
            MsgQueueUpdateEntry entry = (MsgQueueUpdateEntry)entries[i];
            MsgUnit mu = entry.getMsgUnit();
            MsgQosData msgQosData = (MsgQosData)entry.getMsgQosData().clone();
            msgQosData.setTopicProperty(null);
            if (entry instanceof MsgQueueUpdateEntry) {
                MsgQueueUpdateEntry updateEntry = entry;
                msgQosData.setState(updateEntry.getState());
                msgQosData.setSubscriptionId(updateEntry.getSubscriptionId());
            }
            msgQosData.setQueueIndex(i);
            msgQosData.setQueueSize(entries.length);
            if (msgQosData.getNumRouteNodes() == 1) {
                msgQosData.clearRoutes();
            }
            ret[i] = new MsgUnit(mu, null, null, msgQosData);
            ++i;
        }
        if (consumable) {
            queue.removeRandom(entries);
        }
        return ret;
    }

    public void changed(I_Queue queue, long numEntries, long numBytes) {
        if (this.log.CALL) {
            this.log.call(ME, "changed numEntries='" + numEntries + "' numBytes='" + numBytes + "'");
        }
        if (!this.checkIfNeedsWaiting((int)numEntries, numBytes, this.maxEntries, this.maxSize)) {
            if (this.log.TRACE) {
                this.log.trace(ME, "changed going to notify");
            }
            QueueQueryPlugin queueQueryPlugin = this;
            synchronized (queueQueryPlugin) {
                this.notify();
            }
        }
    }
}

