/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.queuemsg;

import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.queuemsg.ReferenceEntry;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.queue.StorageId;

public final class MsgQueueHistoryEntry
extends ReferenceEntry {
    private static final String ME = "MsgQueueHistoryEntry";

    public MsgQueueHistoryEntry(Global glob, MsgUnitWrapper msgUnitWrapper, StorageId storageId) throws XmlBlasterException {
        super(ME, glob, "HISTORY_REF", msgUnitWrapper, null, storageId, null);
        if (this.log.TRACE) {
            this.log.trace("MsgQueueHistoryEntry-/client/" + this.getStorageId(), "Created new MsgQueueHistoryEntry for published message, id=" + this.getUniqueId() + " prio=" + this.priority.toString());
        }
    }

    public MsgQueueHistoryEntry(Global glob, PriorityEnum priority, StorageId storageId, Timestamp entryTimestamp, String keyOid, long msgUnitWrapperUniqueId, boolean persistent, long sizeInBytes) throws XmlBlasterException {
        super(ME, glob, "HISTORY_REF", priority, storageId, entryTimestamp, keyOid, msgUnitWrapperUniqueId, persistent, null, null, null, null);
        if (sizeInBytes != this.getSizeInBytes()) {
            this.log.error(ME, "Internal problem: From persistence sizeInBytes=" + sizeInBytes + " but expected " + this.getSizeInBytes());
        }
    }

    public int getPriority() {
        return PriorityEnum.NORM_PRIORITY.getInt();
    }

    public long getUniqueId() {
        return this.uniqueIdTimestamp.getTimestamp() < 0L ? this.uniqueIdTimestamp.getTimestamp() : -1L * this.uniqueIdTimestamp.getTimestamp();
    }

    public Long getUniqueIdLong() {
        return new Long(this.getUniqueId());
    }

    public long getSizeInBytes() {
        return 176L;
    }

    public Object clone() {
        MsgQueueHistoryEntry entry = null;
        entry = (MsgQueueHistoryEntry)super.clone();
        return entry;
    }
}

