/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.queuemsg;

import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.queuemsg.ReferenceEntry;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.queue.StorageId;

public final class MsgQueueUpdateEntry
extends ReferenceEntry {
    private static final String ME = "MsgQueueUpdateEntry";
    private final String subscriptionId;
    private final String state;

    public MsgQueueUpdateEntry(Global glob, MsgUnitWrapper msgUnitWrapper, StorageId storageId, SessionName receiver, String subscriptionId) throws XmlBlasterException {
        this(glob, msgUnitWrapper, (Timestamp)null, storageId, receiver, subscriptionId);
    }

    public MsgQueueUpdateEntry(Global glob, MsgUnitWrapper msgUnitWrapper, Timestamp timestamp, StorageId storageId, SessionName receiver, String subscriptionId) throws XmlBlasterException {
        super(ME, glob, "UPDATE_REF", msgUnitWrapper, timestamp, storageId, receiver);
        this.getMsgQosData().setSender(msgUnitWrapper.getMsgQosData().getSender());
        this.subscriptionId = subscriptionId;
        this.state = msgUnitWrapper.getMsgUnit().getQosData().getState();
        if (this.log.TRACE) {
            this.log.trace("MsgQueueUpdateEntry-/client/" + this.getStorageId(), "Created new MsgQueueUpdateEntry for published message '" + msgUnitWrapper.getLogId() + "', id=" + this.getUniqueId() + " prio=" + this.priority.toString());
        }
    }

    public MsgQueueUpdateEntry(Global glob, PriorityEnum priority, StorageId storageId, Timestamp updateEntryTimestamp, String keyOid, long msgUnitWrapperUniqueId, boolean persistent, long sizeInBytes, SessionName receiver, String subscriptionId, String state, int redeliverCount, String qos, String key, byte[] content) throws XmlBlasterException {
        super(ME, glob, "UPDATE_REF", priority, storageId, updateEntryTimestamp, keyOid, msgUnitWrapperUniqueId, persistent, receiver, qos, key, content);
        this.subscriptionId = subscriptionId;
        this.state = state;
        this.redeliverCounter = redeliverCount;
        if (sizeInBytes != this.getSizeInBytes()) {
            this.log.error(ME, "Internal problem: From persistence sizeInBytes=" + sizeInBytes + " but expected " + this.getSizeInBytes());
        }
    }

    public MsgQueueUpdateEntry(MsgQueueUpdateEntry entry, StorageId storageId) throws XmlBlasterException {
        this(entry.getGlobal(), entry.getMsgUnitWrapper(), entry.uniqueIdTimestamp, storageId, entry.getReceiver(), entry.getSubscriptionId());
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getState() {
        return this.state;
    }

    public long getSizeInBytes() {
        return 179L;
    }

    public Object getEmbeddedObject() {
        Object[] obj = new Object[]{this.keyOid, new Long(this.msgUnitWrapperUniqueId), this.receiver.getAbsoluteName(), this.subscriptionId, this.state, new Integer(this.getRedeliverCounter())};
        return obj;
    }

    public Object clone() {
        MsgQueueUpdateEntry entry = null;
        entry = (MsgQueueUpdateEntry)super.clone();
        return entry;
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        Timestamp ts = new Timestamp(this.msgUnitWrapperUniqueId);
        sb.append(offset).append("<MsgQueueUpdateEntry");
        sb.append(" id='").append(this.uniqueIdTimestamp.getTimestamp()).append("'");
        sb.append(" storageId='").append(this.getStorageId()).append("'");
        sb.append(offset).append(" keyOid='").append(this.getKeyOid()).append("'");
        sb.append(" msgUnitRcvTimestamp='").append(this.msgUnitWrapperUniqueId).append("'");
        sb.append(" msgUnitRcvTimestampStr='").append(ts.toString()).append("'");
        sb.append(offset).append(" sender='").append(this.getSender()).append("'");
        sb.append(" receiver='").append(this.getReceiver().getAbsoluteName()).append("'");
        sb.append(offset).append(" persistent='").append(this.isPersistent()).append("'");
        sb.append(" subscriptionId='").append(this.getSubscriptionId()).append("'");
        sb.append(" redeliverCounter='").append(this.getRedeliverCounter()).append("'");
        sb.append(offset).append(" isExpired='").append(this.isExpired()).append("'");
        sb.append(" isDestroyed='").append(this.isDestroyed()).append("'");
        sb.append(" state='").append(this.getState()).append("'");
        MsgUnitWrapper msgUnitWrapper = this.getMsgUnitWrapper();
        if (msgUnitWrapper != null) {
            sb.append(offset).append(msgUnitWrapper.toXml(extraOffset + " "));
        }
        sb.append("/>");
        return sb.toString();
    }
}

