/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.queuemsg;

import java.lang.ref.WeakReference;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.RequestBroker;
import org.xmlBlaster.engine.TopicHandler;
import org.xmlBlaster.engine.msgstore.I_Map;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public class ReferenceEntry
extends MsgQueueEntry {
    private final String ME;
    protected final transient Global glob;
    private transient WeakReference weakMsgUnitWrapper;
    protected String keyOid;
    protected long msgUnitWrapperUniqueId;
    protected SessionName receiver;
    public static final boolean STRICT_REFERENCE_COUNTING = true;
    public static final boolean STRICT_REFERENCE_COUNTING_COMPATIBLE = false;

    public ReferenceEntry(String ME, Global glob_, String entryType, MsgUnitWrapper msgUnitWrapper, Timestamp timestamp, StorageId storageId, SessionName receiver) throws XmlBlasterException {
        super(glob_, entryType, msgUnitWrapper == null ? PriorityEnum.NORM_PRIORITY : msgUnitWrapper.getMsgQosData().getPriority(), timestamp, storageId, msgUnitWrapper == null ? true : msgUnitWrapper.getMsgQosData().isPersistent());
        this.glob = glob_;
        this.ME = ME;
        this.setMsgUnitWrapper(msgUnitWrapper);
        this.setReceiver(receiver);
        this.wantReturnObj = msgUnitWrapper != null ? msgUnitWrapper.getWantReturnObj() : false;
    }

    public ReferenceEntry(String ME, Global glob, String entryType, MsgUnitWrapper msgUnitWrapper, StorageId storageId) throws XmlBlasterException {
        this(ME, glob, entryType, msgUnitWrapper, null, storageId, null);
    }

    public ReferenceEntry(String ME, Global glob, String entryType, PriorityEnum priority, StorageId storageId, Timestamp entryTimestamp, String keyOid, long msgUnitWrapperUniqueId, boolean persistent, SessionName receiver, String qos, String key, byte[] content) throws XmlBlasterException {
        super(glob, entryType, priority, entryTimestamp, storageId, persistent);
        this.glob = glob;
        this.ME = ME;
        this.keyOid = keyOid;
        this.msgUnitWrapperUniqueId = msgUnitWrapperUniqueId;
        this.setReceiver(receiver);
        this.wantReturnObj = false;
    }

    public final Global getGlobal() {
        return this.glob;
    }

    public MsgUnitWrapper getMsgUnitWrapper() {
        MsgUnitWrapper referent = null;
        if (this.weakMsgUnitWrapper != null) {
            referent = (MsgUnitWrapper)this.weakMsgUnitWrapper.get();
        }
        if (referent == null || ((MsgUnitWrapper)referent).isSwapped()) {
            this.weakMsgUnitWrapper = null;
            referent = this.lookup();
            if (referent == null) {
                return null;
            }
            this.weakMsgUnitWrapper = new WeakReference<MsgUnitWrapper>(referent);
        }
        MsgUnitWrapper msgUnitWrapper = referent;
        return msgUnitWrapper;
    }

    public I_Map getMsgUnitCache() {
        RequestBroker rb = this.glob.getRequestBroker();
        if (rb == null) {
            return null;
        }
        TopicHandler topicHandler = rb.getMessageHandlerFromOid(this.keyOid);
        if (topicHandler == null) {
            return null;
        }
        return topicHandler.getMsgUnitCache();
    }

    private void incrementReferenceCounter(int incr, StorageId storageId) {
        try {
            I_Map cache = this.getMsgUnitCache();
            if (cache == null) {
                return;
            }
            boolean preDestroyed = false;
            MsgUnitWrapper msgUnitWrapper = null;
            I_Map i_Map = cache;
            synchronized (i_Map) {
                msgUnitWrapper = this.getMsgUnitWrapper();
                if (msgUnitWrapper != null) {
                    preDestroyed = msgUnitWrapper.incrementReferenceCounter(incr, storageId);
                } else {
                    this.log.error(this.ME + "-" + this.getLogId(), "No no meat found, incr=" + incr);
                }
            }
            if (preDestroyed && msgUnitWrapper != null) {
                msgUnitWrapper.toDestroyed();
            }
        }
        catch (Throwable ex) {
            this.log.error(this.ME + "-" + this.getLogId(), "incr=" + incr + " to '" + storageId + "' raised an exception: " + ex.toString());
        }
    }

    public void added(StorageId storageId) {
        this.incrementReferenceCounter(1, storageId);
    }

    public void removed(StorageId storageId) {
        this.incrementReferenceCounter(-1, storageId);
    }

    public boolean isExpired() {
        MsgUnitWrapper msgUnitWrapper = this.getMsgUnitWrapper();
        if (msgUnitWrapper == null) {
            return true;
        }
        return msgUnitWrapper.isExpired();
    }

    public boolean isDestroyed() {
        I_Map cache = this.getMsgUnitCache();
        if (cache == null) {
            return true;
        }
        I_Map i_Map = cache;
        synchronized (i_Map) {
            MsgUnitWrapper msgUnitWrapper = this.getMsgUnitWrapper();
            if (msgUnitWrapper == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = msgUnitWrapper.isDestroyed();
            return bl;
        }
    }

    public MsgQosData getMsgQosData() throws XmlBlasterException {
        return (MsgQosData)this.getMsgUnit().getQosData();
    }

    public MsgUnit getMsgUnit() throws XmlBlasterException {
        MsgUnitWrapper msgUnitWrapper = this.getMsgUnitWrapper();
        if (msgUnitWrapper == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "Message " + this.getUniqueId() + " not found");
        }
        return msgUnitWrapper.getMsgUnit();
    }

    public void setMsgUnitWrapper(MsgUnitWrapper msgUnitWrapper) throws XmlBlasterException {
        if (msgUnitWrapper == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Given msgUnitWrapper is null");
        }
        this.weakMsgUnitWrapper = new WeakReference<MsgUnitWrapper>(msgUnitWrapper);
        this.keyOid = msgUnitWrapper.getMsgUnit().getKeyData().getOid();
        this.msgUnitWrapperUniqueId = msgUnitWrapper.getUniqueId();
    }

    public long getMsgUnitWrapperUniqueId() {
        return this.msgUnitWrapperUniqueId;
    }

    public String getKeyOid() {
        return this.keyOid;
    }

    public long getRcvTimestamp() {
        return 0L;
    }

    public final MsgKeyData getMsgKeyData() throws XmlBlasterException {
        return (MsgKeyData)this.getMsgUnit().getKeyData();
    }

    public boolean isInternal() {
        try {
            return this.getMsgKeyData().isInternal() || this.getMsgKeyData().isPluginInternal();
        }
        catch (XmlBlasterException e) {
            return false;
        }
    }

    public final SessionName getSender() {
        try {
            return this.getMsgQosData().getSender();
        }
        catch (XmlBlasterException e) {
            return null;
        }
    }

    public final SessionName getReceiver() {
        return this.receiver;
    }

    public final void setReceiver(SessionName receiver) {
        this.receiver = receiver;
    }

    private MsgUnitWrapper lookup() {
        RequestBroker rb = this.glob.getRequestBroker();
        if (rb == null) {
            return null;
        }
        TopicHandler topicHandler = rb.getMessageHandlerFromOid(this.keyOid);
        if (topicHandler == null) {
            return null;
        }
        try {
            return topicHandler.getMsgUnitWrapper(this.msgUnitWrapperUniqueId);
        }
        catch (XmlBlasterException e) {
            this.log.warn(this.ME, "lookup failed: " + e.getMessage());
            return null;
        }
    }

    public Object getEmbeddedObject() {
        Object[] obj = new Object[]{this.keyOid, new Long(this.msgUnitWrapperUniqueId)};
        return obj;
    }

    public Object clone() {
        ReferenceEntry entry = null;
        entry = (ReferenceEntry)super.clone();
        return entry;
    }
}

