/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.queuemsg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.qos.PublishQosServer;
import org.xmlBlaster.engine.queuemsg.MsgQueueHistoryEntry;
import org.xmlBlaster.engine.queuemsg.MsgQueueUpdateEntry;
import org.xmlBlaster.engine.queuemsg.SessionEntry;
import org.xmlBlaster.engine.queuemsg.SubscribeEntry;
import org.xmlBlaster.engine.queuemsg.TopicEntry;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_EntryFactory;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.DummyEntry;

public class ServerEntryFactory
implements I_EntryFactory {
    private static final String ME = "ServerEntryFactory";
    private Global glob = null;
    private LogChannel log = null;
    public static final String ENTRY_TYPE_MSG_SERIAL = "MSG_SER";
    public static final String ENTRY_TYPE_MSG_XML = "MSG_XML";
    public static final String ENTRY_TYPE_MSG_RAW = "MSG_RAW";
    public static final String ENTRY_TYPE_UPDATE_REF = "UPDATE_REF";
    public static final String ENTRY_TYPE_HISTORY_REF = "HISTORY_REF";
    public static final String ENTRY_TYPE_TOPIC_SERIAL = "TOPIC_SER";
    public static final String ENTRY_TYPE_TOPIC_XML = "TOPIC_XML";
    public static final String ENTRY_TYPE_SESSION = "SESSION";
    public static final String ENTRY_TYPE_SUBSCRIBE = "SUBSCRIBE";
    public static final String ENTRY_TYPE_DUMMY = "DUMMY";

    public byte[] toBlob(I_Entry entry) throws XmlBlasterException {
        try {
            Object obj = entry.getEmbeddedObject();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream objStream = new ObjectOutputStream(baos);
            objStream.writeObject(obj);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            this.log.error(ME, "toBlob: " + ex.getMessage());
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "toBlob()", ex);
        }
    }

    public I_Entry createEntry(int priority, long timestamp, String type, boolean persistent, long sizeInBytes, InputStream is, StorageId storageId) throws XmlBlasterException {
        if (ENTRY_TYPE_UPDATE_REF.equals(type)) {
            try {
                ObjectInputStream objStream = new ObjectInputStream(is);
                Object[] obj = (Object[])objStream.readObject();
                if (obj.length < 6) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 6 entries in serialized object '" + type + "' but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp + ". Could be a version incompatibility.");
                }
                String keyOid = (String)obj[0];
                Long msgUnitWrapperUniqueId = (Long)obj[1];
                String receiverStr = (String)obj[2];
                String subscriptionId = (String)obj[3];
                String state = (String)obj[4];
                Integer redeliverCount = (Integer)obj[5];
                String qos = null;
                String key = null;
                byte[] content = null;
                if (this.log.TRACE) {
                    this.log.trace(ME, "storageId=" + storageId + ": Read timestamp=" + timestamp + " topic keyOid=" + keyOid + " msgUnitWrapperUniqueId=" + msgUnitWrapperUniqueId + " receiverStr=" + receiverStr + " subscriptionId=" + subscriptionId + " state=" + state + " redeliverCount=" + redeliverCount);
                }
                SessionName receiver = new SessionName(this.glob, receiverStr);
                Timestamp updateEntryTimestamp = new Timestamp(timestamp);
                return new MsgQueueUpdateEntry(this.glob, PriorityEnum.toPriorityEnum(priority), storageId, updateEntryTimestamp, keyOid, msgUnitWrapperUniqueId, persistent, sizeInBytes, receiver, subscriptionId, state, redeliverCount, qos, key, content);
            }
            catch (Exception ex) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "createEntry-MsgQueueUpdateEntry", ex);
            }
        }
        if (ENTRY_TYPE_HISTORY_REF.equals(type)) {
            try {
                ObjectInputStream objStream = new ObjectInputStream(is);
                Object[] obj = (Object[])objStream.readObject();
                if (obj.length != 2) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 2 entries in serialized object '" + type + "' but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp + ". Could be a version incompatibility.");
                }
                String keyOid = (String)obj[0];
                Long msgUnitWrapperUniqueId = (Long)obj[1];
                Timestamp updateEntryTimestamp = new Timestamp(timestamp);
                return new MsgQueueHistoryEntry(this.glob, PriorityEnum.toPriorityEnum(priority), storageId, updateEntryTimestamp, keyOid, msgUnitWrapperUniqueId, persistent, sizeInBytes);
            }
            catch (Exception ex) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "createEntry-MsgQueueHistoryEntry", ex);
            }
        }
        if (ENTRY_TYPE_MSG_XML.equals(type)) {
            try {
                ObjectInputStream objStream = new ObjectInputStream(is);
                Object[] obj = (Object[])objStream.readObject();
                if (obj.length != 5) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 5 entries in serialized object stream but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp);
                }
                String qos = (String)obj[0];
                String key = (String)obj[1];
                byte[] content = (byte[])obj[2];
                Integer referenceCounter = (Integer)obj[3];
                Integer historyReferenceCounter = (Integer)obj[4];
                PublishQosServer publishQosServer = new PublishQosServer(this.glob, qos, true);
                MsgKeyData msgKeyData = this.glob.getMsgKeyFactory().readObject(key);
                MsgUnit msgUnit = new MsgUnit(msgKeyData, content, publishQosServer.getData());
                MsgUnitWrapper msgUnitWrapper = new MsgUnitWrapper(this.glob, msgUnit, storageId, (int)referenceCounter, (int)historyReferenceCounter, sizeInBytes);
                return msgUnitWrapper;
            }
            catch (Exception ex) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "createEntry-MsgUnitWrapper", ex);
            }
        }
        if (ENTRY_TYPE_MSG_SERIAL.equals(type)) {
            try {
                ObjectInputStream objStream = new ObjectInputStream(is);
                Object[] obj = (Object[])objStream.readObject();
                if (obj.length != 3) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 3 entries in serialized object stream but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp);
                }
                MsgUnit msgUnit = (MsgUnit)obj[0];
                Integer referenceCounter = (Integer)obj[1];
                Integer historyReferenceCounter = (Integer)obj[2];
                msgUnit.setGlobal(this.glob);
                MsgUnitWrapper msgUnitWrapper = new MsgUnitWrapper(this.glob, msgUnit, storageId, (int)referenceCounter, (int)historyReferenceCounter, sizeInBytes);
                return msgUnitWrapper;
            }
            catch (Exception ex) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "createEntry-MsgUnitWrapper", ex);
            }
        }
        if (ENTRY_TYPE_TOPIC_XML.equals(type)) {
            try {
                ObjectInputStream objStream = new ObjectInputStream(is);
                Object[] obj = (Object[])objStream.readObject();
                if (obj.length != 2) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 2 entries in serialized object stream but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp);
                }
                String qos = (String)obj[0];
                String key = (String)obj[1];
                byte[] content = null;
                PublishQosServer publishQosServer = new PublishQosServer(this.glob, qos, true);
                MsgKeyData msgKeyData = this.glob.getMsgKeyFactory().readObject(key);
                MsgUnit msgUnit = new MsgUnit(msgKeyData, content, publishQosServer.getData());
                TopicEntry topicEntry = new TopicEntry(this.glob, msgUnit, type, sizeInBytes);
                return topicEntry;
            }
            catch (Exception ex) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "createEntry-TopicEntry", ex);
            }
        }
        if (ENTRY_TYPE_TOPIC_SERIAL.equals(type)) {
            try {
                ObjectInputStream objStream = new ObjectInputStream(is);
                Object[] obj = (Object[])objStream.readObject();
                if (obj.length != 1) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 1 entry in serialized object stream but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp);
                }
                MsgUnit msgUnit = (MsgUnit)obj[0];
                msgUnit.setGlobal(this.glob);
                TopicEntry topicEntry = new TopicEntry(this.glob, msgUnit, type, sizeInBytes);
                return topicEntry;
            }
            catch (Exception ex) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "createEntry-TopicEntry", ex);
            }
        }
        if (ENTRY_TYPE_SESSION.equals(type)) {
            try {
                ObjectInputStream objStream = new ObjectInputStream(is);
                Object[] obj = (Object[])objStream.readObject();
                if (obj.length != 1) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 1 entry in serialized object stream but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp);
                }
                String xmlLiteral = (String)obj[0];
                SessionEntry sessionEntry = new SessionEntry(xmlLiteral, timestamp, sizeInBytes);
                return sessionEntry;
            }
            catch (Exception ex) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "createEntry-TopicEntry", ex);
            }
        }
        if (ENTRY_TYPE_SUBSCRIBE.equals(type)) {
            try {
                ObjectInputStream objStream = new ObjectInputStream(is);
                Object[] obj = (Object[])objStream.readObject();
                if (obj.length != 3) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 3 entries in serialized object stream but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp);
                }
                String keyLiteral = (String)obj[0];
                String qosLiteral = (String)obj[1];
                String sessionName = (String)obj[2];
                SubscribeEntry subscribeEntry = new SubscribeEntry(keyLiteral, qosLiteral, sessionName, timestamp, sizeInBytes);
                return subscribeEntry;
            }
            catch (Exception ex) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "createEntry-TopicEntry", ex);
            }
        }
        if (ENTRY_TYPE_DUMMY.equals(type)) {
            DummyEntry entry = new DummyEntry((org.xmlBlaster.util.Global)this.glob, PriorityEnum.toPriorityEnum(priority), new Timestamp(timestamp), storageId, sizeInBytes, persistent);
            return entry;
        }
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, ME, "Persistent object '" + type + "' is not implemented");
    }

    public void initialize(org.xmlBlaster.util.Global glob) {
        this.glob = (Global)glob;
        this.log = glob.getLog("queue");
        if (this.log.TRACE) {
            this.log.trace(ME, "Successfully initialized");
        }
    }

    public void setProperties(Object userData) {
    }

    public Object getProperties() {
        return null;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        LogChannel log = glob.getLog("test");
        try {
            String[] persistType = new String[]{ENTRY_TYPE_MSG_SERIAL, ENTRY_TYPE_MSG_XML};
            int numRuns = 4;
            int ii = 0;
            while (ii < numRuns) {
                int jj = 0;
                while (jj < persistType.length) {
                    PublishKey publishKey = new PublishKey((org.xmlBlaster.util.Global)glob, "HA");
                    PublishQosServer publishQosServer = new PublishQosServer(glob, "<qos><persistent/></qos>");
                    publishQosServer.getData().setPriority(PriorityEnum.HIGH_PRIORITY);
                    MsgUnit msgUnit = new MsgUnit(publishKey.getData(), "HO".getBytes(), publishQosServer.getData());
                    StorageId storageId = new StorageId("mystore", "someid");
                    MsgUnitWrapper msgUnitWrapper = new MsgUnitWrapper(glob, msgUnit, null, storageId, 0, 0, persistType[jj], -1L);
                    I_EntryFactory factory = glob.getEntryFactory();
                    int priority = msgUnitWrapper.getPriority();
                    long timestamp = msgUnitWrapper.getUniqueId();
                    String type = msgUnitWrapper.getEmbeddedType();
                    boolean persistent = msgUnitWrapper.isPersistent();
                    long sizeInBytes = msgUnitWrapper.getSizeInBytes();
                    String ME = persistType[jj];
                    int numTransform = 1000;
                    StopWatch stopWatchToBlob = new StopWatch();
                    int kk = 0;
                    while (kk < numTransform) {
                        byte[] blob = factory.toBlob(msgUnitWrapper);
                        ++kk;
                    }
                    double elapsed = stopWatchToBlob.elapsed();
                    log.info(ME, "num toBlob=" + numTransform + " elapsed=" + elapsed + stopWatchToBlob.nice());
                    byte[] blob = factory.toBlob(msgUnitWrapper);
                    MsgUnitWrapper newWrapper = null;
                    StopWatch stopWatchToObj = new StopWatch();
                    int kk2 = 0;
                    while (kk2 < numTransform) {
                        newWrapper = (MsgUnitWrapper)factory.createEntry(priority, timestamp, type, persistent, sizeInBytes, new ByteArrayInputStream(blob), storageId);
                        ++kk2;
                    }
                    elapsed = stopWatchToObj.elapsed();
                    log.info(ME, "num toObj=" + numTransform + " elapsed=" + elapsed + stopWatchToObj.nice());
                    log.trace(ME, "SUCESS BEFORE: " + msgUnitWrapper.toXml());
                    log.trace(ME, "SUCESS AFTER: " + newWrapper.toXml());
                    ++jj;
                }
                ++ii;
            }
        }
        catch (XmlBlasterException e) {
            System.out.println("ERROR " + e.getMessage());
        }
    }
}

