/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.queuemsg;

import org.xmlBlaster.engine.msgstore.I_MapEntry;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.queue.StorageId;

public class SessionEntry
implements I_MapEntry {
    private String qos;
    private transient boolean swapped = false;
    private boolean stored;
    private long uniqueId;
    private String uniqueIdStr;
    private long size;
    private transient Timestamp sortTimestamp;

    public SessionEntry(String qos, long uniqueId, long size) {
        this.size = size < 1L ? (long)qos.length() : size;
        if (uniqueId < 1L) {
            this.uniqueId = new Timestamp().getTimestamp();
        }
        this.qos = qos;
        this.uniqueId = uniqueId;
        this.uniqueIdStr = "" + this.uniqueId;
    }

    public SessionEntry(String qos, String sessionId) {
        this(qos, -1L, 0L);
    }

    public String getUniqueIdStr() {
        return this.uniqueIdStr;
    }

    public int getPriority() {
        return PriorityEnum.NORM_PRIORITY.getInt();
    }

    public boolean isPersistent() {
        return true;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public Object getEmbeddedObject() {
        return new Object[]{this.qos};
    }

    public String getQos() {
        return this.qos;
    }

    public String getEmbeddedType() {
        return "SESSION";
    }

    public String getLogId() {
        return this.getEmbeddedType() + "/" + this.uniqueIdStr;
    }

    public long getSizeInBytes() {
        return this.size;
    }

    public void added(StorageId storageId) {
    }

    public void removed(StorageId storageId) {
    }

    public void setStored(boolean stored) {
        this.stored = stored;
    }

    public boolean isStored() {
        return this.stored;
    }

    public boolean isSwapped() {
        return this.swapped;
    }

    public void isSwapped(boolean swapped) {
        this.swapped = swapped;
    }

    public final Timestamp getSortTimestamp() {
        return this.sortTimestamp;
    }

    public final void setSortTimestamp(Timestamp timestamp) {
        this.sortTimestamp = timestamp;
    }
}

