/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.queuemsg;

import org.xmlBlaster.engine.msgstore.I_MapEntry;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.queue.StorageId;

public class SubscribeEntry
implements I_MapEntry {
    private final String key;
    private final String qos;
    private final String sessionName;
    private boolean stored;
    private final long uniqueId;
    private final String uniqueIdStr;
    private final long size;
    private transient boolean swapped = false;
    private transient Timestamp sortTimestamp;

    public SubscribeEntry(String key, String qos, String sessionName, long uniqueId, long size) {
        this.size = size < 1L ? (long)(qos.length() + key.length() + sessionName.length()) : size;
        this.key = key;
        this.qos = qos;
        this.sessionName = sessionName;
        this.uniqueId = uniqueId < 1L ? new Timestamp().getTimestamp() : uniqueId;
        this.uniqueIdStr = "" + this.uniqueId;
    }

    public String getUniqueIdStr() {
        return this.uniqueIdStr;
    }

    public int getPriority() {
        return PriorityEnum.NORM_PRIORITY.getInt();
    }

    public boolean isPersistent() {
        return true;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public Object getEmbeddedObject() {
        return new Object[]{this.key, this.qos, this.sessionName};
    }

    public String getQos() {
        return this.qos;
    }

    public String getKey() {
        return this.key;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getEmbeddedType() {
        return "SUBSCRIBE";
    }

    public String getLogId() {
        return this.getEmbeddedType() + "/" + this.uniqueIdStr;
    }

    public long getSizeInBytes() {
        return this.size;
    }

    public void added(StorageId storageId) {
    }

    public void removed(StorageId storageId) {
    }

    public void setStored(boolean stored) {
        this.stored = stored;
    }

    public boolean isStored() {
        return this.stored;
    }

    public boolean isSwapped() {
        return this.swapped;
    }

    public void isSwapped(boolean swapped) {
        this.swapped = swapped;
    }

    public final Timestamp getSortTimestamp() {
        return this.sortTimestamp;
    }

    public final void setSortTimestamp(Timestamp timestamp) {
        this.sortTimestamp = timestamp;
    }
}

