/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.queuemsg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.msgstore.I_MapEntry;
import org.xmlBlaster.engine.qos.PublishQosServer;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.queue.StorageId;

public final class TopicEntry
implements I_MapEntry {
    private final transient String ME;
    private final transient Global glob;
    private final transient long uniqueId;
    private final transient String uniqueIdStr;
    private final transient String embeddedType;
    private MsgUnit msgUnit;
    private final long immutableSizeInBytes;
    private transient boolean stored = false;
    private transient boolean swapped = false;
    private transient Timestamp sortTimestamp;

    public TopicEntry(Global glob, MsgUnit msgUnit) throws XmlBlasterException {
        this(glob, msgUnit, null, -1L);
    }

    public TopicEntry(Global glob, MsgUnit msgUnit, String embeddedType, long sizeInBytes) throws XmlBlasterException {
        this.glob = glob;
        if (msgUnit == null) {
            throw new XmlBlasterException(glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "TopicEntry", "Invalid constructor parameter msgUnit==null");
        }
        this.msgUnit = msgUnit;
        String string = this.embeddedType = embeddedType == null ? "TOPIC_XML" : embeddedType;
        if (this.getMsgQosData().getRcvTimestamp() == null) {
            throw new XmlBlasterException(glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "TopicEntry", "Missing timestamp, try to create publish QoS with PublishQosServer.java");
        }
        this.uniqueId = this.getMsgQosData().getRcvTimestamp().getTimestamp();
        this.uniqueIdStr = "" + this.uniqueId;
        this.ME = "TopicEntry-" + this.getLogId();
        this.immutableSizeInBytes = sizeInBytes >= 0L ? sizeInBytes : this.msgUnit.size();
    }

    public int getPriority() {
        return PriorityEnum.NORM_PRIORITY.getInt();
    }

    public MsgQosData getMsgQosData() {
        return (MsgQosData)this.msgUnit.getQosData();
    }

    public boolean isPersistent() {
        return this.getMsgQosData().isPersistent();
    }

    public MsgKeyData getMsgKeyData() {
        return (MsgKeyData)this.msgUnit.getKeyData();
    }

    public MsgUnit getMsgUnit() {
        return this.msgUnit;
    }

    public String getKeyOid() {
        return this.getMsgKeyData().getOid();
    }

    public String getContentMime() {
        return this.getMsgKeyData().getContentMime();
    }

    public String getContentMimeExtended() {
        return this.getMsgKeyData().getContentMimeExtended();
    }

    public String getDomain() {
        return this.getMsgKeyData().getDomain();
    }

    public void setMsgUnit(MsgUnit msg) {
        this.msgUnit = msg;
    }

    public long getSizeInBytes() {
        return this.immutableSizeInBytes;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public String getUniqueIdStr() {
        return this.uniqueIdStr;
    }

    public String getLogId() {
        return this.getKeyOid() + "/" + this.getMsgQosData().getRcvTimestamp();
    }

    public final boolean isInternal() {
        return this.getMsgKeyData().isInternal();
    }

    public String getEmbeddedType() {
        return this.embeddedType;
    }

    public Object getEmbeddedObject() {
        if (this.embeddedType.equals("TOPIC_SER")) {
            Object[] obj = new Object[]{this.msgUnit};
            return obj;
        }
        Object[] obj = new Object[]{this.msgUnit.getQosData().toXml(), this.msgUnit.getKeyData().toXml()};
        return obj;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(2000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<TopicEntry id='").append(this.getLogId()).append("'>");
        sb.append(this.msgUnit.toXml(" " + extraOffset));
        sb.append(offset).append("</TopicEntry>");
        return sb.toString();
    }

    public void added(StorageId storageId) {
        this.glob.getLog("core").error(this.ME, "added(" + storageId.getId() + ") invocation not expected (internal illegal argument)");
    }

    public void removed(StorageId storageId) {
        this.glob.getLog("core").error(this.ME, "removed(" + storageId.getId() + ") invocation not expected (internal illegal argument)");
    }

    public boolean isExpired() {
        return false;
    }

    public final void setStored(boolean stored) {
        this.stored = stored;
    }

    public final boolean isStored() {
        return this.stored;
    }

    public boolean isSwapped() {
        return this.swapped;
    }

    public void isSwapped(boolean swapped) {
        this.swapped = swapped;
    }

    public final Timestamp getSortTimestamp() {
        return this.sortTimestamp;
    }

    public final void setSortTimestamp(Timestamp timestamp) {
        this.sortTimestamp = timestamp;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        String fileName = "TopicEntry.ser";
        try {
            PublishKey publishKey = new PublishKey((org.xmlBlaster.util.Global)glob, "HA");
            PublishQosServer publishQosServer = new PublishQosServer(glob, "<qos><persistent/></qos>");
            publishQosServer.getData().setPriority(PriorityEnum.HIGH_PRIORITY);
            MsgUnit msgUnit = new MsgUnit(publishKey.getData(), "HO".getBytes(), publishQosServer.getData());
            TopicEntry msgUnitWrapper = new TopicEntry(glob, msgUnit);
            try {
                FileOutputStream f = new FileOutputStream(fileName);
                ObjectOutputStream objStream = new ObjectOutputStream(f);
                objStream.writeObject(msgUnitWrapper);
                objStream.flush();
                File file = new File(fileName);
                System.out.println("SUCCESS written java.io.Serialized file '" + fileName + "' size=" + file.length() + " versus XML dump=" + msgUnitWrapper.getSizeInBytes());
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e.getMessage());
            }
        }
        catch (XmlBlasterException e) {
            System.err.println("ERROR: " + e.getMessage());
        }
    }
}

