/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.runlevel;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.runlevel.RunLevelAction;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.plugin.PluginInfo;

public class PluginConfig {
    private String ME = "PluginConfig";
    private final Global glob;
    private final LogChannel log;
    private String id = "";
    private String className = "";
    private String jarPath;
    private Vector actions;
    private RunLevelAction upAction;
    private RunLevelAction downAction;
    private Properties attributes;
    private HashSet wrappedAttributes;
    Timestamp uniqueTimestamp = new Timestamp();

    public PluginConfig(Global glob, String id, String className, String jar, Properties attributes, Vector actions) {
        this.glob = glob;
        this.log = this.glob.getLog("runlevel");
        this.id = id;
        this.className = className;
        this.jarPath = jar;
        this.attributes = attributes != null ? attributes : new Properties();
        this.actions = actions != null ? actions : new Vector();
        this.wrappedAttributes = new HashSet();
    }

    public PluginConfig(Global glob, String id, String className, Properties attributes) {
        this(glob, id, className, null, attributes, null);
    }

    public PluginConfig(Global glob, String id, String className) {
        this(glob, id, className, null, null, null);
    }

    public PluginConfig(Global glob) {
        this(glob, "", "", null, null, null);
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public void addAction(RunLevelAction action) {
        if (action == null) {
            this.log.warn(this.ME, "addAction the action is null");
            return;
        }
        if (action.getOnStartupRunlevel() > -1) {
            this.upAction = action;
        } else if (action.getOnShutdownRunlevel() > -1) {
            this.downAction = action;
        }
        this.actions.add(action);
    }

    public RunLevelAction getUpAction() {
        return this.upAction;
    }

    public RunLevelAction getDownAction() {
        return this.downAction;
    }

    public void addAttribute(String key, String value) {
        this.attributes.setProperty(key, value);
    }

    public RunLevelAction[] getActions() {
        return this.actions.toArray(new RunLevelAction[this.actions.size()]);
    }

    public void setId(String id) {
        if (id != null) {
            this.id = id;
        }
    }

    public void setClassName(String className) {
        if (className != null) {
            this.className = className;
        }
    }

    public void setJar(String jar) {
        if (jar != null) {
            this.jarPath = jar;
        }
    }

    public PluginInfo getPluginInfo() {
        return new PluginInfo(this.glob, this.id, this.className, this.attributes);
    }

    public void wrapAttributeInCDATA(String attributeKey) {
        this.wrappedAttributes.add(attributeKey);
    }

    public void unwrapAttributeFromCDATA(String attributeKey) {
        this.wrappedAttributes.remove(attributeKey);
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(512);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<plugin ");
        sb.append("id='").append(this.id).append("' ");
        sb.append("className='").append(this.className).append("' ");
        if (this.jarPath != null) {
            sb.append("jar='").append(this.jarPath).append("' ");
        }
        sb.append(">");
        String offset2 = offset + "   ";
        Enumeration<Object> enumer = ((Hashtable)this.attributes).keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            String value = this.attributes.getProperty(key);
            sb.append(offset2).append("<attribute id='").append(key).append("'>");
            if (this.wrappedAttributes.contains(key)) {
                sb.append("<![CDATA[").append(value).append("]]>");
            } else {
                sb.append(value);
            }
            sb.append("</attribute>");
        }
        enumer = this.actions.elements();
        while (enumer.hasMoreElements()) {
            RunLevelAction value = (RunLevelAction)enumer.nextElement();
            sb.append(value.toXml(extraOffset + "   "));
        }
        sb.append(offset).append("</plugin>");
        return sb.toString();
    }

    public String toXml() {
        return this.toXml("");
    }
}

