/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.runlevel;

import java.util.Comparator;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.runlevel.PluginConfig;
import org.xmlBlaster.engine.runlevel.RunLevelAction;
import org.xmlBlaster.util.Global;

public class PluginConfigComparator
implements Comparator {
    private String ME = "PluginConfigComparator";
    private final Global glob;
    private final LogChannel log;
    private boolean isAscending = true;

    public PluginConfigComparator(Global glob, boolean isAscending) {
        this.isAscending = isAscending;
        this.glob = glob;
        this.log = this.glob.getLog("runlevel");
        if (this.log.CALL) {
            this.log.call(this.ME, "constructor");
        }
    }

    public final int compare(Object o1, Object o2) {
        if (!(o1 instanceof PluginConfig) || !(o2 instanceof PluginConfig)) {
            String o1Txt = "null";
            String o2Txt = "null";
            if (o1 != null) {
                o1Txt = o1.toString();
            }
            if (o2 != null) {
                o2Txt = o2.toString();
            }
            throw new ClassCastException(this.ME + " comparison between '" + o1Txt + "' and '" + o2Txt + "' is not possible because wrong types");
        }
        PluginConfig p1 = (PluginConfig)o1;
        PluginConfig p2 = (PluginConfig)o2;
        RunLevelAction action1 = null;
        RunLevelAction action2 = null;
        if (this.isAscending) {
            action1 = p1.getUpAction();
            action2 = p2.getUpAction();
            int diff = action1.getOnStartupRunlevel() - action2.getOnStartupRunlevel();
            if (diff != 0) {
                return diff;
            }
            diff = action1.getSequence() - action2.getSequence();
            if (diff != 0) {
                return diff;
            }
            return p1.uniqueTimestamp.compareTo(p2.uniqueTimestamp);
        }
        action1 = p1.getDownAction();
        action2 = p2.getDownAction();
        int diff = action2.getOnShutdownRunlevel() - action1.getOnShutdownRunlevel();
        if (diff != 0) {
            return diff;
        }
        diff = action1.getSequence() - action2.getSequence();
        if (diff != 0) {
            return diff;
        }
        return p2.uniqueTimestamp.compareTo(p1.uniqueTimestamp);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

