/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.runlevel;

import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.engine.runlevel.PluginConfig;
import org.xmlBlaster.engine.runlevel.RunLevelActionSaxFactory;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SaxHandlerBase;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class PluginConfigSaxFactory
extends SaxHandlerBase {
    private String ME = "PluginConfigSaxFactory";
    private final Global glob;
    private final LogChannel log;
    private PluginConfig pluginConfig;
    private boolean isPlugin = false;
    private XmlBlasterException ex;
    private RunLevelActionSaxFactory actionFactory;
    private String attributeKey;
    private StringBuffer attributeValue;
    private boolean inAction = false;
    private boolean wrappedInCDATA = false;

    public PluginConfigSaxFactory(Global glob) {
        super(glob);
        this.setUseLexicalHandler(true);
        this.glob = glob;
        this.log = glob.getLog("runlevel");
        this.actionFactory = new RunLevelActionSaxFactory(this.glob);
    }

    public void reset() {
        this.ex = null;
        this.pluginConfig = new PluginConfig(this.glob);
        this.inAction = false;
        this.isPlugin = false;
        this.wrappedInCDATA = false;
    }

    public PluginConfig getObject() {
        return this.pluginConfig;
    }

    public synchronized PluginConfig readObject(String xmlTxt) throws XmlBlasterException {
        if (xmlTxt == null || xmlTxt.trim().length() < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "the <plugin> element is empty");
        }
        this.reset();
        try {
            this.init(xmlTxt);
        }
        catch (Throwable thr) {
            if (this.log.TRACE) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "exception occured when parsing the <plugin> tag. In fact it was '" + xmlTxt + "'", thr);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "exception occured when parsing the <plugin> tag. In fact it was '" + xmlTxt + "'");
        }
        if (this.ex != null) {
            throw this.ex;
        }
        if (!this.isPlugin) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "the string '" + xmlTxt + "' does not contain the <plugin> tag");
        }
        return this.pluginConfig;
    }

    public final void startElement(String uri, String localName, String name, Attributes attrs) {
        if (this.ex != null) {
            return;
        }
        if ("action".equalsIgnoreCase(name)) {
            this.inAction = true;
            this.actionFactory.reset();
        }
        if (this.inAction) {
            this.actionFactory.startElement(uri, localName, name, attrs);
            return;
        }
        if ("plugin".equalsIgnoreCase(name)) {
            this.isPlugin = true;
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    String key = attrs.getQName(i);
                    String value = attrs.getValue(i).trim();
                    if ("id".equalsIgnoreCase(key)) {
                        this.pluginConfig.setId(value);
                    } else if ("className".equalsIgnoreCase(key)) {
                        this.pluginConfig.setClassName(value);
                    } else if ("jar".equalsIgnoreCase(key)) {
                        this.pluginConfig.setJar(value);
                    } else {
                        this.log.warn(this.ME, "startElement: " + key + "='" + value + "' is unknown");
                    }
                    ++i;
                }
            }
            return;
        }
        if ("attribute".equalsIgnoreCase(name)) {
            this.wrappedInCDATA = false;
            this.attributeKey = attrs.getValue("id");
            this.attributeValue = new StringBuffer();
            if (this.attributeKey == null || this.attributeKey.length() < 1) {
                this.ex = new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".startElement", "the attributes in the <plugin> tag must have an non-empty 'id' attribute");
            }
            return;
        }
        this.log.warn(this.ME, "startElement: unknown tag '" + name + "'");
    }

    public void startCDATA() {
        if (this.log.CALL) {
            this.log.call(this.ME, "startCDATA");
        }
        this.wrappedInCDATA = true;
    }

    public void characters(char[] ch, int start, int length) {
        if (this.attributeValue != null) {
            this.attributeValue.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String name) {
        if (this.ex != null) {
            return;
        }
        if (this.inAction) {
            this.actionFactory.endElement(uri, localName, name);
            if ("action".equalsIgnoreCase(name)) {
                this.pluginConfig.addAction(this.actionFactory.getObject());
                this.inAction = false;
            }
            return;
        }
        if ("attribute".equalsIgnoreCase(name)) {
            if (this.attributeKey != null && this.attributeValue != null) {
                this.pluginConfig.addAttribute(this.attributeKey, this.attributeValue.toString());
                if (this.wrappedInCDATA) {
                    this.pluginConfig.wrapAttributeInCDATA(this.attributeKey);
                    this.wrappedInCDATA = false;
                }
            }
            this.attributeKey = null;
            this.attributeValue = null;
            return;
        }
    }

    public final String writeObject(PluginConfig pluginConfig, String extraOffset) {
        return pluginConfig.toXml(extraOffset);
    }

    public String getName() {
        return "PluginConfigSaxFactory";
    }
}

