/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.runlevel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.runlevel.PluginConfig;
import org.xmlBlaster.engine.runlevel.PluginConfigComparator;
import org.xmlBlaster.engine.runlevel.RunLevelAction;
import org.xmlBlaster.util.Global;

public class PluginHolder {
    private String ME = "PluginHolder";
    private final Global glob;
    private final LogChannel log;
    private Hashtable pluginConfigsDefault;
    private Hashtable pluginConfigsNodes;

    public PluginHolder(Global glob, Hashtable pluginConfigsDefault, Hashtable pluginConfigsNodes) {
        this.glob = glob;
        this.log = this.glob.getLog("runlevel");
        if (this.log.CALL) {
            this.log.call(this.ME, "constructor");
        }
        this.pluginConfigsDefault = pluginConfigsDefault != null ? pluginConfigsDefault : new Hashtable();
        this.pluginConfigsNodes = pluginConfigsNodes != null ? pluginConfigsNodes : new Hashtable();
    }

    public PluginHolder(Global glob) {
        this(glob, null, null);
    }

    public void addDefaultPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfigsDefault.put(pluginConfig.getId(), pluginConfig);
    }

    public void addPluginConfig(String node, PluginConfig pluginConfig) {
        Hashtable<String, PluginConfig> tmp;
        if (this.log.CALL) {
            this.log.call(this.ME, "addPluginConfig for node '" + node + "'");
        }
        if ((tmp = (Hashtable<String, PluginConfig>)this.pluginConfigsNodes.get(node)) == null) {
            tmp = new Hashtable<String, PluginConfig>();
            this.pluginConfigsNodes.put(node, tmp);
        }
        tmp.put(pluginConfig.getId(), pluginConfig);
    }

    public PluginConfig getPluginConfig(String node, String id) {
        Object tmp;
        Hashtable nodeTable;
        if (this.log.CALL) {
            this.log.call(this.ME, "getPluginConfig for node '" + node + "'");
        }
        if ((nodeTable = (Hashtable)this.pluginConfigsNodes.get(node)) != null && (tmp = nodeTable.get(id)) != null) {
            return (PluginConfig)tmp;
        }
        return (PluginConfig)this.pluginConfigsDefault.get(id);
    }

    public PluginConfig[] getAllPluginConfig(String node) {
        if (this.log.CALL) {
            this.log.call(this.ME, "getAllPluginConfig for node '" + node + "'");
        }
        Hashtable tmp = (Hashtable)this.pluginConfigsDefault.clone();
        if (this.pluginConfigsNodes != null && node != null) {
            Hashtable nodeTable = (Hashtable)this.pluginConfigsNodes.get(node);
            if (nodeTable != null) {
                Enumeration enumer = nodeTable.keys();
                while (enumer.hasMoreElements()) {
                    String key = (String)enumer.nextElement();
                    tmp.put(key, nodeTable.get(key));
                }
            }
        } else {
            this.log.warn(this.ME, "No cluster node id given, checking only default plugins");
        }
        int size = tmp.size();
        PluginConfig[] ret = new PluginConfig[size];
        int i = 0;
        Enumeration enumer = tmp.keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            ret[i] = (PluginConfig)tmp.get(key);
            ++i;
        }
        return ret;
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(512);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<xmlBlaster>");
        Enumeration enumer = this.pluginConfigsDefault.keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            PluginConfig pluginConfig = (PluginConfig)this.pluginConfigsDefault.get(key);
            sb.append(pluginConfig.toXml(extraOffset + "   "));
        }
        enumer = this.pluginConfigsNodes.keys();
        while (enumer.hasMoreElements()) {
            String nodeId = (String)enumer.nextElement();
            Hashtable nodeTable = (Hashtable)this.pluginConfigsNodes.get(nodeId);
            sb.append(offset).append("   ").append("<node id='").append(nodeId).append("'>");
            Enumeration enumNodes = nodeTable.keys();
            while (enumNodes.hasMoreElements()) {
                String key = (String)enumNodes.nextElement();
                PluginConfig pluginConfig = (PluginConfig)nodeTable.get(key);
                sb.append(pluginConfig.toXml(extraOffset + "      "));
            }
            sb.append(offset).append("   ").append("</node>");
        }
        sb.append(offset).append("</xmlBlaster>");
        return sb.toString();
    }

    public String toXml() {
        return this.toXml("");
    }

    public TreeSet getStartupSequence(String nodeId, int lowRunlevel, int highRunlevel) {
        if (this.log.CALL) {
            this.log.call(this.ME, "getStartupSequence for node '" + nodeId + "' and runlevel '" + lowRunlevel + "' to '" + highRunlevel + "'");
        }
        if (lowRunlevel > highRunlevel) {
            this.log.error(this.ME, ".getStartupSequence: the low run level '" + lowRunlevel + "' is higher than the high run level '" + highRunlevel + "'");
        }
        TreeSet<PluginConfig> startupSet = new TreeSet<PluginConfig>(new PluginConfigComparator(this.glob, true));
        PluginConfig[] plugins = this.getAllPluginConfig(nodeId);
        int i = 0;
        while (i < plugins.length) {
            int runlevel;
            RunLevelAction action = plugins[i].getUpAction();
            if (action != null && (runlevel = action.getOnStartupRunlevel()) >= lowRunlevel && runlevel <= highRunlevel) {
                startupSet.add(plugins[i]);
            }
            ++i;
        }
        return startupSet;
    }

    public TreeSet getShutdownSequence(String nodeId, int lowRunlevel, int highRunlevel) {
        if (this.log.CALL) {
            this.log.call(this.ME, "getShutdownSequence for node '" + nodeId + "' and runlevel '" + lowRunlevel + "' to '" + highRunlevel + "'");
        }
        if (lowRunlevel > highRunlevel) {
            this.log.error(this.ME, ".getShutdownSequence: the low run level '" + lowRunlevel + "' is higher than the high run level '" + highRunlevel + "'");
        }
        TreeSet<PluginConfig> shutdownSet = new TreeSet<PluginConfig>(new PluginConfigComparator(this.glob, false));
        PluginConfig[] plugins = this.getAllPluginConfig(nodeId);
        int i = 0;
        while (i < plugins.length) {
            int runlevel;
            RunLevelAction action = plugins[i].getDownAction();
            if (action != null && (runlevel = action.getOnShutdownRunlevel()) >= lowRunlevel && runlevel <= highRunlevel) {
                shutdownSet.add(plugins[i]);
            }
            ++i;
        }
        return shutdownSet;
    }
}

