/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.runlevel;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xmlBlaster.engine.runlevel.PluginConfigSaxFactory;
import org.xmlBlaster.engine.runlevel.PluginHolder;
import org.xmlBlaster.util.FileLocator;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SaxHandlerBase;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class PluginHolderSaxFactory
extends SaxHandlerBase {
    private String ME = "PluginHolderSaxFactory";
    private final Global glob;
    private final LogChannel log;
    private PluginHolder pluginHolder;
    private XmlBlasterException ex;
    private PluginConfigSaxFactory pluginFactory;
    private boolean inPlugin = false;
    private boolean isXmlBlaster = false;
    private String currentNode;

    public PluginHolderSaxFactory(Global glob) {
        super(glob);
        this.setUseLexicalHandler(true);
        this.glob = glob;
        this.log = glob.getLog("runlevel");
        this.pluginFactory = new PluginConfigSaxFactory(this.glob);
    }

    public void reset() {
        this.ex = null;
        this.pluginHolder = new PluginHolder(this.glob);
        this.inPlugin = false;
        this.currentNode = null;
        this.isXmlBlaster = false;
    }

    public PluginHolder getObject() {
        return this.pluginHolder;
    }

    public synchronized PluginHolder readObject(String xmlTxt) throws XmlBlasterException {
        if (xmlTxt == null || xmlTxt.trim().length() < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "the <xmlBlaster> element is empty");
        }
        this.reset();
        try {
            this.init(xmlTxt);
        }
        catch (Throwable thr) {
            if (this.log.TRACE) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "exception occured when parsing the <xmlBlaster> tag. In fact it was '" + xmlTxt + "'", thr);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "exception occured when parsing the <xmlBlaster> tag. In fact it was '" + xmlTxt + "'");
        }
        if (this.ex != null) {
            throw this.ex;
        }
        if (!this.isXmlBlaster) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "the string '" + xmlTxt + "' does not contain the <xmlBlaster> tag");
        }
        return this.pluginHolder;
    }

    public final void startElement(String uri, String localName, String name, Attributes attrs) {
        if (this.ex != null) {
            return;
        }
        if ("plugin".equalsIgnoreCase(name)) {
            this.inPlugin = true;
            this.pluginFactory.reset();
        }
        if (this.inPlugin) {
            this.pluginFactory.startElement(uri, localName, name, attrs);
            return;
        }
        if ("node".equalsIgnoreCase(name)) {
            String id = null;
            if (attrs != null) {
                id = attrs.getValue("id");
            }
            if (id == null || id.length() < 1) {
                this.ex = new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".startElement", "in the <node> tag the 'id' attribute is mandatory:found none");
            }
            this.currentNode = id;
            return;
        }
        if ("xmlBlaster".equalsIgnoreCase(name)) {
            this.isXmlBlaster = true;
            return;
        }
        this.log.warn(this.ME, "startElement: unknown tag '" + name + "'");
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inPlugin) {
            this.pluginFactory.characters(ch, start, length);
        }
    }

    public void startCDATA() {
        if (this.inPlugin) {
            this.pluginFactory.startCDATA();
        }
    }

    public void endElement(String uri, String localName, String name) {
        if (this.ex != null) {
            return;
        }
        if (this.inPlugin) {
            this.pluginFactory.endElement(uri, localName, name);
            if ("plugin".equalsIgnoreCase(name)) {
                if (this.currentNode != null) {
                    this.pluginHolder.addPluginConfig(this.currentNode, this.pluginFactory.getObject());
                } else {
                    this.pluginHolder.addDefaultPluginConfig(this.pluginFactory.getObject());
                }
                this.inPlugin = false;
            }
            return;
        }
        if ("node".equalsIgnoreCase(name)) {
            this.currentNode = null;
            return;
        }
    }

    public final String writeObject(PluginHolder pluginConfig, String extraOffset) {
        return pluginConfig.toXml(extraOffset);
    }

    public String getName() {
        return "PluginHolderSaxFactory";
    }

    public PluginHolder readConfigFile() throws XmlBlasterException {
        FileLocator fileLocator;
        URL url;
        if (this.log.CALL) {
            this.log.call(this.ME, "readConfigFile");
        }
        if ((url = (fileLocator = new FileLocator(this.glob)).findFileInXmlBlasterSearchPath("pluginsFile", "xmlBlasterPlugins.xml")) == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readConfigFile", "the file 'xmlBlasterPlugins.xml' has not been found in the search path nor in the property 'pluginsFile'");
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "readConfigFile: the file is '" + url.getFile() + "'");
        }
        try {
            InputStream fis = url.openStream();
            InputSource inSource = new InputSource(fis);
            this.reset();
            this.init(url.toString(), inSource);
            PluginHolder ret = this.getObject();
            if (this.log.DUMP) {
                this.log.dump(this.ME, ".readConfigFile. The content: \n" + ret.toXml());
            }
            return ret;
        }
        catch (IOException ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readConfigFile", "the file '" + url.getFile() + "' has not been found", ex);
        }
    }

    public static void main(String[] args) {
        Global glob = Global.instance();
        glob.init(args);
        LogChannel log = glob.getLog("main");
        try {
            PluginHolderSaxFactory factory = new PluginHolderSaxFactory(glob);
            PluginHolder holder = factory.readConfigFile();
            log.info("main", holder.toXml());
        }
        catch (XmlBlasterException ex) {
            log.error("main", ex.getMessage());
        }
    }
}

