/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.runlevel;

import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.def.ErrorCode;

public class RunLevelAction {
    public static final String LOAD = "LOAD";
    public static final String STOP = "STOP";
    private String ME = "RunLevelAction";
    private final Global glob;
    private final LogChannel log;
    private String action;
    private int upLevel = -1;
    private int downLevel = -1;
    private ErrorCode errorCode;
    private int sequence = 0;

    public RunLevelAction(Global glob, String action, int upLevel, int downLevel, ErrorCode errorCode, int sequence) {
        this.log = glob.getLog("runlevel");
        if (this.log.CALL) {
            this.log.call(this.ME, "constructor");
        }
        this.glob = glob;
        this.action = action;
        this.upLevel = upLevel;
        this.downLevel = downLevel;
        this.errorCode = errorCode;
        this.sequence = sequence;
    }

    public RunLevelAction(Global glob) {
        this(glob, LOAD, -1, -1, null, 0);
    }

    public Object clone() {
        return new RunLevelAction(this.glob, this.action, this.upLevel, this.downLevel, this.errorCode, this.sequence);
    }

    public String getDo() {
        return this.action;
    }

    public void setDo(String action) {
        this.action = action;
    }

    public int getOnStartupRunlevel() {
        return this.upLevel;
    }

    public void setOnStartupRunlevel(int upLevel) {
        this.upLevel = upLevel;
    }

    public boolean isOnStartupRunlevel() {
        return this.upLevel > 0;
    }

    public int getOnShutdownRunlevel() {
        return this.downLevel;
    }

    public void setOnShutdownRunlevel(int downLevel) {
        this.downLevel = downLevel;
    }

    public boolean isOnShutdownRunlevel() {
        return this.downLevel > 0;
    }

    public ErrorCode getOnFail() {
        return this.errorCode;
    }

    public void setOnFail(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public boolean hasOnFail() {
        return this.errorCode != null;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(512);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<action ");
        sb.append("do='").append(this.action).append("' ");
        if (this.upLevel > -1) {
            sb.append("onStartupRunlevel='").append(this.upLevel).append("' ");
        }
        if (this.downLevel > -1) {
            sb.append("onShutdownRunlevel='").append(this.downLevel).append("' ");
        }
        if (this.errorCode != null) {
            sb.append("onFail='").append(this.errorCode.getErrorCode()).append("' ");
        }
        if (this.sequence > 0) {
            sb.append("sequence='").append(this.sequence).append("' ");
        }
        sb.append("/>");
        return sb.toString();
    }

    public String toXml() {
        return this.toXml("");
    }
}

