/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.runlevel;

import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.engine.runlevel.RunLevelAction;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SaxHandlerBase;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class RunLevelActionSaxFactory
extends SaxHandlerBase {
    private String ME = "RunLevelActionSaxFactory";
    private final Global glob;
    private final LogChannel log;
    private RunLevelAction runLevelAction;
    private boolean isAction = false;
    private XmlBlasterException ex = null;

    public RunLevelActionSaxFactory(Global glob) {
        super(glob);
        this.setUseLexicalHandler(true);
        this.glob = glob;
        this.log = glob.getLog("runlevel");
    }

    public void reset() {
        this.isAction = false;
        this.ex = null;
        this.runLevelAction = new RunLevelAction(this.glob);
    }

    public RunLevelAction getObject() {
        return this.runLevelAction;
    }

    public synchronized RunLevelAction readObject(String xmlTxt) throws XmlBlasterException {
        if (xmlTxt == null || xmlTxt.trim().length() < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "the action element is empty");
        }
        this.reset();
        try {
            this.init(xmlTxt);
        }
        catch (Throwable thr) {
            if (this.log.TRACE) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "exception occured when parsing the <action> tag. In fact it was '" + xmlTxt + "'", thr);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "exception occured when parsing the <action> tag. In fact it was '" + xmlTxt + "'");
        }
        if (this.ex != null) {
            throw this.ex;
        }
        if (!this.isAction) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".readObject", "the string '" + xmlTxt + "' does not contain the <action> tag");
        }
        return this.runLevelAction;
    }

    public final void startElement(String uri, String localName, String name, Attributes attrs) {
        if (this.ex != null) {
            return;
        }
        if ("action".equalsIgnoreCase(name)) {
            this.isAction = true;
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    int level;
                    String key = attrs.getQName(i);
                    String value = attrs.getValue(i).trim();
                    if ("do".equalsIgnoreCase(key)) {
                        this.runLevelAction.setDo(value);
                    } else if ("onStartupRunlevel".equalsIgnoreCase(key)) {
                        try {
                            level = Integer.parseInt(value);
                            this.runLevelAction.setOnStartupRunlevel(level);
                        }
                        catch (NumberFormatException ex) {
                            this.log.warn(this.ME, "startElement onStartupRunlevel='" + value + "' is not an integer");
                        }
                    } else if ("onShutdownRunlevel".equalsIgnoreCase(key)) {
                        try {
                            level = Integer.parseInt(value);
                            this.runLevelAction.setOnShutdownRunlevel(level);
                        }
                        catch (NumberFormatException ex) {
                            this.log.warn(this.ME, "startElement onShutdownRunlevel='" + value + "' is not an integer");
                        }
                    } else if ("sequence".equalsIgnoreCase(key)) {
                        try {
                            int sequence = Integer.parseInt(value);
                            this.runLevelAction.setSequence(sequence);
                        }
                        catch (NumberFormatException ex) {
                            this.log.warn(this.ME, "startElement sequence='" + value + "' is not an integer");
                        }
                    } else if ("onFail".equalsIgnoreCase(key)) {
                        if (value.length() > 1) {
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "startElement: onFail : " + key + "='" + value + "'");
                            }
                            try {
                                ErrorCode code = ErrorCode.toErrorCode(value);
                                this.runLevelAction.setOnFail(code);
                            }
                            catch (IllegalArgumentException ex) {
                                this.log.warn(this.ME, "startElement onFail='" + value + "' is an unknown error code");
                                this.ex = new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".startElement", "check the spelling of your error code, it is unknown and probably wrongly spelled", ex);
                            }
                        }
                    } else {
                        this.log.warn(this.ME, "startElement: unknown attribute '" + key + "' with value '" + value + "' used");
                    }
                    ++i;
                }
            }
            return;
        }
        this.log.warn(this.ME, "startElement: unknown tag '" + name + "'");
    }

    public void endElement(String uri, String localName, String name) {
    }

    public final String writeObject(RunLevelAction runLevelAction, String extraOffset) {
        return runLevelAction.toXml(extraOffset);
    }

    public String getName() {
        return "RunLevelActionSaxFactory";
    }
}

