/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.runlevel;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jutils.log.LogChannel;
import org.jutils.time.TimeHelper;
import org.xmlBlaster.authentication.Authenticate;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.runlevel.I_RunlevelListener;
import org.xmlBlaster.engine.runlevel.PluginConfig;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;

public final class RunlevelManager {
    private String ME = "RunlevelManager";
    private final Global glob;
    private final LogChannel log;
    private int currRunlevel = 0;
    public static final int RUNLEVEL_HALTED_PRE = -1;
    public static final int RUNLEVEL_HALTED = 0;
    public static final int RUNLEVEL_HALTED_POST = 1;
    public static final int RUNLEVEL_STANDBY_PRE = 2;
    public static final int RUNLEVEL_STANDBY = 3;
    public static final int RUNLEVEL_STANDBY_POST = 4;
    public static final int RUNLEVEL_CLEANUP_PRE = 5;
    public static final int RUNLEVEL_CLEANUP = 6;
    public static final int RUNLEVEL_CLEANUP_POST = 7;
    public static final int RUNLEVEL_RUNNING_PRE = 8;
    public static final int RUNLEVEL_RUNNING = 9;
    public static final int RUNLEVEL_RUNNING_POST = 10;
    private final I_RunlevelListener[] DUMMY_ARR = new I_RunlevelListener[0];
    private final Set runlevelListenerSet = Collections.synchronizedSet(new HashSet());

    public RunlevelManager(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("runlevel");
        this.ME = "RunlevelManager" + this.glob.getLogPrefixDashed();
        if (this.log.CALL) {
            this.log.call(this.ME, "Incarnated run level manager");
        }
    }

    public void setId(String id) {
        this.ME = "RunlevelManager" + this.glob.getLogPrefixDashed();
    }

    public void initPluginManagers() throws XmlBlasterException {
        new Authenticate(this.glob);
        if (this.log.CALL) {
            this.log.call(this.ME, "Initialized run level manager");
        }
    }

    public void addRunlevelListener(I_RunlevelListener l) {
        if (l == null) {
            return;
        }
        Set set = this.runlevelListenerSet;
        synchronized (set) {
            this.runlevelListenerSet.add(l);
        }
    }

    public void removeRunlevelListener(I_RunlevelListener l) {
        if (l == null) {
            return;
        }
        Set set = this.runlevelListenerSet;
        synchronized (set) {
            this.runlevelListenerSet.remove(l);
        }
    }

    public final int changeRunlevel(String newRunlevel, boolean force) throws XmlBlasterException {
        if (newRunlevel == null || newRunlevel.length() < 1) {
            String text = "Runlevel " + newRunlevel + " is not allowed, please choose one of " + 0 + "|" + 3 + "|" + 6 + "|" + 9;
            if (this.log.TRACE) {
                this.log.trace(this.ME, text);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, text);
        }
        int level = 0;
        try {
            level = Integer.parseInt(newRunlevel.trim());
            return this.glob.getRunlevelManager().changeRunlevel(level, true);
        }
        catch (NumberFormatException e) {
            level = RunlevelManager.toRunlevelInt(newRunlevel);
            return this.glob.getRunlevelManager().changeRunlevel(level, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int changeRunlevel(int newRunlevel, boolean force) throws XmlBlasterException {
        int numErrors;
        block21: {
            if (this.log.CALL) {
                this.log.call(this.ME, "Changing from run level " + this.currRunlevel + " to run level " + newRunlevel + " with force=" + force);
            }
            long start = System.currentTimeMillis();
            numErrors = 0;
            if (this.currRunlevel == newRunlevel) {
                return numErrors;
            }
            int from = this.currRunlevel;
            int to = newRunlevel;
            this.log.info(this.ME, "Change request from run level " + RunlevelManager.toRunlevelStr(from) + " to run level " + RunlevelManager.toRunlevelStr(to) + " ...");
            if (!RunlevelManager.isMajorLevel(to)) {
                String text = "Runlevel " + to + " is not allowed, please choose one of " + 0 + "|" + 3 + "|" + 6 + "|" + 9;
                if (!this.log.TRACE) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, text);
                this.log.trace(this.ME, text);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, text);
            }
            if (from < to) {
                int ii = from;
                while (true) {
                    block22: {
                        long elapsed;
                        Object var11_12;
                        if (ii >= to) {
                            if (to == 9) {
                                this.fireRunlevelEvent(9, 10, force);
                            }
                            break block21;
                        }
                        int dest = ii + 1;
                        try {
                            this.startupPlugins(ii, dest);
                            this.fireRunlevelEvent(ii, dest, force);
                            var11_12 = null;
                            this.currRunlevel = dest;
                            if (dest <= from) break block22;
                        }
                        catch (Throwable throwable) {
                            var11_12 = null;
                            this.currRunlevel = dest;
                            if (dest <= from) throw throwable;
                            if (!RunlevelManager.isMajorLevel(dest)) throw throwable;
                            elapsed = System.currentTimeMillis() - start;
                            if (numErrors == 0) {
                                this.log.info(this.ME, "Successful startup to run level " + RunlevelManager.toRunlevelStr(dest) + TimeHelper.millisToNice(elapsed));
                                throw throwable;
                            }
                            this.log.info(this.ME, "Startup to run level " + RunlevelManager.toRunlevelStr(dest) + " done with " + numErrors + " errors.");
                            throw throwable;
                        }
                        if (RunlevelManager.isMajorLevel(dest)) {
                            elapsed = System.currentTimeMillis() - start;
                            if (numErrors == 0) {
                                this.log.info(this.ME, "Successful startup to run level " + RunlevelManager.toRunlevelStr(dest) + TimeHelper.millisToNice(elapsed));
                            } else {
                                this.log.info(this.ME, "Startup to run level " + RunlevelManager.toRunlevelStr(dest) + " done with " + numErrors + " errors.");
                            }
                        }
                    }
                    ++ii;
                }
            }
            if (from > to) {
                int ii = from;
                while (ii > to) {
                    block23: {
                        long elapsed;
                        Object var15_16;
                        int dest = ii - 1;
                        try {
                            this.shutdownPlugins(ii, dest);
                            this.fireRunlevelEvent(ii, dest, force);
                            var15_16 = null;
                            this.currRunlevel = dest;
                            if (dest >= from) break block23;
                        }
                        catch (Throwable throwable) {
                            var15_16 = null;
                            this.currRunlevel = dest;
                            if (dest >= from) throw throwable;
                            if (!RunlevelManager.isMajorLevel(dest)) throw throwable;
                            elapsed = System.currentTimeMillis() - start;
                            if (numErrors == 0) {
                                this.log.info(this.ME, "Successful shutdown to run level=" + RunlevelManager.toRunlevelStr(dest) + TimeHelper.millisToNice(elapsed));
                                throw throwable;
                            }
                            this.log.info(this.ME, "Shutdown to run level=" + RunlevelManager.toRunlevelStr(dest) + " done with " + numErrors + " errors.");
                            throw throwable;
                        }
                        if (RunlevelManager.isMajorLevel(dest)) {
                            elapsed = System.currentTimeMillis() - start;
                            if (numErrors == 0) {
                                this.log.info(this.ME, "Successful shutdown to run level=" + RunlevelManager.toRunlevelStr(dest) + TimeHelper.millisToNice(elapsed));
                            } else {
                                this.log.info(this.ME, "Shutdown to run level=" + RunlevelManager.toRunlevelStr(dest) + " done with " + numErrors + " errors.");
                            }
                        }
                    }
                    --ii;
                }
            }
        }
        if (!this.log.CALL) return numErrors;
        this.log.call(this.ME, "Leaving changeRunlevel with runlevel = " + RunlevelManager.toRunlevelStr(this.currRunlevel));
        return numErrors;
    }

    private void startupPlugins(int from, int to) throws XmlBlasterException {
        TreeSet pluginSet = this.glob.getPluginHolder().getStartupSequence(this.glob.getStrippedId(), from + 1, to);
        if (this.log.CALL) {
            this.log.call(this.ME, "startupPlugins. the size of the plugin set is '" + pluginSet.size() + "'");
        }
        Iterator iter = pluginSet.iterator();
        while (iter.hasNext()) {
            PluginConfig pluginConfig = (PluginConfig)iter.next();
            if (pluginConfig == null) {
                this.log.warn(this.ME, "startupPlugins. the pluginConfig object is null");
            } else if (this.log.DUMP) {
                this.log.dump(this.ME, "startupPlugins " + pluginConfig.toXml());
            }
            try {
                PluginInfo pluginInfo = pluginConfig.getPluginInfo();
                if (this.log.CALL) {
                    if (pluginInfo != null) {
                        this.log.call(this.ME, "startupPlugins pluginInfo object: " + pluginInfo.getId() + " classname: " + pluginInfo.getClassName());
                    } else {
                        this.log.call(this.ME, "startupPlugins: the pluginInfo is null");
                    }
                }
                this.glob.getPluginManager().getPluginObject(pluginInfo);
                this.log.info(this.ME, "startupPlugins: run level '" + from + "' to '" + to + "' plugin '" + pluginConfig.getId() + "' successful loaded");
            }
            catch (Throwable ex) {
                ErrorCode code = pluginConfig.getUpAction().getOnFail();
                if (code == null) {
                    this.log.warn(this.ME, "startupPlugins. Exception when loading the plugin '" + pluginConfig.getId() + "' reason: " + ex.toString());
                    Thread.dumpStack();
                    continue;
                }
                throw new XmlBlasterException(this.glob, code, this.ME + ".startupPlugins", "Can't load plugin '" + pluginConfig.getId() + "'", ex);
            }
        }
    }

    private void shutdownPlugins(int from, int to) throws XmlBlasterException {
        TreeSet pluginSet = this.glob.getPluginHolder().getShutdownSequence(this.glob.getStrippedId(), to, from - 1);
        Iterator iter = pluginSet.iterator();
        while (iter.hasNext()) {
            PluginConfig pluginConfig = (PluginConfig)iter.next();
            try {
                PluginInfo pluginInfo = pluginConfig.getPluginInfo();
                I_Plugin plugin = this.glob.getPluginManager().getPluginObject(pluginInfo);
                plugin.shutdown();
                this.glob.getPluginManager().removeFromPluginCache(pluginInfo.getId());
                this.log.info(this.ME, "fireRunlevelEvent: run level '" + from + "' to '" + to + "' plugin '" + pluginConfig.getId() + "' shutdown");
            }
            catch (Throwable ex) {
                ErrorCode code = pluginConfig.getDownAction().getOnFail();
                if (code == null) {
                    this.log.warn(this.ME, ".fireRunlevelEvent. Exception when shutting down the plugin '" + pluginConfig.getId() + "' reason: " + ex.toString());
                    continue;
                }
                throw new XmlBlasterException(this.glob, code, this.ME + ".fireRunlevelEvent", ".fireRunlevelEvent. Exception when shutting down the plugin '" + pluginConfig.getId() + "'", ex);
            }
        }
    }

    private final int fireRunlevelEvent(int from, int to, boolean force) throws XmlBlasterException {
        I_RunlevelListener[] listeners;
        int numErrors = 0;
        Set set = this.runlevelListenerSet;
        synchronized (set) {
            if (this.runlevelListenerSet.size() == 0) {
                int n = numErrors;
                return n;
            }
            listeners = this.runlevelListenerSet.toArray(this.DUMMY_ARR);
        }
        int ii = 0;
        while (ii < listeners.length) {
            I_RunlevelListener li = listeners[ii];
            try {
                li.runlevelChange(from, to, force);
                if (this.log.TRACE && RunlevelManager.isMajorLevel(to)) {
                    if (from < to) {
                        this.log.trace(this.ME, li.getName() + " successful startup to run level=" + to + ", errors=" + numErrors + ".");
                    } else {
                        this.log.trace(this.ME, li.getName() + " successful shutdown to run level=" + to + ", errors=" + numErrors + ".");
                    }
                }
            }
            catch (XmlBlasterException e) {
                this.log.warn(this.ME, "Changing from run level=" + from + " to level=" + to + " failed for component " + li.getName() + ": " + e.toString());
                ++numErrors;
            }
            ++ii;
        }
        return numErrors;
    }

    public final int getCurrentRunlevel() {
        return this.currRunlevel;
    }

    public boolean isHalted() {
        return this.currRunlevel <= 0;
    }

    public boolean isStandby() {
        return this.currRunlevel == 3;
    }

    public boolean isCleanup() {
        return this.currRunlevel == 6;
    }

    public boolean isRunning() {
        return this.currRunlevel == 9;
    }

    public boolean isMajorLevel() {
        return RunlevelManager.isMajorLevel(this.currRunlevel);
    }

    private static final boolean isMajorLevel(int level) {
        return level == 0 || level == 3 || level == 6 || level == 9;
    }

    public static final boolean checkRunlevel(int level) {
        return RunlevelManager.isMajorLevel(level);
    }

    public static final String toRunlevelStr(int level) {
        if (level == -1) {
            return "HALTED_PRE";
        }
        if (level == 0) {
            return "HALTED";
        }
        if (level == 1) {
            return "HALTED_POST";
        }
        if (level == 2) {
            return "STANDBY_PRE";
        }
        if (level == 3) {
            return "STANDBY";
        }
        if (level == 4) {
            return "STANDBY_POST";
        }
        if (level == 5) {
            return "CLEANUP_PRE";
        }
        if (level == 6) {
            return "CLEANUP";
        }
        if (level == 7) {
            return "CLEANUP_POST";
        }
        if (level == 8) {
            return "RUNNING_PRE";
        }
        if (level == 9) {
            return "RUNNING";
        }
        if (level == 10) {
            return "RUNNING_POST";
        }
        return "RUNLEVEL_UNKNOWN(" + level + ")";
    }

    public static final int toRunlevelInt(String level) {
        if (level.equalsIgnoreCase("HALTED_PRE")) {
            return -1;
        }
        return -10;
    }
}

