/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.xml2java;

import com.fujitsu.xml.omquery.DomQueryMgr;
import java.util.Enumeration;
import org.jutils.log.LogChannel;
import org.jutils.text.StringHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.util.I_MergeDomNode;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlToDom;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.KeyData;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.key.QueryKeyData;

public final class XmlKey {
    private String ME = "XmlKey";
    private Global glob;
    private LogChannel log;
    private XmlToDom xmlToDom = null;
    public final int XML_TYPE = 0;
    public final int ASCII_TYPE = 1;
    private int keyType = 0;
    protected KeyData keyData;
    private Document xmlKeyDoc = null;
    private DomQueryMgr queryMgr = null;

    public XmlKey(Global glob, KeyData keyData) {
        this.glob = glob;
        this.log = glob.getLog("core");
        this.keyData = keyData;
    }

    public XmlKey(Global glob, String xmlKey_literal) throws XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("core");
        xmlKey_literal = xmlKey_literal.trim();
        if (!xmlKey_literal.startsWith("<")) {
            this.keyType = 1;
            this.keyData = new MsgKeyData(glob);
            this.keyData.setOid(xmlKey_literal);
            this.log.warn(this.ME + ".XML", "Invalid XmlKey syntax, only XML syntax beginning with \"<\" is supported: '" + xmlKey_literal + "'");
            Thread.currentThread();
            Thread.dumpStack();
            throw new XmlBlasterException(this.ME + ".XML", "Invalid XmlKey syntax, only XML syntax beginning with \"<\" is supported");
        }
        this.keyData = glob.getMsgKeyFactory().readObject(xmlKey_literal);
    }

    public KeyData getKeyData() {
        return this.keyData;
    }

    public final boolean isDeadMessage() throws XmlBlasterException {
        return this.keyData.isDeadMessage();
    }

    public final String toString() {
        return this.toXml();
    }

    public String toXml() {
        this.log.warn(this.ME, "Accessing raw xml key string");
        Thread.currentThread();
        Thread.dumpStack();
        return this.keyData.toXml();
    }

    public final String literal() {
        return this.keyData.toXml();
    }

    public final String getUniqueKey() {
        return this.keyData.getOid();
    }

    public final String getKeyOid() {
        return this.keyData.getOid();
    }

    public final String getOid() {
        return this.keyData.getOid();
    }

    public final boolean isGeneratedOid() {
        return this.keyData.isGeneratedOid();
    }

    public final String getContentMime() {
        return this.keyData.getContentMime();
    }

    public final String getContentMimeExtended() {
        return this.keyData.getContentMimeExtended();
    }

    public final String getDomain() {
        return this.keyData.getDomain();
    }

    public final boolean isDefaultDomain() {
        return this.keyData.isDefaultDomain();
    }

    public final boolean isPluginInternal() {
        return this.keyData.isPluginInternal();
    }

    public final boolean isInternal() {
        return this.keyData.isInternal();
    }

    public final boolean isAdministrative() {
        return this.keyData.isAdministrative();
    }

    public Node getRootNode() throws XmlBlasterException {
        this.loadDomTree();
        return this.xmlToDom.getRootNode();
    }

    public Document getXmlDoc() throws XmlBlasterException {
        this.loadDomTree();
        return this.xmlToDom.getXmlDoc();
    }

    private synchronized void loadDomTree() throws XmlBlasterException {
        if (this.xmlToDom != null) {
            return;
        }
        if (this.keyType == 1) {
            return;
        }
        this.xmlToDom = new XmlToDom(this.glob, this.keyData.toXml());
        Node node = this.xmlToDom.getRootNode();
        if (node == null) {
            this.log.error(this.ME + ".Internal", "root node = null");
            throw new XmlBlasterException(this.ME + "Internal", "root node = null");
        }
        String nodeName = node.getNodeName();
        if (!nodeName.equalsIgnoreCase("key")) {
            this.log.error(this.ME + ".WrongRootNode", "The root node must be named \"key\"\n" + this.keyData.toXml());
            throw new XmlBlasterException(this.ME + ".WrongRootNode", "The root node must be named \"key\"\n" + this.keyData.toXml());
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && attributes.getLength() > 0) {
            int attributeCount = attributes.getLength();
            int i = 0;
            while (i < attributeCount) {
                Attr attribute = (Attr)attributes.item(i);
                if (attribute.getNodeName().equalsIgnoreCase("oid")) {
                    attribute.setNodeValue(this.getOid());
                } else if (attribute.getNodeName().equalsIgnoreCase("contentMime")) {
                    attribute.setNodeValue(this.getContentMime());
                } else if (attribute.getNodeName().equalsIgnoreCase("contentMimeExtended")) {
                    attribute.setNodeValue(this.getContentMimeExtended());
                } else if (attribute.getNodeName().equalsIgnoreCase("domain")) {
                    attribute.setNodeValue(this.getDomain());
                }
                ++i;
            }
        }
        this.log.info(this.ME, "DOM parsed the XmlKey " + this.getOid());
    }

    public final void mergeRootNode(I_MergeDomNode merger) throws XmlBlasterException {
        this.loadDomTree();
        this.xmlToDom.mergeRootNode(merger);
    }

    public final boolean match(QueryKeyData queryKey) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "DEBUG ONLY Trying query=" + queryKey.toXml() + "\non key=" + this.literal());
        }
        if (queryKey.isDomain()) {
            if (queryKey.getDomain() == null) {
                this.log.warn(this.ME, "Your query is of type DOMAIN but you have not specified a domain: " + queryKey.toXml());
                throw new XmlBlasterException(this.glob, ErrorCode.USER_QUERY_INVALID, this.ME, "Your query is of type DOMAIN but you have not specified a domain: " + queryKey.toXml());
            }
            if (queryKey.getDomain().equals("*") || queryKey.getDomain().equals(this.getDomain())) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Message oid='" + this.getOid() + "' matched for domain='" + this.getDomain() + "'.");
                }
                return true;
            }
        } else if (queryKey.isExact()) {
            if (queryKey.getOid().equals(this.getOid())) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Message oid='" + this.getOid() + "' matched.");
                }
                return true;
            }
        } else if (queryKey.isXPath()) {
            if (this.match(queryKey.getQueryString())) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Message oid='" + this.getOid() + "' matched with XPath query '" + queryKey.getQueryString() + "'");
                }
                return true;
            }
        } else {
            this.log.error(this.ME, "Don't know queryType '" + queryKey.getQueryType() + "' for message oid='" + this.getOid() + "'. I'll return false for match.");
            return false;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Message oid='" + this.getOid() + "' does not match with query");
        }
        return false;
    }

    public final boolean match(String xpath) throws XmlBlasterException {
        String xmlKey_literal = this.keyData.toXml();
        if (this.xmlKeyDoc == null) {
            try {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Creating tiny DOM tree and a query manager ...");
                }
                String tmp = StringHelper.replaceFirst(xmlKey_literal, "<key", "<xmlBlaster><key") + "</xmlBlaster>";
                XmlToDom tinyDomHandle = new XmlToDom(this.glob, tmp);
                this.xmlKeyDoc = tinyDomHandle.getXmlDoc();
                this.queryMgr = new DomQueryMgr(this.xmlKeyDoc);
            }
            catch (Exception e) {
                String text = "Problems building tiny key DOM tree\n" + xmlKey_literal + "\n for XPath subscriptions check: " + e.getMessage();
                this.log.warn(this.ME + ".MergeNodeError", text);
                throw new XmlBlasterException(this.glob, ErrorCode.USER_QUERY_INVALID, this.ME, text, e);
            }
        }
        try {
            Enumeration nodeIter = this.queryMgr.getNodesByXPath(this.xmlKeyDoc, xpath);
            if (nodeIter != null && nodeIter.hasMoreElements()) {
                this.log.info(this.ME, "XPath subscription '" + xpath + "' matches message '" + this.getKeyOid() + "'");
                return true;
            }
        }
        catch (Exception e) {
            this.log.warn(this.ME + ".XPathError", "XPath query '" + xpath + "' on tiny key DOM tree" + xmlKey_literal + "failed: " + e.getMessage());
            throw new XmlBlasterException(this.glob, ErrorCode.USER_QUERY_INVALID, this.ME, "XPath query '" + xpath + "' on tiny key DOM tree" + xmlKey_literal + "failed", e);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "XPath subscription '" + xpath + "' does NOT match message '" + this.getKeyOid() + "'");
        }
        return false;
    }

    public void cleanupMatch() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Releasing tiny DOM tree");
        }
        this.queryMgr = null;
        this.xmlKeyDoc = null;
    }

    public static void main(String[] args) {
        Global global = new Global(args);
    }
}

