/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.xml2java;

import com.fujitsu.xml.omquery.DomQueryMgr;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jutils.log.LogChannel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.RequestBroker;
import org.xmlBlaster.util.I_MergeDomNode;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlNotPortable;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.qos.QueryQosData;

public class XmlKeyDom
implements I_MergeDomNode {
    private static final String ME = "XmlKeyDom";
    private final Global glob;
    private final LogChannel log;
    protected DomQueryMgr queryMgr = null;
    protected Document xmlKeyDoc = null;
    protected String encoding = "ISO-8859-1";
    protected final RequestBroker requestBroker;

    protected XmlKeyDom(RequestBroker requestBroker) throws XmlBlasterException {
        this.requestBroker = requestBroker;
        this.glob = this.requestBroker.getGlobal();
        this.log = this.glob.getLog("core");
        String xml = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<xmlBlaster></xmlBlaster>";
        StringReader reader = new StringReader(xml);
        InputSource input = new InputSource(reader);
        try {
            DocumentBuilderFactory dbf = requestBroker.getGlobal().getDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.xmlKeyDoc = db.parse(input);
        }
        catch (Exception e) {
            this.log.error("XmlKeyDom.IO", "Problems when building DOM tree from your XmlKey: " + e.toString());
            throw new XmlBlasterException(ME, "Problems when building DOM tree from your XmlKey: " + e.toString());
        }
    }

    protected final DomQueryMgr getQueryMgr() {
        if (this.queryMgr == null) {
            this.queryMgr = new DomQueryMgr(this.xmlKeyDoc);
        }
        return this.queryMgr;
    }

    public final Node mergeNode(Node node) throws XmlBlasterException {
        XmlNotPortable.mergeNode(this.xmlKeyDoc, node);
        this.queryMgr = null;
        return node;
    }

    public final ArrayList parseKeyOid(SessionInfo sessionInfo, String xpathQuery, QueryQosData qos) throws XmlBlasterException {
        Enumeration nodeIter;
        ArrayList<String> list = new ArrayList<String>();
        String clientName = sessionInfo.toString();
        if (xpathQuery == null || xpathQuery.length() < 1) {
            this.log.warn("XmlKeyDom.InvalidQuery", "Sorry, can't access message, you supplied an empty XPATH query '" + xpathQuery + "', please check your query string");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_QUERY_INVALID, ME, "Sorry, can't access message, you supplied an empty XPATH query '" + xpathQuery + "', please check your query string");
        }
        try {
            if (this.log.TRACE) {
                this.log.trace(ME, "Goin' to query DOM tree with XPATH = " + xpathQuery);
            }
            nodeIter = this.getQueryMgr().getNodesByXPath(this.xmlKeyDoc, xpathQuery);
        }
        catch (Exception e) {
            this.log.warn("XmlKeyDom.InvalidQuery", "Sorry, can't access, query syntax is wrong for '" + xpathQuery + "' : " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.USER_QUERY_INVALID, ME, "Sorry, can't access, query syntax of '" + xpathQuery + "' is wrong", e);
        }
        int n = 0;
        boolean wantsAll = false;
        while (nodeIter.hasMoreElements()) {
            ++n;
            Object obj = nodeIter.nextElement();
            if (obj instanceof Document) {
                if (this.log.TRACE) {
                    this.log.trace(ME, "Query on document root " + obj.toString());
                }
                wantsAll = true;
                break;
            }
            Element node = (Element)obj;
            if ("xmlBlaster".equals(node.getNodeName())) {
                if (this.log.TRACE) {
                    this.log.trace(ME, "Query on root node " + obj.toString());
                }
                wantsAll = true;
                break;
            }
            try {
                String uniqueKey = this.getKeyOid(node);
                if (this.log.TRACE) {
                    this.log.trace(ME, "Client " + clientName + " is accessing message oid='" + uniqueKey + "' after successful query");
                }
                list.add(uniqueKey);
            }
            catch (XmlBlasterException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error(ME, e.getMessage());
                XmlBlasterException.convert(this.glob, ME, "XPath DOM lookup problems", e);
            }
        }
        if (this.log.TRACE) {
            this.log.info(ME, n + " MsgUnits matched to subscription \"" + xpathQuery + "\"");
        }
        if (wantsAll) {
            list.clear();
            return this.parseKeyOid(sessionInfo, "/xmlBlaster/key", qos);
        }
        return list;
    }

    protected final String getKeyOid(Node node) throws XmlBlasterException {
        if (node == null) {
            this.log.warn("XmlKeyDom.NoParentNode", "no parent node found");
            throw new XmlBlasterException("XmlKeyDom.NoParentNode", "no parent node found");
        }
        String nodeName = node.getNodeName();
        if (this.log.TRACE) {
            this.log.trace(ME, "Checking node name=" + nodeName);
        }
        if ("xmlBlaster".equals(nodeName) && (node.getParentNode() == null || "#document".equals(node.getParentNode().getNodeName()))) {
            this.log.warn("XmlKeyDom.NodeNotAllowed", "<xmlBlaster> node not allowed");
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "<xmlBlaster> node not allowed");
        }
        boolean foundKey = false;
        if (nodeName.equalsIgnoreCase("key")) {
            Node parent = node.getParentNode();
            if (parent == null) {
                throw new XmlBlasterException("XmlKeyDom.InvalidDom", "DOM tree is invalid");
            }
            if (parent.getParentNode().getParentNode() == null) {
                foundKey = true;
            }
        }
        if (!foundKey) {
            return this.getKeyOid(node.getParentNode());
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && attributes.getLength() > 0) {
            int attributeCount = attributes.getLength();
            int i = 0;
            while (i < attributeCount) {
                Attr attribute = (Attr)attributes.item(i);
                if (attribute.getNodeName().equalsIgnoreCase("oid")) {
                    String val = attribute.getNodeValue();
                    return val;
                }
                ++i;
            }
        }
        this.log.warn("XmlKeyDom.InternalKeyOid", "Internal getKeyOid() error");
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "Internal getKeyOid() error");
    }

    public String toXml() throws XmlBlasterException {
        return this.toXml(null, false);
    }

    public String toXml(String extraOffset, boolean stripDeclaration) throws XmlBlasterException {
        StringBuffer sb = new StringBuffer(2048);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<XmlKeyDom>");
        try {
            StringTokenizer st = new StringTokenizer(XmlNotPortable.write(this.xmlKeyDoc).toString(), "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken().trim();
                if (stripDeclaration && line.startsWith("<?xml")) continue;
                sb.append(offset).append(" ").append(line);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        sb.append(offset).append("</XmlKeyDom>\n");
        return sb.toString();
    }
}

