/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.j2ee.jmx;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.j2ee.jmx.XmlBlasterServiceMBean;
import org.xmlBlaster.j2ee.util.GlobalUtil;
import org.xmlBlaster.j2ee.util.JacorbUtil;
import org.xmlBlaster.util.EmbeddedXmlBlaster;

public class XmlBlasterService
implements XmlBlasterServiceMBean {
    private static final String ME = "XmlBlasterService";
    private EmbeddedXmlBlaster blaster = null;
    private org.xmlBlaster.util.Global glob;
    private String propFile;
    private LogChannel log;
    private String jndiName;
    private Properties args = new Properties();
    private GlobalUtil globalUtil;

    public void setPropertyFileName(String fileName) {
        this.propFile = fileName;
    }

    public String getPropertyFileName() {
        return this.propFile;
    }

    public void setPort(String port) {
        this.args.setProperty("bootstrapPort", port);
    }

    public String getPort() {
        return this.args.getProperty("bootstrapPort");
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void start() throws Exception {
        this.globalUtil = new GlobalUtil();
        this.glob = this.globalUtil.newGlobal(this.propFile, this.args);
        this.loadJacorbProperties();
        this.globalUtil.setupSecurityManager(this.glob);
        this.log = this.glob.getLog(ME);
        this.log.info(ME, "Starting XmlBlasterService");
        this.blaster = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        if (this.jndiName != null) {
            this.bind(this.blaster.getMain().getGlobal());
        }
    }

    public void stop() throws Exception {
        this.log.info(ME, "Stopping XmlBlaster service");
        if (this.blaster != null) {
            EmbeddedXmlBlaster.stopXmlBlaster(this.blaster);
        }
        if (this.jndiName != null) {
            new InitialContext().unbind(this.jndiName);
        }
    }

    public String dumpProperties() {
        if (this.glob == null) {
            return "";
        }
        return this.glob.getProperty().toXml();
    }

    private void bind(Global engineGlobal) throws Exception {
        if (this.jndiName == null) {
            return;
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            throw new IllegalStateException("No NamingContext available, trying to run with a jndiName in a server withouth jndi is not valid: " + e);
        }
        GlobalUtil gu = new GlobalUtil(engineGlobal);
        this.bind(ctx, this.jndiName, gu);
    }

    private void loadJacorbProperties() throws Exception {
        JacorbUtil.loadJacorbProperties("jacorb.properties", this.glob);
    }

    public void bind(Context ctx, String name, Object val) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        ctx.bind(n.get(0), val);
    }
}

