/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.j2ee.k2;

import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.j2ee.k2.BlasterManagedConnection;
import org.xmlBlaster.j2ee.k2.client.BlasterConnection;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class BlasterConnectionImpl
implements BlasterConnection {
    private BlasterManagedConnection mc = null;
    private boolean closed = true;

    public BlasterConnectionImpl(BlasterManagedConnection mc) {
        this.mc = mc;
        this.closed = false;
    }

    public Global getGlobal() throws XmlBlasterException {
        this.checkSanity();
        return this.mc.getGlobal();
    }

    public MsgUnit[] get(String xmlKey, String qos) throws XmlBlasterException {
        this.checkSanity();
        MsgUnit[] ret = null;
        try {
            ret = this.mc.getBlasterConnection().get(xmlKey, qos);
        }
        catch (XmlBlasterException ex) {
            try {
                ret = this.mc.getFailoverBlasterConnection().get(xmlKey, qos);
            }
            catch (XmlBlasterException exx) {
                this.mc.handleError(this, exx);
                throw exx;
            }
        }
        return ret;
    }

    public PublishReturnQos publish(MsgUnit msgUnit) throws XmlBlasterException {
        this.checkSanity();
        PublishReturnQos ret = null;
        try {
            ret = this.mc.getBlasterConnection().publish(msgUnit);
        }
        catch (XmlBlasterException ex) {
            try {
                ret = this.mc.getFailoverBlasterConnection().publish(msgUnit);
            }
            catch (XmlBlasterException exx) {
                this.mc.handleError(this, exx);
                throw exx;
            }
        }
        return ret;
    }

    public PublishReturnQos[] publishArr(MsgUnit[] msgUnitArr) throws XmlBlasterException {
        this.checkSanity();
        PublishReturnQos[] ret = null;
        try {
            ret = this.mc.getBlasterConnection().publishArr(msgUnitArr);
        }
        catch (XmlBlasterException ex) {
            try {
                ret = this.mc.getFailoverBlasterConnection().publishArr(msgUnitArr);
            }
            catch (XmlBlasterException exx) {
                this.mc.handleError(this, exx);
                throw exx;
            }
        }
        return ret;
    }

    public EraseReturnQos[] erase(String xmlKey, String qos) throws XmlBlasterException {
        this.checkSanity();
        EraseReturnQos[] ret = null;
        try {
            ret = this.mc.getBlasterConnection().erase(xmlKey, qos);
        }
        catch (XmlBlasterException ex) {
            try {
                ret = this.mc.getFailoverBlasterConnection().erase(xmlKey, qos);
            }
            catch (XmlBlasterException exx) {
                this.mc.handleError(this, exx);
                throw exx;
            }
        }
        return ret;
    }

    public void close() throws XmlBlasterException {
        if (this.mc == null) {
            throw new XmlBlasterException(null, "Connection invalid, no ManagedConnection available");
        }
        this.closed = true;
        this.mc.handleClose(this);
    }

    void open() {
        this.closed = false;
    }

    void destroy() {
        this.closed = true;
        this.mc = null;
    }

    void cleanup() {
        this.closed = true;
    }

    void setBlasterManagedConnection(BlasterManagedConnection mc) {
        if (this.mc != null) {
            this.mc.removeHandle(this);
        }
        this.mc = mc;
    }

    private void checkSanity() throws XmlBlasterException {
        if (this.mc == null) {
            throw new XmlBlasterException(null, "Connection invalid, no ManagedConnection available");
        }
    }
}

