/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.j2ee.k2;

import java.io.PrintWriter;
import javax.resource.ResourceException;
import org.jutils.JUtilsException;
import org.jutils.log.LogChannel;
import org.jutils.log.LogDeviceConsole;
import org.jutils.log.LogableDevice;
import org.xmlBlaster.util.Global;

public class BlasterLogger
implements LogableDevice {
    private PrintWriter logWriter = null;
    private LogChannel log;
    private LogDeviceConsole console = null;
    private final Global glob;

    public BlasterLogger(Global glob) throws ResourceException {
        this.glob = glob;
        this.log = glob.getLog(null);
        try {
            glob.getProperty().set("logConsole", "false");
            this.log.removeAllDevices();
        }
        catch (JUtilsException ex) {
            ResourceException re = new ResourceException("Could not instantiate logger: " + ex);
            re.setLinkedException((Exception)ex);
            throw re;
        }
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
        this.log.info("BlasterLogger", "Setting LogWriter: " + out);
    }

    public void setLogging(boolean dolog) {
        if (dolog) {
            this.log.addLogDevice(this);
        } else {
            this.log.removeAllDevices();
        }
    }

    public void setLogLevel(String level) {
    }

    private String convertLevelToString(int level) {
        if ((level & 1) > 0) {
            return "ERROR";
        }
        if ((level & 2) > 0) {
            return "WARN";
        }
        if ((level & 4) > 0) {
            return "INFO";
        }
        if ((level & 8) > 0) {
            return "CALL";
        }
        if ((level & 0x10) > 0) {
            return "TIME";
        }
        if ((level & 0x20) > 0) {
            return "TRACE";
        }
        if ((level & 0x40) > 0) {
            return "DUMP";
        }
        return "UNKNOWN LEVEL" + level;
    }

    public void log(int level, String source, String text) {
        if (this.logWriter != null) {
            String levelString = this.convertLevelToString(level);
            String logEntry = this.log.formatLogData(levelString, level, source, text);
            this.logWriter.println(logEntry + "\n");
        } else {
            this.console.log(level, source, text);
        }
    }
}

