/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.j2ee.k2;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.j2ee.k2.BlasterConnectionImpl;
import org.xmlBlaster.j2ee.k2.BlasterCred;
import org.xmlBlaster.j2ee.k2.BlasterManagedConnectionFactory;
import org.xmlBlaster.j2ee.k2.BlasterMetaData;
import org.xmlBlaster.j2ee.k2.client.BlasterConnection;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class BlasterManagedConnection
implements ManagedConnection {
    BlasterManagedConnectionFactory mcf;
    String user;
    String pwd;
    I_XmlBlasterAccess physicalPipe;
    PrintWriter logWriter;
    boolean isDestroyed = false;
    boolean closed = false;
    String me = null;
    Vector listeners = new Vector();
    Global clonedGlob = null;
    private Set handles = Collections.synchronizedSet(new HashSet());

    public BlasterManagedConnection(BlasterManagedConnectionFactory mcf, String user, String pwd) throws ResourceException {
        this.mcf = mcf;
        this.user = user;
        this.pwd = pwd;
        this.clonedGlob = mcf.getConfig();
        this.physicalPipe = this.clonedGlob.getXmlBlasterAccess();
        System.out.println("Physical pipe: " + this.physicalPipe + " set up");
        this.doLogin();
    }

    public String toString() {
        return this.me;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        BlasterCred cred = BlasterCred.getBlasterCred(this.mcf, subject, info);
        if (cred.name == null) {
            throw new SecurityException("UserName not allowed to be null");
        }
        if (this.user != null && !this.user.equals(cred.name)) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (this.user == null) {
            this.user = cred.name;
        }
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyd");
        }
        BlasterConnectionImpl handle = new BlasterConnectionImpl(this);
        this.handles.add(handle);
        return handle;
    }

    private void destroyHandles() throws ResourceException {
        Iterator iter = this.handles.iterator();
        while (iter.hasNext()) {
            ((BlasterConnectionImpl)iter.next()).destroy();
        }
        this.handles.clear();
    }

    public void destroy() throws ResourceException {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        this.destroyHandles();
        this.physicalPipe.disconnect(new DisconnectQos());
        this.physicalPipe = null;
    }

    public void cleanup() throws ResourceException {
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyd");
        }
        this.closed = true;
        this.destroyHandles();
    }

    public void associateConnection(Object obj) throws ResourceException {
        if (!(obj instanceof BlasterConnectionImpl)) {
            throw new IllegalStateException("Cant call associateConnection with a handle that is not of type BlasterConnectionImp: " + obj.getClass().getName());
        }
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection in an illegal state, is destroyed");
        }
        BlasterConnectionImpl h = (BlasterConnectionImpl)obj;
        h.setBlasterManagedConnection(this);
        this.handles.add(h);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.removeElement(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("XA transaction not supported");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("Local transaction not supported");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyd");
        }
        return new BlasterMetaData(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    void removeHandle(BlasterConnectionImpl handle) {
        this.handles.remove(handle);
    }

    I_XmlBlasterAccess getBlasterConnection() throws XmlBlasterException {
        return this.physicalPipe;
    }

    I_XmlBlasterAccess getFailoverBlasterConnection() throws XmlBlasterException {
        return this.physicalPipe;
    }

    void handleClose(BlasterConnection impl) {
        this.closed = true;
        ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this, 1);
        ev.setConnectionHandle((Object)impl);
        Vector list = (Vector)this.listeners.clone();
        int size = list.size();
        int i = 0;
        while (i < size) {
            ConnectionEventListener l = (ConnectionEventListener)list.elementAt(i);
            l.connectionClosed(ev);
            ++i;
        }
    }

    void handleError(BlasterConnection impl, Exception ex) {
        ConnectionEvent ev = null;
        ev = ex != null ? new ConnectionEvent((ManagedConnection)this, 5, ex) : new ConnectionEvent((ManagedConnection)this, 5);
        Vector list = (Vector)this.listeners.clone();
        int size = list.size();
        int i = 0;
        while (i < size) {
            ConnectionEventListener l = (ConnectionEventListener)list.elementAt(i);
            l.connectionErrorOccurred(ev);
            ++i;
        }
    }

    String getUserName() {
        return this.user;
    }

    BlasterManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    Global getGlobal() {
        return this.clonedGlob;
    }

    private void doLogin() throws CommException {
        try {
            ConnectQos qos = new ConnectQos(this.clonedGlob, this.user, this.pwd);
            qos.setPtpAllowed(false);
            System.out.println("Physical pipe: " + this.physicalPipe + "/CQos:" + qos);
            ConnectReturnQos ret = this.physicalPipe.connect(qos, null);
            this.me = "BlasterManagedConnection/" + this.user + "/" + ret.getSecretSessionId();
        }
        catch (XmlBlasterException ex) {
            throw new CommException("Could not login : " + ex);
        }
    }
}

