/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.j2ee.k2;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.xmlBlaster.j2ee.k2.BlasterConnectionFactoryImpl;
import org.xmlBlaster.j2ee.k2.BlasterCred;
import org.xmlBlaster.j2ee.k2.BlasterLogger;
import org.xmlBlaster.j2ee.k2.BlasterManagedConnection;
import org.xmlBlaster.j2ee.util.GlobalUtil;
import org.xmlBlaster.j2ee.util.JacorbUtil;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class BlasterManagedConnectionFactory
implements ManagedConnectionFactory {
    public String myName = "Blaster";
    private Global glob;
    private GlobalUtil globalUtil;
    private String propFile = "xmlBlaster.properties";
    private String jndiName;
    private PrintWriter logWriter = null;
    private Properties props = new Properties();
    private BlasterLogger logger;
    private boolean isLogging;

    public BlasterManagedConnectionFactory() throws ResourceException {
        this.glob = new Global(new String[0], false, false);
        this.myName = this.myName + "[" + this.glob.getId() + "]";
    }

    public Object createConnectionFactory() throws ResourceException {
        this.loadPropertyFile();
        return new BlasterConnectionFactoryImpl(this, null);
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        this.loadPropertyFile();
        return new BlasterConnectionFactoryImpl(this, cxManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        BlasterCred bc = BlasterCred.getBlasterCred(this, subject, info);
        BlasterManagedConnection mc = new BlasterManagedConnection(this, bc.name, bc.pwd);
        mc.setLogWriter(this.logWriter);
        return mc;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        BlasterCred bc = BlasterCred.getBlasterCred(this, subject, info);
        Iterator connections = connectionSet.iterator();
        while (connections.hasNext()) {
            Object obj = connections.next();
            if (!(obj instanceof BlasterManagedConnection)) continue;
            BlasterManagedConnection mc = (BlasterManagedConnection)obj;
            BlasterManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (!mc.getUserName().equals(bc.name) || !mcf.equals(this)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
        if (this.logger != null) {
            this.logger.setLogWriter(out);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof BlasterManagedConnectionFactory) {
            String you = ((BlasterManagedConnectionFactory)obj).myName;
            String me = this.myName;
            return you == null ? me == null : you.equals(me);
        }
        return false;
    }

    public int hashCode() {
        if (this.myName == null) {
            return new String("").hashCode();
        }
        return this.myName.hashCode();
    }

    public void setUserName(String arg) {
        this.props.setProperty("j2ee.k2.username", arg);
    }

    public String getUserName() {
        return this.props.getProperty("j2ee.k2.username");
    }

    public void setPassword(String arg) {
        this.props.setProperty("j2ee.k2.password", arg);
    }

    public String getPassword() {
        return this.props.getProperty("j2ee.k2.password");
    }

    public void setClientProtocol(String arg) {
        this.props.setProperty("protocol", arg);
    }

    public String getClientProtocol() {
        return this.props.getProperty("protocol");
    }

    public void setRmiHostname(String arg) {
        this.props.setProperty("dispatch/clientside/plugin/rmi/hostname", arg);
    }

    public String getRmiHostname() {
        return this.props.getProperty("dispatch/clientside/plugin/rmi/hostname");
    }

    public void setRmiRegistryPort(String arg) {
        this.props.setProperty("dispatch/connection/plugin/rmi/registryPort", arg);
    }

    public String getRmiRegistryPort() {
        return this.props.getProperty("dispatch/connection/plugin/rmi/registryPort");
    }

    public void setRmiAuthserverUrl(String arg) {
        this.props.setProperty("dispatch/connection/plugin/rmi/AuthServerUrl", arg);
    }

    public String getRmiAuthserverUrl() {
        return this.props.getProperty("dispatch/connection/plugin/rmi/AuthServerUrl");
    }

    public void setIor(String arg) {
        this.props.setProperty("dispatch/callback/plugin/ior/iorString", arg);
    }

    public String getIor() {
        return this.props.getProperty("dispatch/callback/plugin/ior/iorString");
    }

    public void setIorFile(String arg) {
        this.props.setProperty("dispatch/connection/plugin/ior/iorFile", arg);
    }

    public void setIorHost(String arg) {
        this.props.setProperty("bootstrapHostname", arg);
    }

    public String getIorHost() {
        return this.props.getProperty("bootstrapHostname");
    }

    public void setIorPort(String arg) {
        this.props.setProperty("bootstrapPort", arg);
    }

    public String getIorPort() {
        return this.props.getProperty("bootstrapPort");
    }

    public String getIorFile() {
        return this.props.getProperty("dispatch/connection/plugin/ior/iorFile");
    }

    public void setSecurityPlugin(String arg) {
        this.props.setProperty("Security.Client.DefaultPlugin", arg);
    }

    public String getSecurityPlugin() {
        return this.props.getProperty("Security.Client.DefaultPlugin");
    }

    public void setSessionTimeout(String arg) {
        this.props.setProperty("session.timeout", arg);
    }

    public String getSessionTimeout() {
        return this.props.getProperty("session.timeout");
    }

    public void setMaxSessions(String arg) {
        this.props.setProperty("session.maxSessions", arg);
    }

    public String getMaxSession() {
        return this.props.getProperty("session.maxSessions");
    }

    public void setPropertyFileName(String fileName) {
        this.propFile = fileName;
    }

    public String getPropertyFileName() {
        return this.propFile;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setLogging(String loggingOn) {
        this.isLogging = new Boolean(loggingOn);
        if (this.logger != null) {
            this.logger.setLogging(this.isLogging);
        }
    }

    private void loadPropertyFile() throws IllegalStateException {
        this.globalUtil = new GlobalUtil();
        if (this.jndiName != null) {
            try {
                this.globalUtil = (GlobalUtil)new InitialContext().lookup(this.jndiName);
            }
            catch (NamingException e) {
                throw new IllegalStateException("Could not lookup GlobalUtil with JNDI " + this.jndiName + ": " + e);
            }
        }
        this.glob = this.globalUtil.newGlobal(this.propFile, this.props);
        if ("IOR".equals(this.glob.getProperty().get("protocol", "IOR"))) {
            try {
                JacorbUtil.loadJacorbProperties("jacorb.properties", this.glob);
            }
            catch (XmlBlasterException e) {
                IllegalStateException x = new IllegalStateException("Could not load jacorn properties, needed for IOR protocol to work: " + e);
                x.setLinkedException((Exception)e);
                throw x;
            }
        }
        try {
            this.logger = new BlasterLogger(this.glob);
            this.logger.setLogWriter(this.logWriter);
            this.logger.setLogging(this.isLogging);
        }
        catch (ResourceException e) {
            IllegalStateException x = new IllegalStateException("Could not load properties into Property: " + (Object)((Object)e));
            x.setLinkedException((Exception)((Object)e));
            throw x;
        }
    }

    Global getConfig() {
        return this.globalUtil.getClone(this.glob);
    }
}

