/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.j2ee.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RMISecurityManager;
import java.util.Properties;
import org.jutils.JUtilsException;
import org.jutils.init.Property;
import org.xmlBlaster.engine.Global;

public class GlobalUtil
implements Serializable {
    private transient Global engineGlobal;

    public GlobalUtil() {
    }

    public GlobalUtil(Global engineGlobal) {
        this.engineGlobal = engineGlobal;
    }

    public org.xmlBlaster.util.Global newGlobal(String propertyFileName, Properties args) throws IllegalStateException {
        org.xmlBlaster.util.Global glob = new org.xmlBlaster.util.Global(new String[0], false, false);
        org.xmlBlaster.util.Global clone = this.getClone(glob);
        this.addEngineProperties(clone);
        this.addServerProperties(clone);
        this.loadPropertyFile(clone, propertyFileName);
        this.addArguments(clone, args);
        return clone;
    }

    public void addEngineProperties(org.xmlBlaster.util.Global glob) throws IllegalStateException {
        if (this.engineGlobal != null) {
            Property p = glob.getProperty();
            String[] args = Property.propsToArgs(this.engineGlobal.getProperty().getProperties());
            try {
                p.addArgs2Props(args != null ? args : new String[]{});
            }
            catch (JUtilsException e) {
                IllegalStateException x = new IllegalStateException("Could not engine properties into global: " + e);
                throw x;
            }
        }
    }

    public org.xmlBlaster.util.Global getClone(org.xmlBlaster.util.Global global) {
        Object eg;
        org.xmlBlaster.util.Global g = global.getClone(null);
        Object engine = global.getObjectEntry("ServerNodeScope");
        Object object = eg = engine != null ? engine : this.engineGlobal;
        if (eg != null) {
            g.addObjectEntry("ServerNodeScope", eg);
        }
        return g;
    }

    public void loadPropertyFile(org.xmlBlaster.util.Global glob, String propFile) throws IllegalStateException {
        if (propFile == null) {
            return;
        }
        try {
            Property.FileInfo i;
            Property p = glob.getProperty();
            URL url = Thread.currentThread().getContextClassLoader().getResource(propFile);
            InputStream is = null;
            if (url != null) {
                try {
                    is = url.openStream();
                }
                catch (IOException ex) {
                    is = null;
                }
            }
            if (is == null && (i = p.findPath(propFile)) != null) {
                is = i.getInputStream();
            }
            if (is != null) {
                Properties prop = new Properties();
                prop.load(is);
                this.addArguments(glob, prop);
            }
        }
        catch (IOException e) {
            IllegalStateException x = new IllegalStateException("Could not load properties from file " + propFile + " :" + e);
            throw x;
        }
        catch (JUtilsException e) {
            IllegalStateException x = new IllegalStateException("Could not load properties into Property: " + e);
            throw x;
        }
    }

    public void addArguments(org.xmlBlaster.util.Global glob, Properties props) throws IllegalStateException {
        if (props == null) {
            return;
        }
        try {
            Property p = glob.getProperty();
            String[] args = Property.propsToArgs(props);
            p.addArgs2Props(args != null ? args : new String[]{});
        }
        catch (JUtilsException e) {
            IllegalStateException x = new IllegalStateException("Could not load properties into Property: " + e);
            throw x;
        }
    }

    public void addServerProperties(org.xmlBlaster.util.Global glob) throws IllegalStateException {
        try {
            glob.getProperty().set("classLoaderFactory", "org.xmlBlaster.util.classloader.ContextClassLoaderFactory");
            glob.getProperty().set("xmlBlaster.isEmbedded", "true");
            glob.getProperty().set("useSignalCatcher", "false");
        }
        catch (JUtilsException e) {
            IllegalStateException x = new IllegalStateException("Could not set serverside properties: " + e);
            throw x;
        }
    }

    public void setupSecurityManager(org.xmlBlaster.util.Global glob) throws SecurityException {
        if (glob.getProperty().get("ProtocolPlugin[RMI][1.0]", (String)null) == null) {
            return;
        }
        if (System.getSecurityManager() == null) {
            String exist = System.getProperty("java.security.policy");
            if (exist == null) {
                throw new SecurityException("You must specify a -Djava.security.policy when starting the server to be able to use the RMI driver");
            }
            System.setSecurityManager(new RMISecurityManager());
        }
    }
}

