/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.j2ee.util;

import java.io.InputStream;
import java.util.Properties;
import org.jutils.init.Property;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class JacorbUtil {
    private static final String ME = "JacorbUtil";

    public static void loadJacorbProperties(String fileName, Global glob) throws XmlBlasterException {
        if (fileName == null) {
            throw new XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION, ME, "jacorb property filename not allowed to be null");
        }
        Properties props = new Properties();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = cl.getResourceAsStream(fileName);
            if (is != null) {
                props.load(is);
                Property p = glob.getProperty();
                p.addArgs2Props(props);
            } else {
                LogChannel log = glob.getLog("j2ee");
                log.warn(ME, "No " + fileName + " found in context classpath");
            }
        }
        catch (Exception e) {
            throw new XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION, ME, "could not load jacorb properties " + e);
        }
    }
}

